/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.colorizer;

import com.aptana.ide.editors.unified.colorizer.ColorizationStyle;
import com.aptana.ide.editors.unified.colorizer.IColorizer;
import com.aptana.ide.editors.unified.colorizer.Region;
import com.aptana.ide.editors.unified.colorizer.SubTokenColorizer;
import com.aptana.ide.lexer.IToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyleRange;

public class TokenColorizer
implements IColorizer {
    private IToken token = null;
    private ColorizationStyle style = null;
    private Map<String, Region> regions = new HashMap<String, Region>();

    public void colorize(List styles, int offset, int length) {
        int baseOffset = -1;
        int baseLength = 0;
        Collection regions = this.getRegions();
        int i = 0;
        while (i < length) {
            Region region2 = null;
            for (Region region2 : regions) {
                if (region2.getOffset(length) == i) break;
                region2 = null;
            }
            if (region2 != null) {
                int nextPosition;
                ColorizationStyle regionStyle;
                if (baseLength != 0 && baseOffset != -1) {
                    int bold = this.style.isBold() ? 1 : 0;
                    int italic = this.style.isItalic() ? 2 : 0;
                    StyleRange sr = new StyleRange(baseOffset, baseLength, this.style.getForegroundColor(), this.style.getBackgroundColor(), bold | italic);
                    sr.underline = this.style.isUnderline();
                    styles.add(sr);
                    baseLength = 0;
                    baseOffset = -1;
                }
                int bold = (regionStyle = region2.getStyle()).isBold() ? 1 : 0;
                int italic = regionStyle.isItalic() ? 2 : 0;
                int regionLength = region2.getLength(length);
                if (regionLength > 0) {
                    StyleRange sr = new StyleRange(offset + region2.getOffset(length), regionLength, regionStyle.getForegroundColor(), regionStyle.getBackgroundColor(), bold | italic);
                    sr.underline = regionStyle.isUnderline();
                    styles.add(sr);
                }
                if ((nextPosition = regionLength - 1) > 0) {
                    i += nextPosition;
                }
            } else {
                ++baseLength;
                if (baseOffset == -1) {
                    baseOffset = offset + i;
                }
            }
            ++i;
        }
        if (baseLength != 0 && baseOffset != -1) {
            int bold = this.style.isBold() ? 1 : 0;
            int italic = this.style.isItalic() ? 2 : 0;
            StyleRange sr = new StyleRange(baseOffset, baseLength, this.style.getForegroundColor(), this.style.getBackgroundColor(), bold | italic);
            sr.underline = this.style.isUnderline();
            styles.add(sr);
            baseLength = 0;
            baseOffset = -1;
        }
    }

    public void addSubTokenColorization(SubTokenColorizer stc) {
    }

    public IToken getToken() {
        return this.token;
    }

    public void setToken(IToken token) {
        this.token = token;
    }

    public void setBaseColorization(ColorizationStyle style) {
        this.style = style;
    }

    public ColorizationStyle getBaseColorization() {
        return this.style;
    }

    public void addColorization(Region region) {
        this.regions.put(region.getName(), region);
    }

    public void removeColorization(String name) {
        this.regions.remove(name);
    }

    public Collection getRegions() {
        return this.regions.values();
    }

    public Region getRegion(String name) {
        return this.regions.get(name);
    }
}

