/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.errors;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.unified.errors.FileError;
import com.aptana.ide.editors.unified.errors.Messages;
import java.util.ArrayList;

public class ErrorDescriptor {
    private String _message;
    private String _fileName;
    private String _folderPath;
    private int _severity = -1;
    public static String FIELD_SEPARATOR = "~~~~";
    public static String DESCRIPTOR_SEPARATOR = "####";
    public static int NO_SEVERITY = -1;

    public String getMessage() {
        return this._message;
    }

    public String getFileName() {
        return this._fileName;
    }

    public String getFolderPath() {
        return this._folderPath;
    }

    public int getSeverity() {
        return this._severity;
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    public void setFolderPath(String folderPath) {
        this._folderPath = folderPath;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    public void setSeverity(int severity) {
        this._severity = severity;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getFileName() != null) {
            sb.append(this.getFileName());
        }
        sb.append(FIELD_SEPARATOR);
        if (this.getFolderPath() != null) {
            sb.append(this.getFolderPath());
        }
        sb.append(FIELD_SEPARATOR);
        sb.append(this.getSeverity());
        sb.append(FIELD_SEPARATOR);
        if (this.getMessage() != null) {
            sb.append(this.getMessage());
        }
        return sb.toString();
    }

    public void fromString(String values) {
        String[] vals = values.split(FIELD_SEPARATOR, 4);
        if (vals.length != 4) {
            throw new IllegalArgumentException(Messages.ErrorDescriptor_MustHaveFourValues);
        }
        if (!"".equals(vals[0])) {
            this._fileName = vals[0];
        }
        if (!"".equals(vals[1])) {
            this._folderPath = vals[1];
        }
        this._severity = Integer.parseInt(vals[2]);
        if (!"".equals(vals[3])) {
            this._message = vals[3];
        }
    }

    public static String serializeErrorDescriptors(ErrorDescriptor[] errors) {
        ArrayList<String> al = new ArrayList<String>();
        int i = 0;
        while (i < errors.length) {
            ErrorDescriptor descriptor = errors[i];
            al.add(descriptor.toString());
            ++i;
        }
        return StringUtils.join((String)DESCRIPTOR_SEPARATOR, (String[])al.toArray(new String[0]));
    }

    public static ErrorDescriptor[] deserializeErrorDescriptors(String errors) {
        if ("".equals(errors)) {
            return new ErrorDescriptor[0];
        }
        ArrayList<ErrorDescriptor> al = new ArrayList<ErrorDescriptor>();
        String[] errorDescriptors = errors.split(DESCRIPTOR_SEPARATOR);
        int i = 0;
        while (i < errorDescriptors.length) {
            String descriptor = errorDescriptors[i];
            ErrorDescriptor ed = new ErrorDescriptor();
            ed.fromString(descriptor);
            al.add(ed);
            ++i;
        }
        return al.toArray(new ErrorDescriptor[0]);
    }

    public boolean equals(Object arg0) {
        boolean result = false;
        if (arg0 instanceof ErrorDescriptor) {
            ErrorDescriptor s = (ErrorDescriptor)arg0;
            result = this.toString().equals(s.toString());
        }
        return result;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean matchesError(FileError error) {
        if (this.getFileName() != null && !"".equals(this.getFileName()) && !this.getFileName().equals(error.getFileName())) {
            return false;
        }
        if (this.getFolderPath() != null && !"".equals(this.getFolderPath()) && !this.getFolderPath().equals(error.getFolderPath())) {
            return false;
        }
        if (this.getSeverity() != NO_SEVERITY && this.getSeverity() != error.getSeverity()) {
            return false;
        }
        if (this.getMessage() != null && !"".equals(this.getMessage())) {
            return error.getMessage().matches(this.getMessage());
        }
        return false;
    }
}

