/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.errors;

import com.aptana.ide.editors.unified.IFileSourceProvider;
import com.aptana.ide.editors.unified.errors.FileError;
import com.aptana.ide.editors.unified.errors.IFileError;
import java.util.ArrayList;
import java.util.Arrays;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class UnifiedErrorReporter
implements ErrorReporter {
    IFileSourceProvider sourceProvider;
    ArrayList errors = new ArrayList();

    public UnifiedErrorReporter(IFileSourceProvider sourceProvider) {
        this.sourceProvider = sourceProvider;
    }

    public void warning(String message, String sourceURI, int line, String lineText, int lineOffset) {
        this.add(1, message, sourceURI, line, lineText, lineOffset);
    }

    public void error(String message, String sourceURI, int line, String lineText, int lineOffset) {
        this.add(2, message, sourceURI, line, lineText, lineOffset);
    }

    public void info(String message, String sourceURI, int line, String lineText, int lineOffset) {
        this.add(0, message, sourceURI, line, lineText, lineOffset);
    }

    public EvaluatorException runtimeError(String message, String sourceURI, int line, String lineText, int lineOffset) {
        return new EvaluatorException(message, sourceURI, line, lineText, lineOffset);
    }

    protected void add(int severity, String message, String sourceURI, int line, String lineText, int lineOffset) {
        FileError e = new FileError();
        message = this.cleanupMessage(message);
        int docLen = this.sourceProvider.getSourceLength();
        int totalLines = this.sourceProvider.getLineOfOffset(docLen) + 1;
        if (line > totalLines) {
            line = totalLines;
        } else if (line < 1) {
            line = 1;
        }
        int charLineOffset = this.sourceProvider.getLineOffset(line - 1);
        int lineOfOffset = this.sourceProvider.getLineOfOffset(charLineOffset);
        e.setLineNumber(lineOfOffset + 1);
        e.setOffset(charLineOffset + lineOffset);
        e.setLength(1);
        e.setSeverity(severity);
        e.setMessage(message);
        e.setFileName(sourceURI);
        this.errors.add(e);
    }

    private String cleanupMessage(String message) {
        if ("undefined labe".equals(message)) {
            return String.valueOf(message) + "l";
        }
        return message;
    }

    public IFileError[] getErrors() {
        return this.errors.toArray(new IFileError[this.errors.size()]);
    }

    public void addErrors(IFileError[] errs) {
        this.errors.addAll(Arrays.asList(errs));
    }
}

