/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.views.actions;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.views.actions.Action;
import com.aptana.ide.editors.views.actions.IAction;
import com.aptana.ide.editors.views.actions.Messages;
import java.util.ArrayList;

public class ActionSet
implements IAction {
    private String _name;
    private ArrayList _actions = new ArrayList();
    private boolean _executable = false;
    private String _toolTipText;

    public ActionSet(String name) {
        this._name = name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String getPath() {
        return "/" + this.getName() + "/";
    }

    public String getToolTipText() {
        String result = this._toolTipText;
        if (result == null) {
            result = StringUtils.format((String)Messages.ActionSet_ActionSetActions, (Object[])new Object[]{this.getName(), Integer.toString(this.getActions().length)});
        }
        return result;
    }

    public void setToolTipText(String text) {
        this._toolTipText = text;
    }

    public int getActionCount() {
        return this._actions.size();
    }

    public Action[] getActions() {
        return this._actions.toArray(new Action[0]);
    }

    public Action addAction(String name, String filename) {
        Action a = new Action(this, name, filename);
        this._actions.add(a);
        UnifiedEditorsPlugin.getDefault().getActionsManager().fireActionsChangeEvent(a);
        return a;
    }

    public Action addAction(String name, String filename, String scriptName) {
        Action a = new Action(this, name, filename, scriptName);
        this._actions.add(a);
        UnifiedEditorsPlugin.getDefault().getActionsManager().fireActionsChangeEvent(a);
        return a;
    }

    public void removeAction(String name) {
        int i = 0;
        while (i < this._actions.size()) {
            Action a = (Action)this._actions.get(i);
            if (a.getName().equals(name)) {
                this._actions.remove(i);
                UnifiedEditorsPlugin.getDefault().getActionsManager().fireActionsChangeEvent(a);
            }
            ++i;
        }
    }

    public boolean isExecutable() {
        return this._executable;
    }

    public void setExecutable(boolean b) {
        this._executable = b;
    }

    public String getFilePath() {
        return null;
    }

    public String getScriptPath() {
        return null;
    }
}

