/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.views.outline.propertyManager;

import com.aptana.ide.editors.views.outline.propertyManager.EditableProperty;
import java.util.ArrayList;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class EditableComboProperty
extends EditableProperty {
    private static final long serialVersionUID = 1L;
    private ArrayList itemTexts = new ArrayList();
    private ArrayList itemValues = new ArrayList();

    public EditableComboProperty(String id, String name) {
        super(id, name);
    }

    public void addComboItem(String name, Object value) {
        this.itemTexts.add(name);
        this.itemValues.add(value);
    }

    public void removeAllComboItems() {
        this.itemTexts.clear();
        this.itemValues.clear();
        this.setDefaultValue(null);
        this.setValue(null);
    }

    public void setDefaultValue(Object value) {
        int idx = this.itemValues.indexOf(value);
        super.setUnderlyingDefaultValue(new Integer(idx));
    }

    public Object getDefaultValue() {
        Object underlyingValue = super.getUnderlyingDefaultValue();
        if (underlyingValue instanceof Integer) {
            int idx = (Integer)underlyingValue;
            return this.itemValues.get(idx);
        }
        return null;
    }

    public PropertyDescriptor getCustomPropertyDescriptor() {
        return new ComboBoxPropertyDescriptor((Object)this.getID(), this.getName(), this.getComboItemNames());
    }

    public boolean hasDynamicPropertyDescriptor() {
        return true;
    }

    public String[] getComboItemNames() {
        String[] list = new String[this.itemTexts.size()];
        int l = 0;
        while (l < list.length) {
            list[l] = (String)this.itemTexts.get(l);
            ++l;
        }
        return list;
    }

    public void setValue(Object value) {
        int idx = this.itemValues.indexOf(value);
        if (idx >= 0) {
            this.setUnderlyingValue(new Integer(idx));
        }
    }

    public void setValueByName(String name) {
        int idx = this.itemTexts.indexOf(name);
        if (idx >= 0) {
            this.setUnderlyingValue(new Integer(idx));
        }
    }

    public void setIndex(int i) {
        if (i >= 0 && i < this.itemTexts.size()) {
            this.setUnderlyingValue(new Integer(i));
        }
    }

    public Object getValue() {
        Object comboValue = this.translateToValue(this.getUnderlyingValue());
        if (comboValue != null) {
            return comboValue;
        }
        comboValue = this.translateToValue(this.getUnderlyingDefaultValue());
        return comboValue;
    }

    public String getText() {
        String comboName = this.translateToName(this.getUnderlyingValue());
        if (comboName != null) {
            return comboName;
        }
        comboName = this.translateToName(this.getUnderlyingDefaultValue());
        return comboName;
    }

    private Object translateToValue(Object value) {
        int idx = this.getIndexOf(value);
        if (idx >= 0 && idx < this.itemValues.size()) {
            return this.itemValues.get(idx);
        }
        return null;
    }

    private String translateToName(Object value) {
        int idx = this.getIndexOf(value);
        if (idx >= 0 && idx < this.itemTexts.size()) {
            return (String)this.itemTexts.get(idx);
        }
        return null;
    }

    private int getIndexOf(Object v) {
        if (v instanceof Integer) {
            return (Integer)v;
        }
        return -1;
    }
}

