/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.views.outline.propertyManager;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.views.outline.propertyManager.EditableIntegerProperty;
import com.aptana.ide.editors.views.outline.propertyManager.Messages;
import com.aptana.ide.editors.views.outline.propertyManager.ReadableProperty;
import java.io.Serializable;
import org.eclipse.jface.viewers.ICellEditorValidator;

public abstract class PropertyFactory
implements Serializable {
    public static String TOKEN_SIZE_ID = "TokenSize";
    public static String PHASE_ID = "Hue";
    public static PropertyFactory TOKEN_SIZE_PROPERTY = new PropertyFactory(){
        private static final long serialVersionUID = 1L;

        public ReadableProperty create() {
            EditableIntegerProperty prop = new EditableIntegerProperty(TOKEN_SIZE_ID, Messages.PropertyFactory_TokenSize, 3);
            prop.setIncrement(2);
            prop.setMinimum(1);
            prop.setValidator(new TokenSizeValidator(prop));
            return prop;
        }
    };
    public static PropertyFactory PHASE_PROPERTY = new PropertyFactory(){
        private static final long serialVersionUID = -8716817710115255121L;

        public ReadableProperty create() {
            EditableIntegerProperty huePhaseShift = new EditableIntegerProperty(PHASE_ID, Messages.PropertyFactory_PhaseShift, 0);
            huePhaseShift.setMinimum(0);
            huePhaseShift.setMaximum(360);
            huePhaseShift.setIncrement(30);
            return huePhaseShift;
        }
    };

    public abstract ReadableProperty create();

    private final class TokenSizeValidator
    implements ICellEditorValidator,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final EditableIntegerProperty prop;

        private TokenSizeValidator(EditableIntegerProperty prop) {
            this.prop = prop;
        }

        public String isValid(Object value) {
            int intValue = -1;
            try {
                intValue = Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                return Messages.PropertyFactory_TokenSizeMustBeInteger;
            }
            if (intValue < this.prop.getMinimum()) {
                return StringUtils.format((String)Messages.TokenSizeGreaterThan, (int)this.prop.getMinimum());
            }
            if (intValue > this.prop.getMaximum()) {
                return StringUtils.format((String)Messages.TokenSizeLessThan, (int)this.prop.getMaximum());
            }
            if (intValue % 2 == 0) {
                return Messages.PropertyFactory_TokenMustBeOdd;
            }
            return null;
        }
    }
}

