/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.wizards;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.wizards.Messages;
import com.aptana.ide.editors.wizards.SimpleNewWizardPage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class SimpleNewFileWizard
extends Wizard
implements INewWizard {
    private SimpleNewWizardPage page;
    private ISelection selection;

    public SimpleNewFileWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = this.createNewFilePage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    protected abstract SimpleNewWizardPage createNewFilePage(ISelection var1);

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        SimpleNewFileWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SimpleNewFileWizard_Error, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(Messages.SimpleNewFileWizard_Creating) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(StringUtils.format((String)Messages.SimpleNewFileWizard_ContainerDoesNotExist, (String)containerName));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                this.throwCoreException(Messages.SimpleNewFileWizard_FileNameExists);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName(Messages.SimpleNewFileWizard_OpeningFileForEditing);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorPart part = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    if (part instanceof IUnifiedEditor) {
                        IUnifiedEditor te = (IUnifiedEditor)part;
                        te.getViewer().getTextWidget().setCaretOffset(SimpleNewFileWizard.this.getInitialCaretOffset());
                    }
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    protected int getInitialCaretOffset() {
        return this.getInitialFileContents().length();
    }

    protected abstract String getInitialFileContents();

    private InputStream openContentStream() {
        String contents = this.getInitialFileContents();
        if (contents == null) {
            contents = "";
        }
        return new ByteArrayInputStream(contents.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "com.aptana.ide.core.ui", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

