/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.views;

import com.aptana.ide.editors.unified.InstanceCreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerFilterContributorsProvider {
    private static final String TAG_FILTER = "filter";
    private static final String ATTR_CONTRIBUTING_TO_ID = "contributingToID";
    private static final String VIEWER_FILTERS_EXTENSION_NAME = "viewerFilters";
    private static final String ATTR_LANGUAGE = "language";
    private static final String ATTR_CLASS = "class";
    private static ViewerFilterContributorsProvider instance;
    private HashMap<String, Map<String, List<InstanceCreator>>> _viewerFilterContributors;

    private ViewerFilterContributorsProvider() {
        this.loadFilters();
    }

    public static ViewerFilterContributorsProvider getInstance() {
        if (instance == null) {
            instance = new ViewerFilterContributorsProvider();
        }
        return instance;
    }

    public Map<String, List<InstanceCreator>> getViewerFiltersContributors(String contributedID) {
        Map<String, List<InstanceCreator>> map = this._viewerFilterContributors.get(contributedID);
        if (map == null) {
            return new HashMap<String, List<InstanceCreator>>(0);
        }
        return map;
    }

    private void loadFilters() {
        this._viewerFilterContributors = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IExtensionPoint extensionPoint = registry.getExtensionPoint("com.aptana.ide.editors", VIEWER_FILTERS_EXTENSION_NAME);
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                this.loadFilters(elements);
                ++i;
            }
        }
    }

    private void loadFilters(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(TAG_FILTER)) {
                String language = element.getAttribute(ATTR_LANGUAGE);
                String contributingToId = element.getAttribute(ATTR_CONTRIBUTING_TO_ID);
                InstanceCreator filterCreator = new InstanceCreator(element, ATTR_CLASS);
                Map<String, List<InstanceCreator>> map = this._viewerFilterContributors.get(contributingToId);
                if (map == null) {
                    map = new HashMap<String, List<InstanceCreator>>();
                    this._viewerFilterContributors.put(contributingToId, map);
                    ArrayList<InstanceCreator> creatorList = new ArrayList<InstanceCreator>(1);
                    creatorList.add(filterCreator);
                    map.put(language, creatorList);
                } else {
                    List<InstanceCreator> list = map.get(language);
                    list.add(filterCreator);
                }
            }
            ++i;
        }
    }
}

