/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.views.outline;

import com.aptana.ide.core.StreamUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.views.outline.IPathResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public final class PathResolverProvider {
    private PathResolverProvider() {
    }

    public static IPathResolver getResolver(IEditorInput input) {
        URI uri;
        if (input instanceof FileEditorInput) {
            FileEditorInput fi = (FileEditorInput)input;
            return new IFilePathResolver(fi.getFile().getProject(), fi.getFile().getProjectRelativePath());
        }
        if (input instanceof IPathEditorInput) {
            IPathEditorInput fInput = (IPathEditorInput)input;
            return new FilePathResolver(fInput.getPath());
        }
        if (input instanceof IURIEditorInput && "file".equals((uri = ((IURIEditorInput)input).getURI()).getScheme())) {
            return new FilePathResolver(Path.fromOSString((String)new File(uri).getAbsolutePath()));
        }
        IPathEditorInput adapter = (IPathEditorInput)input.getAdapter(IPathEditorInput.class);
        if (adapter != null) {
            return new FilePathResolver(adapter.getPath());
        }
        return new NullResolver();
    }

    private static final class FilePathResolver
    implements IPathResolver {
        private File file;

        public FilePathResolver(IPath path) {
            this.file = path.toFile();
        }

        public void addChangeListener(String path, IPropertyChangeListener listener) {
        }

        public void removeChangeListener(String path, IPropertyChangeListener listener) {
        }

        private File resolveToFile(String path) {
            if (path.charAt(0) == '/') {
                return null;
            }
            Path p = new Path(path);
            File append = this.file.getParentFile();
            int a = 0;
            while (a < p.segmentCount()) {
                String segment = p.segment(a).trim();
                if (!segment.equals(".")) {
                    append = segment.equals("..") ? this.file.getParentFile() : new File(append, segment);
                }
                ++a;
            }
            return append;
        }

        public String resolveSource(String path) throws Exception {
            File file = this.resolveToFile(path);
            if (!file.exists()) {
                return null;
            }
            FileInputStream fs = new FileInputStream(file);
            return StreamUtils.readContent((InputStream)fs, (String)Charset.defaultCharset().name());
        }

        public IPath resolvePath(String path) throws Exception {
            return new Path(this.resolveToFile(path).getAbsolutePath());
        }

        public IEditorInput resolveEditorInput(String attribute) {
            File resolveToFile = this.resolveToFile(attribute);
            if (resolveToFile != null) {
                return CoreUIUtils.createJavaFileEditorInput((File)resolveToFile);
            }
            return null;
        }
    }

    private static final class IFilePathResolver
    implements IPathResolver {
        private IProject project;
        private IPath path;
        static HashMap listeners = new HashMap();

        static {
            ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IResourceDelta delta = event.getDelta();
                    if (delta != null) {
                        this.processDelta(delta);
                    }
                }

                private void processDelta(IResourceDelta delta) {
                    IResourceDelta[] affectedChildren = delta.getAffectedChildren();
                    int a = 0;
                    while (a < affectedChildren.length) {
                        IResource resource = affectedChildren[a].getResource();
                        if (resource instanceof IFile) {
                            IPath fullPath = resource.getFullPath();
                            IFilePathResolver.fireChange(fullPath);
                        }
                        this.processDelta(affectedChildren[a]);
                        ++a;
                    }
                }
            });
        }

        private static synchronized void fireChange(IPath fullPath) {
            List object = (List)listeners.get(fullPath);
            if (object == null) {
                return;
            }
            int i = 0;
            while (i < object.size()) {
                IPropertyChangeListener listener = (IPropertyChangeListener)object.get(i);
                listener.propertyChange(new PropertyChangeEvent(IFilePathResolver.class, "content", null, (Object)fullPath.toOSString()));
                ++i;
            }
        }

        public IFilePathResolver(IProject project, IPath path) {
            this.project = project;
            this.path = path;
        }

        public synchronized void addChangeListener(String path, IPropertyChangeListener listener) {
            IFile resolveToIFile = this.resolveToIFile(path);
            if (resolveToIFile == null) {
                return;
            }
            IPath fullPath = resolveToIFile.getFullPath();
            ArrayList<IPropertyChangeListener> object = (ArrayList<IPropertyChangeListener>)listeners.get(fullPath);
            if (object == null) {
                object = new ArrayList<IPropertyChangeListener>();
                listeners.put(fullPath, object);
            }
            object.add(listener);
        }

        public synchronized void removeChangeListener(String path, IPropertyChangeListener listener) {
            IFile resolveToIFile = this.resolveToIFile(path);
            if (resolveToIFile == null) {
                return;
            }
            IPath fullPath = resolveToIFile.getFullPath();
            List object = (List)listeners.get(fullPath);
            if (object == null) {
                return;
            }
            object.remove(listener);
            if (object.isEmpty()) {
                listeners.remove(fullPath);
            }
        }

        public String resolveSource(String path) throws Exception {
            IFile file = this.resolveToIFile(path);
            if (file == null) {
                return null;
            }
            if (!file.exists()) {
                return null;
            }
            InputStream contents = file.getContents(true);
            try {
                String charset = file.getCharset(true);
                String string = StreamUtils.readContent((InputStream)contents, (String)charset);
                return string;
            }
            finally {
                contents.close();
            }
        }

        private IFile resolveToIFile(String path) {
            if (path.charAt(0) == '/') {
                return this.project.getFile(path);
            }
            Path p = new Path(path);
            IPath append = this.path.removeLastSegments(1);
            int a = 0;
            while (a < p.segmentCount()) {
                String segment = p.segment(a).trim();
                if (!segment.equals(".")) {
                    if (segment.equals("..")) {
                        if (append.segmentCount() == 0) {
                            return null;
                        }
                        append = append.removeLastSegments(1);
                    } else {
                        append = append.append(segment);
                    }
                }
                ++a;
            }
            return this.project.getFile(append);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IFilePathResolver other = (IFilePathResolver)obj;
            if (this.path == null ? other.path != null : !this.path.equals((Object)other.path)) {
                return false;
            }
            return !(this.project == null ? other.project != null : !this.project.equals((Object)other.project));
        }

        public IPath resolvePath(String path) throws Exception {
            IFile resolveToIFile = this.resolveToIFile(path);
            if (resolveToIFile != null) {
                return resolveToIFile.getFullPath();
            }
            return null;
        }

        public IEditorInput resolveEditorInput(String attribute) {
            IFile resolveToIFile = this.resolveToIFile(attribute);
            if (resolveToIFile != null) {
                return new FileEditorInput(resolveToIFile);
            }
            return null;
        }
    }

    private static final class NullResolver
    implements IPathResolver {
        private NullResolver() {
        }

        public void addChangeListener(String path, IPropertyChangeListener listener) {
        }

        public void removeChangeListener(String path, IPropertyChangeListener listener) {
        }

        public IEditorInput resolveEditorInput(String attribute) {
            return null;
        }

        public String resolveSource(String path) throws Exception {
            return null;
        }
    }
}

