/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.views.outline;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.ContributedOutline;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileService;
import com.aptana.ide.editors.unified.IFileServiceChangeListener;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.lexer.IRange;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.views.outline.BaseFilter;
import com.aptana.ide.views.outline.CollapseAction;
import com.aptana.ide.views.outline.ContributionItemStub;
import com.aptana.ide.views.outline.FilterActionInfo;
import com.aptana.ide.views.outline.HidePrivateAction;
import com.aptana.ide.views.outline.IResolvableItem;
import com.aptana.ide.views.outline.IUnifiedOutlinePage;
import com.aptana.ide.views.outline.Messages;
import com.aptana.ide.views.outline.OutlineItem;
import com.aptana.ide.views.outline.SortAction;
import com.aptana.ide.views.outline.SplitOutlinesAction;
import com.aptana.ide.views.outline.UnifiedOutlineProvider;
import com.aptana.ide.views.outline.UnifiedViewerFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedQuickOutlinePage
extends ContentOutlinePage
implements IUnifiedOutlinePage,
IOpenListener {
    private static final int FILTER_REFRESH_DELAY = 200;
    private static final int REFRESH_DELAY = 500;
    private Composite _composite;
    private SashForm _outlineSash;
    private SashForm _outlineTabsSash;
    private CTabFolder _outlineTabs;
    private UnifiedEditor _editor;
    private PatternFilter _filter;
    private String _pattern;
    private WorkbenchJob _filterRefreshJob;
    private WorkbenchJob _delayedRefreshJob;
    private Text _searchBox;
    private TreeViewer _treeViewer;
    private IDocumentListener _documentListener;
    private IFileServiceChangeListener _serviceListener;
    private IDocument _document;
    private boolean _hide;
    private ActionContributionItem _sortItem;
    private ActionContributionItem _collapseItem;
    private ActionContributionItem _expandItem;
    private ActionContributionItem _hidePrivateItem;
    private ActionContributionItem _splitItem;
    private HidePrivateAction _hidePrivateAction;
    private Map<String, ContributedOutline> _outlines;
    private UnifiedOutlineProvider outlineProvider;
    private BaseFilter[] _filters;
    private ActionContributionItem openAction;
    private List<ICloseListener> closeListeners = new ArrayList<ICloseListener>();
    private ToolBarManager _toolbarManager;

    public UnifiedQuickOutlinePage(UnifiedEditor editor) {
        this._editor = editor;
        editor.getViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (UnifiedQuickOutlinePage.this.outlineProvider != null) {
                    UnifiedQuickOutlinePage.this.outlineProvider.pageActivated(UnifiedQuickOutlinePage.this);
                }
            }
        });
        editor.getViewer().getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (UnifiedQuickOutlinePage.this.outlineProvider != null) {
                    UnifiedQuickOutlinePage.this.outlineProvider.pageClosed(UnifiedQuickOutlinePage.this);
                }
            }
        });
        this._outlines = new HashMap<String, ContributedOutline>();
    }

    public void addOutline(ContributedOutline outline, String name) {
        this._outlines.put(name, outline);
    }

    private Composite createComposite(Composite parent) {
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 1;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)contentAreaLayout);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        return result;
    }

    private void createContributedOutlines(CTabFolder outlineTabs, SashForm outlineSash) {
        for (String key : this._outlines.keySet()) {
            ContributedOutline outline = this._outlines.get(key);
            CTabItem tab = new CTabItem(outlineTabs, 0);
            Composite previewComp = new Composite((Composite)outlineSash, 0);
            GridLayout contentAreaLayout = new GridLayout();
            contentAreaLayout.numColumns = 1;
            contentAreaLayout.makeColumnsEqualWidth = true;
            contentAreaLayout.marginHeight = 0;
            contentAreaLayout.marginWidth = 0;
            contentAreaLayout.verticalSpacing = 0;
            contentAreaLayout.horizontalSpacing = 0;
            previewComp.setLayout((Layout)contentAreaLayout);
            previewComp.setLayoutData((Object)new GridData(4, 4, true, true));
            Label outlineLabel = new Label(previewComp, 0);
            outlineLabel.setText(key);
            outlineLabel.setLayoutData((Object)new GridData(4, 4, true, false));
            tab.setText(key);
            SashForm preForm = new SashForm((Composite)outlineTabs, 0);
            contentAreaLayout = new GridLayout();
            contentAreaLayout.numColumns = 1;
            contentAreaLayout.makeColumnsEqualWidth = false;
            contentAreaLayout.marginHeight = 0;
            contentAreaLayout.marginWidth = 0;
            contentAreaLayout.verticalSpacing = 0;
            contentAreaLayout.horizontalSpacing = 0;
            preForm.setLayout((Layout)contentAreaLayout);
            preForm.setLayoutData((Object)new GridData(4, 4, true, true));
            outline.createControl((Composite)preForm);
            tab.setControl((Control)preForm);
        }
    }

    public void createControl(Composite parent) {
        this.createControl(parent, true);
    }

    public void createControl(Composite parent, boolean createSearchArea) {
        this._composite = this.createComposite(parent);
        if (createSearchArea) {
            this.createSearchArea(this._composite, false);
        }
        this._outlineSash = this.createSash(this._composite);
        this.createSourceSash();
        this._outlineTabsSash = this.createOutlineTabs(this._composite);
        this._treeViewer = this.createTreeViewer((Composite)this._outlineTabsSash);
        this._treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this._treeViewer.addFilter((ViewerFilter)new UnifiedViewerFilter(this));
        this._filter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                boolean result = true;
                String label = null;
                if (element instanceof OutlineItem) {
                    label = ((OutlineItem)element).getLabel();
                } else if (element instanceof IParseNode) {
                    label = UnifiedOutlineProvider.getInstance().getText(element);
                }
                if (label != null) {
                    result = this.wordMatches(label);
                }
                return result;
            }
        };
        this._treeViewer.addFilter((ViewerFilter)this._filter);
        BaseFilter[] baseFilterArray = this._filters;
        int n = this._filters.length;
        int n2 = 0;
        while (n2 < n) {
            BaseFilter filter = baseFilterArray[n2];
            this._treeViewer.addFilter((ViewerFilter)filter);
            ++n2;
        }
        this._treeViewer.addOpenListener((IOpenListener)this);
        this._filterRefreshJob = this.createRefreshJob();
        this._filterRefreshJob.setSystem(true);
        this._delayedRefreshJob = this.createDelayedRefreshJob();
        this._delayedRefreshJob.setSystem(true);
        this.createDocumentListener();
        this.createServiceListener();
        this._document = this._editor.getDocumentProvider().getDocument((Object)this._editor.getEditorInput());
        this._document.addDocumentListener(this._documentListener);
        this._editor.addFileServiceChangeListener(new IFileServiceChangeListener(){

            public void fileServiceChanged(IFileService newService) {
                if (UnifiedQuickOutlinePage.this._document != null) {
                    UnifiedQuickOutlinePage.this._document.removeDocumentListener(UnifiedQuickOutlinePage.this._documentListener);
                }
                UnifiedQuickOutlinePage.this._document = UnifiedQuickOutlinePage.this._editor.getDocumentProvider().getDocument((Object)UnifiedQuickOutlinePage.this._editor.getEditorInput());
                if (UnifiedQuickOutlinePage.this._document != null) {
                    UnifiedQuickOutlinePage.this._document.addDocumentListener(UnifiedQuickOutlinePage.this._documentListener);
                }
            }
        });
        this.updateProviders();
        this.refresh();
    }

    public void revealPosition(int documentPos) {
        UnifiedOutlineProvider provider = this.createProvider();
        Object[] originalElements = provider.getElements(this._treeViewer.getInput());
        if (originalElements == null || originalElements.length == 0) {
            return;
        }
        ArrayList<Object> elements = new ArrayList<Object>();
        final IdentityHashMap<Object, List<Object>> parents = new IdentityHashMap<Object, List<Object>>();
        Object[] objectArray = originalElements;
        int n = originalElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object el = objectArray[n2];
            elements.add(el);
            ++n2;
        }
        if (provider instanceof ITreeContentProvider) {
            ITreeContentProvider treeContentProvider = provider;
            Object[] objectArray2 = originalElements;
            int n3 = originalElements.length;
            n = 0;
            while (n < n3) {
                Object element = objectArray2[n];
                this.expandElement(element, treeContentProvider, elements, parents);
                ++n;
            }
        }
        Object bestElement = null;
        int bestElementStartingOffset = -1;
        int bestElementEndingOffset = -1;
        for (Object e : elements) {
            int start = -1;
            int end = -1;
            if (e instanceof IParseNode) {
                IParseNode node = (IParseNode)e;
                start = node.getStartingOffset();
                end = node.getEndingOffset();
            } else if (e instanceof OutlineItem) {
                int refNodeStart = ((OutlineItem)e).getReferenceNode().getStartingOffset();
                int refNodeEnd = ((OutlineItem)e).getReferenceNode().getEndingOffset();
                int elementStart = ((OutlineItem)e).getStartingOffset();
                int elementEnd = ((OutlineItem)e).getEndingOffset();
                start = refNodeStart < elementStart ? refNodeStart : elementStart;
                int n3 = end = refNodeEnd > elementEnd ? refNodeEnd : elementEnd;
            }
            if (start == -1 || start > documentPos || end < documentPos || bestElement != null && bestElementEndingOffset - bestElementStartingOffset <= end - start) continue;
            bestElement = e;
            bestElementStartingOffset = start;
            bestElementEndingOffset = end;
        }
        final Object var9_10 = bestElement;
        WorkbenchJob job = new WorkbenchJob("Initial reveal"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (UnifiedQuickOutlinePage.this._treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    UnifiedQuickOutlinePage.this._treeViewer.getControl().setRedraw(false);
                    UnifiedQuickOutlinePage.this._treeViewer.refresh(true);
                    ArrayList<Object> path = new ArrayList<Object>();
                    List p = (List)parents.get(var9_10);
                    if (p != null) {
                        path.addAll(p);
                    }
                    path.add(var9_10);
                    TreePath treePath = new TreePath(path.toArray());
                    UnifiedQuickOutlinePage.this._treeViewer.setSelection((ISelection)new TreeSelection(treePath), true);
                }
                finally {
                    UnifiedQuickOutlinePage.this._treeViewer.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
        if (bestElement != null) {
            job.schedule(200L);
        }
    }

    private UnifiedOutlineProvider createProvider() {
        UnifiedOutlineProvider provider = new UnifiedOutlineProvider();
        provider.loadExtensions();
        provider.setOutlinePage(this);
        return provider;
    }

    private WorkbenchJob createDelayedRefreshJob() {
        return new WorkbenchJob("Refresh Content"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    if (UnifiedQuickOutlinePage.this._treeViewer.getControl().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    UnifiedQuickOutlinePage.this.updateProviders();
                    UnifiedQuickOutlinePage.this._treeViewer.setSelection(null);
                    UnifiedQuickOutlinePage.this._treeViewer.refresh();
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedOutlinePage_ErrorRefreshingOutline, (Throwable)e);
                }
                catch (Error e) {
                    IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)Messages.UnifiedOutlinePage_ErrorRefreshingOutline, (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void createDocumentListener() {
        this._documentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                if (UnifiedQuickOutlinePage.this._delayedRefreshJob != null) {
                    UnifiedQuickOutlinePage.this._delayedRefreshJob.cancel();
                    UnifiedQuickOutlinePage.this._delayedRefreshJob.schedule(500L);
                }
            }
        };
    }

    private SashForm createOutlineTabs(Composite parent) {
        this._outlineTabs = new CTabFolder(parent, 1024);
        this._outlineTabs.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm sourceForm = new SashForm((Composite)this._outlineTabs, 0);
        sourceForm.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem sourceTab = new CTabItem(this._outlineTabs, 0);
        sourceTab.setText(Messages.UnifiedOutlinePage_Source);
        sourceTab.setControl((Control)sourceForm);
        this._outlineTabs.setSelection(sourceTab);
        this.createContributedOutlines(this._outlineTabs, this._outlineSash);
        return sourceForm;
    }

    private WorkbenchJob createRefreshJob() {
        return new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (UnifiedQuickOutlinePage.this._treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                if (UnifiedQuickOutlinePage.this._pattern == null) {
                    return Status.OK_STATUS;
                }
                UnifiedQuickOutlinePage.this._filter.setPattern(UnifiedQuickOutlinePage.this._pattern);
                try {
                    UnifiedQuickOutlinePage.this._treeViewer.getControl().setRedraw(false);
                    UnifiedQuickOutlinePage.this._treeViewer.refresh(true);
                    if (UnifiedQuickOutlinePage.this._pattern.length() > 0) {
                        IStructuredContentProvider provider = (IStructuredContentProvider)UnifiedQuickOutlinePage.this._treeViewer.getContentProvider();
                        Object[] elements = provider.getElements(UnifiedQuickOutlinePage.this._treeViewer.getInput());
                        int i = 0;
                        while (i < elements.length) {
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            UnifiedQuickOutlinePage.this._treeViewer.expandToLevel(elements[i], -1);
                            ++i;
                        }
                        TreeItem[] items = UnifiedQuickOutlinePage.this._treeViewer.getTree().getItems();
                        if (items.length > 0) {
                            UnifiedQuickOutlinePage.this._treeViewer.getTree().showItem(items[0]);
                        }
                    }
                }
                finally {
                    UnifiedQuickOutlinePage.this._treeViewer.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
    }

    private SashForm createSash(Composite parent) {
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 1;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        GridData gridData = new GridData(4, 4, true, true);
        gridData.exclude = true;
        SashForm result = new SashForm(parent, 512);
        result.setLayoutData((Object)gridData);
        result.setLayout((Layout)contentAreaLayout);
        result.setVisible(false);
        return result;
    }

    public Composite createSearchArea(Composite parent, boolean embedded) {
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 1;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 3;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)contentAreaLayout);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 3;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        Composite result = new Composite(top, 0);
        result.setLayout((Layout)contentAreaLayout);
        result.setLayoutData((Object)data);
        if (!embedded) {
            Label searchLabel = new Label(result, 0);
            searchLabel.setText(Messages.UnifiedOutlinePage_Filter);
        }
        int style = 0;
        style = embedded ? 4 : 2052;
        this._searchBox = new Text(result, style);
        this._searchBox.setLayoutData((Object)new GridData(4, 4, true, false));
        this._searchBox.setEditable(true);
        this._searchBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UnifiedQuickOutlinePage.this.textChanged();
            }
        });
        this._searchBox.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 || e.keyCode == 0x1000002) {
                    UnifiedQuickOutlinePage.this._treeViewer.getControl().setFocus();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        ToolBar filtersToolBar = new ToolBar(result, 256);
        filtersToolBar.setLayoutData((Object)new GridData(4, 4, false, true));
        this._toolbarManager = new ToolBarManager(filtersToolBar);
        final ArrayList filters = new ArrayList();
        EditorFileContext fileContext = this._editor.getFileContext();
        String language = fileContext.getDefaultLanguage();
        FilterActionInfo[] filterActionInfoArray = UnifiedOutlineProvider.getInstance().getFilterActionInfos(language);
        int n = filterActionInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            FilterActionInfo filterInfo;
            final FilterActionInfo info = filterInfo = filterActionInfoArray[n2];
            this._toolbarManager.add((IContributionItem)new ContributionItemStub(){

                public String getId() {
                    return info.getName();
                }

                public void fill(ToolBar parent, int index) {
                    final BaseFilter filter = info.getFilter();
                    ToolItem item = new ToolItem(parent, 32);
                    filters.add(index, filter);
                    item.setImage(info.getImageDescriptor().createImage());
                    item.setToolTipText(info.getToolTip());
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ToolItem item = (ToolItem)e.widget;
                            filter.setActive(item.getSelection());
                            UnifiedQuickOutlinePage.this._treeViewer.refresh(true);
                        }
                    });
                }
            });
            ++n2;
        }
        this._toolbarManager.update(false);
        this._toolbarManager.getControl().update();
        this._filters = filters.toArray(new BaseFilter[filters.size()]);
        return result;
    }

    private void createServiceListener() {
        this._serviceListener = new IFileServiceChangeListener(){

            public void fileServiceChanged(IFileService newService) {
                if (UnifiedQuickOutlinePage.this._document != null) {
                    UnifiedQuickOutlinePage.this._document.removeDocumentListener(UnifiedQuickOutlinePage.this._documentListener);
                }
                UnifiedQuickOutlinePage.this._document = UnifiedQuickOutlinePage.this._editor.getDocumentProvider().getDocument((Object)UnifiedQuickOutlinePage.this._editor.getEditorInput());
                if (UnifiedQuickOutlinePage.this._document != null) {
                    UnifiedQuickOutlinePage.this._document.addDocumentListener(UnifiedQuickOutlinePage.this._documentListener);
                }
            }
        };
    }

    private void createSourceSash() {
        Composite previewComp = new Composite((Composite)this._outlineSash, 0);
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 1;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        previewComp.setLayout((Layout)contentAreaLayout);
        previewComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label outlineLabel = new Label(previewComp, 0);
        outlineLabel.setText(Messages.UnifiedOutlinePage_Source);
        outlineLabel.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private TreeViewer createTreeViewer(Composite parent) {
        TreeViewer result = new TreeViewer(new Tree(parent, 772));
        this.outlineProvider = this.createProvider();
        result.setLabelProvider((IBaseLabelProvider)this.outlineProvider);
        result.setContentProvider((IContentProvider)this.outlineProvider);
        result.setInput((Object)this._editor);
        result.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        result.setComparer(new IElementComparer(){

            public boolean equals(Object a, Object b) {
                boolean result = false;
                if (a instanceof OutlineItem && b instanceof OutlineItem) {
                    OutlineItem item1 = (OutlineItem)a;
                    OutlineItem item2 = (OutlineItem)b;
                    result = item1.equals(item2);
                } else if (a instanceof IParseNode && b instanceof IParseNode) {
                    if (a == b) {
                        result = true;
                    } else {
                        IParseNode node1 = (IParseNode)a;
                        IParseNode node2 = (IParseNode)b;
                        String path1 = node1.getUniquePath();
                        String path2 = node2.getUniquePath();
                        result = path1.equals(path2);
                    }
                } else {
                    result = a == b;
                }
                return result;
            }

            public int hashCode(Object element) {
                return 0;
            }
        });
        return result;
    }

    public void dispose() {
        super.dispose();
        if (this._delayedRefreshJob != null && this._editor != null) {
            this._editor.getDocumentProvider().getDocument((Object)this._editor.getEditorInput()).removeDocumentListener(this._documentListener);
            this._editor.removeFileServiceChangeListener(this._serviceListener);
        }
    }

    @Override
    public Map<String, ContributedOutline> getContributedOutlines() {
        return this._outlines;
    }

    public Control getControl() {
        return this._composite;
    }

    @Override
    public SashForm getOutlineSash() {
        return this._outlineSash;
    }

    @Override
    public CTabFolder getOutlineTabs() {
        return this._outlineTabs;
    }

    @Override
    public TreeViewer getTreeViewer() {
        return this._treeViewer;
    }

    @Override
    public UnifiedEditor getUnifiedEditor() {
        return this._editor;
    }

    @Override
    public boolean hidePrivateMembers() {
        return this._hide;
    }

    @Override
    public void refresh() {
        if (!this._treeViewer.getControl().isDisposed()) {
            this._treeViewer.refresh();
        }
    }

    private void removeOpenActionIfNeeded() {
        if (this.openAction != null) {
            this._toolbarManager.remove((IContributionItem)this.openAction);
            this.openAction = null;
            this._toolbarManager.update(false);
        }
    }

    public void open(OpenEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof IResolvableItem) {
                IResolvableItem item = (IResolvableItem)element;
                if (item.isResolvable()) {
                    if (item instanceof IParseNode) {
                        int position = ((IParseNode)item).getStartingOffset();
                        this._editor.selectAndReveal(position, 0);
                        return;
                    }
                } else if (item instanceof OutlineItem) {
                    OutlineItem outlineItem = (OutlineItem)selection.getFirstElement();
                    if (this._treeViewer != null && this._treeViewer.getTree() != null && !this._treeViewer.getTree().isDisposed() && this._treeViewer.getTree().isFocusControl()) {
                        this._editor.selectAndReveal(outlineItem.getStartingOffset(), 0);
                    }
                }
            }
            if (element instanceof IRange) {
                int position = ((IRange)element).getStartingOffset();
                this._editor.selectAndReveal(position, 0);
            }
            this.notifyCloseListeners();
        } else {
            this.removeOpenActionIfNeeded();
            this._editor.getViewer().removeRangeIndication();
        }
    }

    public void contributeToQuickOutlineMenu(IMenuManager manager) {
        if (this._outlines.size() > 0) {
            SplitOutlinesAction splitAction = new SplitOutlinesAction(this);
            splitAction.setEnabled(this._composite.isReparentable());
            this._splitItem = new ActionContributionItem((IAction)splitAction);
            manager.add((IContributionItem)this._splitItem);
        }
        SortAction sortAction = new SortAction(this);
        IPreferenceStore store = UnifiedEditorsPlugin.getDefault().getPreferenceStore();
        boolean sort = store.getBoolean("com.aptana.ide.editors.SORT_OUTLINE_ALPHABETICALLY");
        sortAction.setChecked(sort);
        if (sort) {
            this.getTreeViewer().setSorter((ViewerSorter)SortAction.SORTER);
        }
        this._sortItem = new ActionContributionItem((IAction)sortAction);
        manager.add((IContributionItem)this._sortItem);
        this._hidePrivateAction = new HidePrivateAction(this);
        this._hidePrivateItem = new ActionContributionItem((IAction)this._hidePrivateAction);
        manager.add((IContributionItem)this._hidePrivateItem);
        CollapseAction collapseAction = new CollapseAction(this);
        this._collapseItem = new ActionContributionItem((IAction)collapseAction);
        manager.add((IContributionItem)this._collapseItem);
        Action expandAction = new Action(Messages.UnifiedOutlinePage_ExpandAll){

            public void run() {
                UnifiedQuickOutlinePage.this.getTreeViewer().expandAll();
            }
        };
        expandAction.setImageDescriptor(UnifiedEditorsPlugin.getImageDescriptor("icons/expandall.gif"));
        expandAction.setToolTipText(Messages.UnifiedOutlinePage_CollapseAll);
        this._expandItem = new ActionContributionItem((IAction)expandAction);
        manager.add((IContributionItem)this._expandItem);
    }

    public void setFocus() {
        this._treeViewer.getControl().setFocus();
    }

    public Control getSearchBox() {
        return this._searchBox;
    }

    private void textChanged() {
        this._filterRefreshJob.cancel();
        this._filterRefreshJob.schedule(200L);
        this._pattern = this._searchBox.getText();
        this._filter.setPattern(this._pattern);
        Iterator<ContributedOutline> outlineIter = this._outlines.values().iterator();
        while (outlineIter.hasNext()) {
            outlineIter.next().setFilterText(this._pattern);
        }
    }

    @Override
    public void togglePrivateMemberVisibility() {
        this._hide = !this._hide;
        this.refresh();
    }

    public void addCloseListener(ICloseListener listener) {
        this.closeListeners.add(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (this.openAction != null) {
            this._toolbarManager.remove((IContributionItem)this.openAction);
            this._toolbarManager.update(true);
            this._toolbarManager.getControl().getParent().layout(true, true);
        }
        if (selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof IResolvableItem) {
                IResolvableItem item = (IResolvableItem)element;
                if (item.isResolvable()) {
                    this.openAction = new ActionContributionItem((IAction)new OpenExternalAction(item));
                    this._toolbarManager.add((IContributionItem)this.openAction);
                    this._toolbarManager.update(true);
                    this._toolbarManager.getControl().getParent().layout(true, true);
                    while (!item.stillHighlight()) {
                        if ((item = item.getParentItem()) != null) continue;
                        return;
                    }
                    if (item instanceof IParseNode) {
                        int position = ((IParseNode)item).getStartingOffset();
                        this._editor.selectAndReveal(position, 0);
                        return;
                    }
                } else {
                    this.removeOpenActionIfNeeded();
                }
            }
            this.removeOpenActionIfNeeded();
        } else {
            this.removeOpenActionIfNeeded();
            this._editor.getViewer().removeRangeIndication();
        }
    }

    private void notifyCloseListeners() {
        for (ICloseListener listener : this.closeListeners) {
            listener.doClose();
        }
    }

    private void updateProviders() {
        EditorFileContext fileContext = this._editor.getFileContext();
        if (fileContext != null) {
            UnifiedOutlineProvider provider = UnifiedOutlineProvider.getInstance();
            provider.setCurrentLanguage(fileContext.getDefaultLanguage());
            provider.fireBeforeRefreshEvent(fileContext);
        }
    }

    private void expandElement(Object element, ITreeContentProvider treeContentProvider, List<Object> elements, Map<Object, List<Object>> parents) {
        Object child;
        Object[] children = treeContentProvider.getChildren(element);
        List<Object> elementParentsList = parents.get(element);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            child = objectArray[n2];
            elements.add(child);
            ArrayList<Object> parentsList = new ArrayList<Object>();
            if (elementParentsList != null) {
                parentsList.addAll(elementParentsList);
            }
            parentsList.add(element);
            parents.put(child, parentsList);
            ++n2;
        }
        objectArray = children;
        n = children.length;
        n2 = 0;
        while (n2 < n) {
            child = objectArray[n2];
            this.expandElement(child, treeContentProvider, elements, parents);
            ++n2;
        }
    }

    public static interface ICloseListener {
        public void doClose();
    }

    private static final class OpenExternalAction
    extends Action {
        IResolvableItem item;
        String editorId;

        OpenExternalAction(IResolvableItem item) {
            try {
                IEditorDescriptor editorDescriptor = IDE.getEditorDescriptor((String)item.getEditorInput().getName());
                this.editorId = editorDescriptor.getId();
                this.setImageDescriptor(editorDescriptor.getImageDescriptor());
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage());
            }
            this.item = item;
            this.setToolTipText(Messages.UnifiedOutlinePage_Open);
        }

        public void run() {
            IEditorInput input = this.item.getEditorInput();
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            try {
                IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)input, (String)this.editorId);
                if (openEditor instanceof ITextEditor) {
                    ITextEditor ed = (ITextEditor)openEditor;
                    if (this.item instanceof IRange) {
                        int position = ((IRange)this.item).getStartingOffset();
                        ed.selectAndReveal(position, 0);
                        return;
                    }
                    if (this.item instanceof OutlineItem) {
                        int position = ((OutlineItem)((Object)this.item)).getStartingOffset();
                        ed.selectAndReveal(position, 0);
                        return;
                    }
                }
                return;
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)UnifiedEditorsPlugin.getDefault(), (String)e.getMessage());
                return;
            }
        }
    }
}

