/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer;

import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.lexer.LexerException;
import com.aptana.ide.lexer.Messages;
import com.aptana.ide.lexer.Range;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLexer
implements ILexer {
    private Map<String, ITokenList> _tokensByLanguage = new HashMap<String, ITokenList>();
    private ITokenList _currentTokenList;
    private int _currentGroupIndex;
    private LexemeList _lexemeCache;
    public int hitCount;
    public int missCount;
    protected char[] source;
    protected int eofOffset;
    protected int lastMatchedTokenIndex;
    protected int currentOffset;

    public AbstractLexer() {
        this.setSource(new char[0]);
    }

    public void setLexemeCache(LexemeList lexemeCache) {
        this._lexemeCache = lexemeCache;
    }

    protected Lexeme getCachedLexeme() {
        Lexeme result = null;
        if (this._lexemeCache != null) {
            int index = this._lexemeCache.getLexemeIndex(this.currentOffset);
            if (index >= 0) {
                result = this._lexemeCache.get(index);
                this.currentOffset += result.length;
            } else {
                Range range = this._lexemeCache.getAffectedRegion();
                if (!range.containsOffset(this.currentOffset) && (index = -(index + 1)) < this._lexemeCache.size()) {
                    int startingOffset = range.getStartingOffset();
                    Lexeme candidate = this._lexemeCache.get(index);
                    if (this.currentOffset >= range.getEndingOffset() || this.currentOffset < startingOffset && candidate.getEndingOffset() <= startingOffset) {
                        result = candidate;
                        this.currentOffset = result.getEndingOffset();
                    }
                }
            }
        }
        if (result == null) {
            ++this.missCount;
        } else {
            ++this.hitCount;
        }
        return result;
    }

    public char getCharacterAt(int offset) {
        char result = '\u0000';
        if (offset < this.source.length) {
            result = this.source[offset];
        }
        return result;
    }

    public int getCurrentOffset() {
        return this.currentOffset;
    }

    public ITokenList getCurrentTokenList() {
        return this._currentTokenList;
    }

    public void setCurrentOffset(int offset) {
        this.currentOffset = offset;
    }

    public int getEOFOffset() {
        return this.eofOffset;
    }

    public void setEOFOffset(int offset) {
        this.eofOffset = offset;
    }

    public String getGroup() {
        return this._currentTokenList.getCurrentGroup();
    }

    public void setGroup(String groupName) throws LexerException {
        this._currentTokenList.setCurrentGroup(groupName);
        this._currentGroupIndex = -1;
    }

    public void setIgnoreSet(String language, int[] set) {
        ITokenList tokens = this.getTokenList(language);
        tokens.setIgnoreSet(set);
    }

    public String getLanguage() {
        return this._currentTokenList.getLanguage();
    }

    public String[] getLanguages() {
        Set<String> keySet = this._tokensByLanguage.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public void setLanguage(String language) throws LexerException {
        ITokenList tokenList = this._tokensByLanguage.get(language);
        if (tokenList == null) {
            throw new LexerException(String.valueOf(Messages.Lexer_Unrecognized_Language) + language, null);
        }
        this._currentTokenList = tokenList;
        this.hitCount = 0;
        this.missCount = 0;
    }

    public void setLanguageAndGroup(String language, String group) throws LexerException {
        this.setLanguage(language);
        this.setGroup(group);
    }

    public String getSource() {
        return new String(this.source);
    }

    public int getSourceLength() {
        return this.source.length;
    }

    public void setSource(char[] value) {
        this.source = value;
        this.currentOffset = 0;
        this.setEOFOffset(this.source.length);
    }

    public void setSource(String value) {
        this.setSource(value.toCharArray());
    }

    public ITokenList getTokenList(String language) {
        ITokenList result = null;
        if (this._tokensByLanguage.containsKey(language)) {
            result = this._tokensByLanguage.get(language);
        }
        return result;
    }

    public boolean isEOS() {
        return this.currentOffset >= this.eofOffset;
    }

    public void addLanguage(ITokenList tokens) {
        this._tokensByLanguage.put(tokens.getLanguage(), tokens);
    }

    public void seal() throws LexerException {
        String[] languages = this.getLanguages();
        int i = 0;
        while (i < languages.length) {
            String language = languages[i];
            ITokenList tokens = this.getTokenList(language);
            tokens.seal();
            ++i;
        }
    }

    protected Lexeme createLexeme(IToken token, String text, int offset) {
        return new Lexeme(token, text, offset);
    }

    public abstract Range find(String var1) throws LexerException;

    protected abstract int match();

    public void setLexerState(String group, int offset) throws LexerException {
        this.setGroup(group);
        this.setCurrentOffset(offset);
    }

    public void setLexerState(String group, char[] source, int offset, LexemeList cache) throws LexerException {
        this.setGroup(group);
        this.setSource(source);
        this.setCurrentOffset(offset);
        this._lexemeCache = cache;
    }

    public Lexeme getNextLexeme() {
        Lexeme result = null;
        boolean inIgnoreSet = true;
        while (inIgnoreSet && this.currentOffset < this.eofOffset) {
            result = this.getCachedLexeme();
            if (result != null) break;
            int start = this.currentOffset;
            int position = this.match();
            int tokenIndex = this.lastMatchedTokenIndex;
            if (tokenIndex != -1) {
                ITokenList tokenList = this.getCurrentTokenList();
                IToken token = tokenList.get(tokenIndex);
                int[] ignoreSet = tokenList.getIgnoreSet();
                boolean desirableType = true;
                if (ignoreSet != null) {
                    int typeIndex = token.getTypeIndex();
                    int i = 0;
                    while (i < ignoreSet.length) {
                        int current = ignoreSet[i];
                        if (current >= typeIndex) {
                            desirableType = current > typeIndex;
                            break;
                        }
                        ++i;
                    }
                }
                if (desirableType) {
                    int lexemeLength = position - start;
                    String text = new String(this.source, start, lexemeLength);
                    result = this.createLexeme(token, text, start);
                    inIgnoreSet = false;
                }
                this.currentOffset = position;
                int groupIndex = token.getNewLexerGroupIndex();
                if (groupIndex == this._currentGroupIndex) continue;
                tokenList.setCurrentGroup(groupIndex);
                this._currentGroupIndex = groupIndex;
                continue;
            }
            inIgnoreSet = false;
        }
        return result;
    }
}

