/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.lexer.matcher.AndMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.ide.lexer.matcher.Messages;
import com.aptana.ide.lexer.matcher.NameValueChangeListener;
import com.aptana.ide.lexer.matcher.model.CategoryGroupElement;
import com.aptana.ide.lexer.matcher.model.MatcherElement;
import com.aptana.ide.lexer.matcher.model.TokenGroupElement;
import com.aptana.xml.INode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractTextMatcher
extends MatcherElement
implements ITextMatcher {
    private static final String EMPTY_STRING = "";
    private IToken _matchedToken;
    private String _name;
    private Map<String, String> _valuesByName;
    private List<NameValueChangeListener> _nameValueChangeListeners;
    protected IToken token;

    public AbstractTextMatcher() {
        this.addChildTypes();
    }

    protected void accept(char[] source, int startingOffset, int endingOffset, IToken token) {
        if (token != null) {
            this.setMatchedToken(token);
        }
        if (this._name != null && this._name.length() > 0) {
            String text = new String(source, startingOffset, endingOffset - startingOffset);
            this.setNameValue(this._name, text);
        }
    }

    public abstract void addChildTypes();

    public void addFirstCharacters(MatcherMap map) {
        this.addFirstCharacters(map, this);
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        map.addUncategorizedMatcher(target);
    }

    public void addNameValueChangeListener(NameValueChangeListener listener) {
        if (listener != null) {
            AbstractTextMatcher top = this.getExpressionRoot();
            if (top._nameValueChangeListeners == null) {
                top._nameValueChangeListeners = new ArrayList<NameValueChangeListener>();
            }
            if (!top._nameValueChangeListeners.contains(listener)) {
                top._nameValueChangeListeners.add(listener);
            }
        }
    }

    public boolean canMatchNothing() {
        return false;
    }

    protected void createToken(ITokenList tokenList) {
        String type = this.getType();
        if (type != null && type.length() > 0) {
            String group = this.getGroup();
            String category = this.getCategory();
            String newGroup = this.getSwitchTo();
            IToken token = tokenList.createToken();
            token.setLexerGroup(group);
            token.setCategory(category);
            token.setType(type);
            token.setNewLexerGroup(newGroup);
            try {
                tokenList.add(token);
                this.token = token;
            }
            catch (IllegalArgumentException e) {
                this.getDocument().sendError(e.getMessage(), this);
            }
        }
    }

    private void fireNameValueChange(String name, String oldValue, String newValue) {
        AbstractTextMatcher top = this.getExpressionRoot();
        if (top._nameValueChangeListeners != null) {
            int i = 0;
            while (i < top._nameValueChangeListeners.size()) {
                NameValueChangeListener listener = top._nameValueChangeListeners.get(i);
                listener.nameValueChanged(name, oldValue, newValue);
                ++i;
            }
        }
    }

    protected AbstractTextMatcher getExpressionRoot() {
        AbstractTextMatcher result = this;
        while (result != null) {
            INode parent = result.getParent();
            if (!(parent instanceof AbstractTextMatcher)) break;
            result = (AbstractTextMatcher)parent;
        }
        return result;
    }

    public IToken getMatchedToken() {
        return this._matchedToken;
    }

    public String getName() {
        return this._name;
    }

    protected String getNameValue(String name) {
        String result = EMPTY_STRING;
        AbstractTextMatcher top = this.getExpressionRoot();
        if (top._valuesByName != null && top._valuesByName.containsKey(name)) {
            result = top._valuesByName.get(name);
        }
        return result;
    }

    public IToken getToken() {
        return this.token;
    }

    public abstract int match(char[] var1, int var2, int var3);

    public void removeNameValueChangeListener(NameValueChangeListener listener) {
        AbstractTextMatcher top = this.getExpressionRoot();
        if (top._nameValueChangeListeners != null) {
            top._nameValueChangeListeners.remove(listener);
        }
    }

    protected void setMatchedToken(IToken token) {
        this._matchedToken = token;
        INode parent = this.getParent();
        if (parent != null && parent instanceof AbstractTextMatcher) {
            ((AbstractTextMatcher)parent).setMatchedToken(token);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    protected void setNameValue(String name, String value) {
        AbstractTextMatcher top = this.getExpressionRoot();
        if (top._valuesByName == null) {
            top._valuesByName = new HashMap<String, String>();
        }
        String oldValue = null;
        if (top._valuesByName.containsKey(name)) {
            oldValue = top._valuesByName.get(name);
        }
        top._valuesByName.put(name, value);
        this.fireNameValueChange(name, oldValue, value);
    }

    protected void setParent(INode parent) {
        AbstractTextMatcher top;
        super.setParent(parent);
        if (this._nameValueChangeListeners != null && (top = this.getExpressionRoot()) != this) {
            while (this._nameValueChangeListeners.size() > 0) {
                NameValueChangeListener listener = this._nameValueChangeListeners.get(0);
                top.addNameValueChangeListener(listener);
                this._nameValueChangeListeners.remove(listener);
            }
            this._nameValueChangeListeners = null;
        }
    }

    public String toString() {
        Class<?> thisClass = this.getClass();
        String fullName = thisClass.getName();
        String thisPackage = thisClass.getPackage().getName();
        String result = thisPackage != null && thisPackage.length() > 0 ? fullName.substring(thisPackage.length() + 1) : fullName;
        return result;
    }

    protected void validateLocal() {
        INode parent = this.getParent();
        String type = this.getType();
        if (parent instanceof CategoryGroupElement) {
            if (!this.getTypeDefinedInSubtree()) {
                if (this.getChildCount() > 0) {
                    this.getDocument().sendError(Messages.AbstractMatcher_No_Type_On_Self_Or_Descendants, this);
                } else {
                    this.getDocument().sendError(Messages.AbstractMatcher_No_Type, this);
                }
            }
        } else if (parent instanceof TokenGroupElement) {
            String category = this.getCategory();
            if (type == null || type.length() == 0) {
                this.getDocument().sendError(Messages.AbstractMatcher_No_Type, this);
            }
            if (category == null || category.length() == 0) {
                this.getDocument().sendError(Messages.AbstractMatcher_No_Category, this);
            }
        } else if (type == null || type.length() == 0) {
            String category;
            boolean insideCategoryGroup = false;
            while (parent != null) {
                if (parent instanceof CategoryGroupElement) {
                    insideCategoryGroup = true;
                    break;
                }
                parent = parent.getParent();
            }
            if (!(insideCategoryGroup || (category = this.getCategory()) != null && category.length() != 0)) {
                this.getDocument().sendError(Messages.AbstractMatcher_No_Category, this);
            }
        }
    }

    protected void wrapChildrenInAndElement() {
        if (this.getChildCount() > 1) {
            AndMatcher and = new AndMatcher();
            while (this.getChildCount() > 0) {
                and.appendChild(this.getChild(0));
            }
            this.appendChild(and);
        }
    }
}

