/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.CharacterClassMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.ide.lexer.matcher.Messages;
import com.aptana.ide.lexer.matcher.StringMatcher;
import com.aptana.ide.lexer.matcher.ZeroOrMoreMatcher;

public class CommentMatcher
extends AbstractTextMatcher {
    private ITextMatcher _startComment;
    private ITextMatcher _endComment;

    public CommentMatcher() {
        this.setStart(new StringMatcher("//"));
        ZeroOrMoreMatcher zom = new ZeroOrMoreMatcher();
        CharacterClassMatcher cc = new CharacterClassMatcher("\r\n");
        cc.setNegate(true);
        zom.appendChild(cc);
        this.setEnd(zom);
    }

    public void addChildTypes() {
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        if (this._startComment != null) {
            this._startComment.addFirstCharacters(map, target);
        }
    }

    public int match(char[] source, int offset, int eofset) {
        int result = -1;
        if (this._startComment != null && this._endComment != null && (result = this._startComment.match(source, offset, eofset)) != -1) {
            while (result < eofset) {
                int endResult = this._endComment.match(source, result, eofset);
                if (endResult != -1) {
                    result = endResult;
                    break;
                }
                ++result;
            }
        }
        if (result != -1) {
            this.accept(source, offset, result, this.token);
        }
        return result;
    }

    public void setEnd(String end) {
        this.setEnd(new StringMatcher(end));
    }

    public void setEnd(ITextMatcher end) {
        this._endComment = end;
    }

    public void setStart(String start) {
        this.setStart(new StringMatcher(start));
    }

    public void setStart(ITextMatcher start) {
        this._startComment = start;
    }

    protected void validateLocal() {
        super.validateLocal();
        if (this._startComment == null) {
            this.getDocument().sendError(Messages.CommentMatcher_Start_Not_Defined, this);
        } else if (this._startComment instanceof AbstractTextMatcher) {
            ((AbstractTextMatcher)this._startComment).validate();
        }
        if (this._endComment == null) {
            this.getDocument().sendError(Messages.CommentMatcher_End_Not_Defined, this);
        } else if (this._endComment instanceof AbstractTextMatcher) {
            ((AbstractTextMatcher)this._endComment).validate();
        }
    }
}

