/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.Messages;
import com.aptana.ide.lexer.matcher.StringMatcher;
import com.aptana.xml.INode;
import java.util.ArrayList;

class MultiwordMatcher
extends AbstractTextMatcher {
    int maxLength;
    ArrayList<ITextMatcher> childs = new ArrayList();
    AbstractTextMatcher parent;
    CharTable cTable = new CharTable();

    public MultiwordMatcher(AbstractTextMatcher parent) {
        this.parent = parent;
    }

    public void addChildTypes() {
    }

    public void appendChild(INode child) {
        this.childs.add((ITextMatcher)child);
        if (child instanceof StringMatcher) {
            StringMatcher cmt = (StringMatcher)child;
            this.cTable.add(cmt.getText(), 0, cmt);
            this.maxLength = Math.max(cmt.getText().length(), this.maxLength);
            return;
        }
        throw new IllegalArgumentException(Messages.MultiwordMatcher_Unsupported_type);
    }

    public int match(char[] source, int offset, int eofOffset) {
        int min = Math.min(offset + this.maxLength, eofOffset);
        CharTable ct = this.cTable;
        CharTable lastMatch = null;
        int a = offset;
        while (a < min) {
            char c = source[a];
            if ((ct = ct.select(c)) == null) {
                if (lastMatch != null) {
                    this.parent.accept(source, offset, a, lastMatch.primaryMatcher);
                    return a;
                }
                return -1;
            }
            if (ct.primaryMatcher != null) {
                if (ct.count == 0) {
                    this.parent.accept(source, offset, ++a, ct.primaryMatcher);
                    return a;
                }
                lastMatch = ct;
            }
            ++a;
        }
        return -1;
    }

    static final class CharTable {
        IToken primaryMatcher;
        int count = 0;
        private CharTable[] childs = new CharTable[100];

        CharTable() {
        }

        public CharTable select(char c) {
            if (c >= this.childs.length) {
                return null;
            }
            return this.childs[c];
        }

        public void internalAddChar(char c, CharTable table) {
            ++this.count;
            char e = c;
            if (e >= this.childs.length) {
                CharTable[] newChar = new CharTable[e + '\u0001'];
                System.arraycopy(this.childs, 0, newChar, 0, this.childs.length);
                this.childs = newChar;
            }
            this.childs[e] = table;
        }

        public void add(String word, int offset, AbstractTextMatcher token) {
            int last = word.length();
            if (last == offset) {
                this.primaryMatcher = token.token;
                return;
            }
            char c = word.charAt(offset);
            CharTable select = this.select(c);
            if (select == null) {
                CharTable newT = new CharTable();
                this.internalAddChar(c, newT);
                select = newT;
            }
            select.add(word, offset + 1, token);
        }
    }
}

