/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.matcher.AndMatcher;
import com.aptana.ide.lexer.matcher.CharacterClassMatcher;
import com.aptana.ide.lexer.matcher.CharacterMatcher;
import com.aptana.ide.lexer.matcher.DigitMatcher;
import com.aptana.ide.lexer.matcher.EndOfFileMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.LookaheadMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.ide.lexer.matcher.OneOrMoreMatcher;
import com.aptana.ide.lexer.matcher.OptionalMatcher;
import com.aptana.ide.lexer.matcher.OrMatcher;
import com.aptana.ide.lexer.matcher.WhitespaceMatcher;
import com.aptana.ide.lexer.matcher.ZeroOrMoreMatcher;

public class NumberMatcher
extends AndMatcher {
    private boolean _matchNegative;
    private boolean _matchPositive;
    private boolean _matchIntegerPart;
    private boolean _matchFractionPart;
    private boolean _matchSciNotation;

    public NumberMatcher() {
        this(true, true, true, true, false);
    }

    public NumberMatcher(boolean hasNegative, boolean hasPositive, boolean hasIntegerPart, boolean hasFractionPart, boolean hasScientificNotation) {
        this._matchNegative = hasNegative;
        this._matchPositive = hasPositive;
        this._matchIntegerPart = hasIntegerPart;
        this._matchFractionPart = hasFractionPart;
        this._matchSciNotation = hasScientificNotation;
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        if (this._matchPositive) {
            map.addCharacterMatcher('+', target);
        }
        if (this._matchNegative) {
            map.addCharacterMatcher('-', target);
        }
        if (this._matchFractionPart) {
            map.addCharacterMatcher('.', target);
        }
        map.addDigitMatcher(target);
    }

    private void buildMatcher() {
        this.addPlusOrMinus();
        this.addIntegerPart();
        this.addFractionPart();
        this.addScientificNotation();
    }

    private void addFractionPart() {
        if (this._matchFractionPart) {
            CharacterMatcher dot = new CharacterMatcher('.');
            OneOrMoreMatcher digits = new OneOrMoreMatcher();
            digits.appendChild(new DigitMatcher());
            WhitespaceMatcher whitespace = new WhitespaceMatcher();
            EndOfFileMatcher eof = new EndOfFileMatcher();
            OrMatcher whitespaceOrEOF = new OrMatcher();
            whitespaceOrEOF.appendChild(whitespace);
            whitespaceOrEOF.appendChild(eof);
            LookaheadMatcher lookahead = new LookaheadMatcher();
            lookahead.appendChild(whitespaceOrEOF);
            OrMatcher or = new OrMatcher();
            or.appendChild(digits);
            or.appendChild(lookahead);
            AndMatcher and = new AndMatcher();
            and.appendChild(dot);
            and.appendChild(or);
            OptionalMatcher option = new OptionalMatcher();
            option.appendChild(and);
            this.appendChild(option);
        }
    }

    private void addIntegerPart() {
        if (this._matchIntegerPart) {
            ZeroOrMoreMatcher repetition = new ZeroOrMoreMatcher();
            repetition.appendChild(new DigitMatcher());
            this.appendChild(repetition);
        }
    }

    private void addScientificNotation() {
        if (this._matchSciNotation) {
            CharacterClassMatcher exp = new CharacterClassMatcher("eE");
            OptionalMatcher plusOrMinus = new OptionalMatcher();
            plusOrMinus.appendChild(new CharacterClassMatcher("-+"));
            OneOrMoreMatcher digits = new OneOrMoreMatcher();
            digits.appendChild(new DigitMatcher());
            AndMatcher group = new AndMatcher();
            group.appendChild(exp);
            group.appendChild(plusOrMinus);
            group.appendChild(digits);
            OptionalMatcher optional = new OptionalMatcher();
            optional.appendChild(group);
            this.appendChild(optional);
        }
    }

    private void addPlusOrMinus() {
        if (this._matchPositive || this._matchNegative) {
            OptionalMatcher option = new OptionalMatcher();
            if (this._matchPositive && this._matchNegative) {
                option.appendChild(new CharacterClassMatcher("-+"));
            } else if (this._matchPositive) {
                option.appendChild(new CharacterMatcher('+'));
            } else {
                option.appendChild(new CharacterMatcher('-'));
            }
            this.appendChild(option);
        }
    }

    public int match(char[] source, int offset, int eofset) {
        int result;
        if (this.getChildCount() == 0) {
            this.buildMatcher();
        }
        if ((result = super.match(source, offset, eofset)) == offset) {
            result = -1;
        } else if (result - 1 == offset) {
            char c = source[result - 1];
            switch (c) {
                case '+': 
                case '-': 
                case '.': {
                    result = -1;
                    break;
                }
            }
        }
        return result;
    }

    public boolean getMatchFractionPart() {
        return this._matchFractionPart;
    }

    public void setMatchFractionPart(boolean matchFractionPart) {
        this._matchFractionPart = matchFractionPart;
    }

    public boolean getMatchIntegerPart() {
        return this._matchIntegerPart;
    }

    public void setMatchIntegerPart(boolean matchIntegerPart) {
        this._matchIntegerPart = matchIntegerPart;
    }

    public boolean getMatchNegative() {
        return this._matchNegative;
    }

    public void setMatchNegative(boolean matchNegative) {
        this._matchNegative = matchNegative;
    }

    public boolean getMatchPositive() {
        return this._matchPositive;
    }

    public void setMatchPositive(boolean matchPositive) {
        this._matchPositive = matchPositive;
    }

    public boolean getMatchSciNotation() {
        return this._matchSciNotation;
    }

    public void setMatchSciNotation(boolean matchSciNotation) {
        this._matchSciNotation = matchSciNotation;
    }

    public String toString() {
        return "Number";
    }
}

