/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher;

import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.lexer.matcher.AbstractTextMatcher;
import com.aptana.ide.lexer.matcher.ITextMatcher;
import com.aptana.ide.lexer.matcher.MatcherMap;
import com.aptana.ide.lexer.matcher.Messages;
import com.aptana.xml.INode;

public class RepetitionMatcher
extends AbstractTextMatcher {
    public static final int INFINITY = Integer.MAX_VALUE;
    private int _minimum;
    private int _maximum;

    public RepetitionMatcher() {
        this(1, 1);
    }

    public RepetitionMatcher(int min, int max) {
        this._minimum = min;
        this._maximum = max;
    }

    public void addChildTypes() {
        this.addChildType(ITextMatcher.class);
    }

    public void addFirstCharacters(MatcherMap map, ITextMatcher target) {
        if (this.getChildCount() > 0) {
            ITextMatcher child = (ITextMatcher)this.getChild(0);
            child.addFirstCharacters(map, target);
        }
    }

    public boolean canMatchNothing() {
        boolean result = false;
        if (this._minimum == 0) {
            result = true;
        } else if (this.getChildCount() > 0) {
            ITextMatcher child = (ITextMatcher)this.getChild(0);
            result = child.canMatchNothing();
        }
        return result;
    }

    protected void createChildrenTokens(ITokenList tokenList) {
        this.wrapChildrenInAndElement();
        super.createChildrenTokens(tokenList);
    }

    public int match(char[] source, int offset, int eofset) {
        int index = offset;
        int result = -1;
        if (this.getChildCount() > 0) {
            int i;
            ITextMatcher child = (ITextMatcher)this.getChild(0);
            if (this._minimum > 0) {
                i = 0;
                while (i < this._minimum) {
                    result = child.match(source, index, eofset);
                    if (result != -1) {
                        index = result;
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                result = index;
            }
            if (result != -1) {
                i = this._minimum;
                while (i < this._maximum) {
                    int temp = child.match(source, index, eofset);
                    if (temp == -1) break;
                    index = result = temp;
                    ++i;
                }
            }
        }
        if (result != -1) {
            this.accept(source, offset, result, this.token);
        }
        return result;
    }

    public void setMax(int max) {
        this._maximum = max;
    }

    public void setMin(int min) {
        this._minimum = min;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        if (this.getChildCount() > 0) {
            INode child = this.getChild(0);
            buffer.append(child);
        }
        buffer.append("){").append(this._minimum).append(",").append(this._maximum).append("}");
        return buffer.toString();
    }

    protected void validateLocal() {
        super.validateLocal();
        int count = this.getChildCount();
        if (count == 0) {
            this.getDocument().sendError(Messages.RepetitionMatcher_No_Children, this);
        } else if (count > 1) {
            this.getDocument().sendInfo(Messages.RepetitionMatcher_Wrapping_Children, this);
        }
    }
}

