/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.lexer.matcher.model;

import com.aptana.ide.lexer.DynamicEnumerationMap;
import com.aptana.ide.lexer.IEnumerationMap;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.lexer.LexerPlugin;
import com.aptana.ide.lexer.StaticEnumerationMap;
import com.aptana.ide.lexer.matcher.MatcherTokenList;
import com.aptana.ide.lexer.matcher.model.MatcherElement;
import com.aptana.ide.lexer.matcher.model.Messages;
import com.aptana.ide.lexer.matcher.model.TokenGroupElement;
import com.aptana.xml.Bundle;
import com.aptana.xml.Package;

public class LexerElement
extends MatcherElement {
    private String _language;
    private String _categoryEnumeration;
    private String _typeEnumeration;

    public LexerElement() {
        this.addChildType(TokenGroupElement.class);
        this.addChildType(Bundle.class);
        this.addChildType(Package.class);
    }

    public String getLanguage() {
        return this._language;
    }

    public void setLanguage(String language) {
        this._language = language;
    }

    public String getCategoryEnumeration() {
        return this._categoryEnumeration;
    }

    public void setCategoryEnumeration(String categoryEnumeration) {
        this._categoryEnumeration = categoryEnumeration;
    }

    public String getTypeEnumeration() {
        return this._typeEnumeration;
    }

    public void setTypeEnumeration(String typeEnumeration) {
        this._typeEnumeration = typeEnumeration;
    }

    public ITokenList getTokenList(ClassLoader loader) {
        MatcherTokenList result = new MatcherTokenList(this.getLanguage());
        result.setCategoryMap(this.createCategoryEnumeration(loader));
        result.setTypeMap(this.createTypeEnumeration(loader));
        this.createTokens(result);
        return result;
    }

    private IEnumerationMap createCategoryEnumeration(ClassLoader loader) {
        IEnumerationMap map = null;
        if (this._categoryEnumeration != null && this._categoryEnumeration.length() > 0) {
            try {
                Class<?> typeClass = Class.forName(this._categoryEnumeration, true, loader);
                map = new StaticEnumerationMap(typeClass);
            }
            catch (ClassNotFoundException e) {
                LexerPlugin.logInfo(String.valueOf(Messages.LexerElement_Cannot_Find_Category_Enumeration) + this._categoryEnumeration, e);
            }
        }
        if (map == null) {
            map = new DynamicEnumerationMap();
        }
        return map;
    }

    private IEnumerationMap createTypeEnumeration(ClassLoader loader) {
        IEnumerationMap map = null;
        if (this._typeEnumeration != null && this._typeEnumeration.length() > 0) {
            try {
                Class<?> typeClass = Class.forName(this._typeEnumeration, true, loader);
                map = new StaticEnumerationMap(typeClass);
            }
            catch (ClassNotFoundException e) {
                LexerPlugin.logInfo(String.valueOf(Messages.LexerElement_Cannot_Find_Type_Enumeration) + this._typeEnumeration, e);
            }
        }
        if (map == null) {
            map = new DynamicEnumerationMap();
        }
        return map;
    }

    protected void validateLocal() {
        if (this._language == null || this._language.length() == 0) {
            this.getDocument().sendError(Messages.LexerElement_Missing_Language, this);
        }
    }
}

