/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.metadata;

import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.metadata.ElementMetadata;
import com.aptana.ide.metadata.EventMetadata;
import com.aptana.ide.metadata.FieldMetadata;
import com.aptana.ide.metadata.IMetadataEnvironment;
import com.aptana.ide.metadata.Messages;
import com.aptana.ide.metadata.MetadataEnvironment;
import com.aptana.ide.metadata.UserAgent;
import com.aptana.ide.parsing.IRuntimeEnvironment;
import com.aptana.ide.parsing.nodes.ParseNodeBase;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataRuntimeEnvironment
implements IRuntimeEnvironment,
IMetadataEnvironment {
    private static final String EMPTY = "";
    private ArrayList<MetadataEnvironment> environments = new ArrayList();
    private Hashtable<Integer, Hashtable<String, ParseNodeBase>> fileObjects = new Hashtable();
    private Hashtable<Integer, Hashtable<String, ParseNodeBase>> cssFileObjects = new Hashtable();

    public Hashtable<Integer, Hashtable<String, ParseNodeBase>> getFileObjects() {
        return this.fileObjects;
    }

    @Override
    public String[] getAllIds() {
        ArrayList<String> ids = new ArrayList<String>();
        Hashtable<Integer, Hashtable<String, ParseNodeBase>> objs = this.getFileObjects();
        Enumeration<Integer> keys = objs.keys();
        while (keys.hasMoreElements()) {
            Integer fileIndex = keys.nextElement();
            if (fileIndex < 0) continue;
            Hashtable<String, ParseNodeBase> a = objs.get(fileIndex);
            ids.addAll(a.keySet());
        }
        return ids.toArray(new String[0]);
    }

    @Override
    public void addId(String id, int fileIndex, ParseNodeBase hn) {
        if (!this.fileObjects.containsKey(new Integer(fileIndex))) {
            Hashtable<String, ParseNodeBase> h = new Hashtable<String, ParseNodeBase>();
            h.put(id, hn);
            this.fileObjects.put(new Integer(fileIndex), h);
        } else {
            Hashtable<String, ParseNodeBase> h = this.fileObjects.get(new Integer(fileIndex));
            if (!h.containsKey(id)) {
                h.put(id, hn);
            }
        }
    }

    @Override
    public void removeFileIds(int fileIndex) {
        this.fileObjects.remove(new Integer(fileIndex));
    }

    public void addEnvironment(MetadataEnvironment environment) {
        this.environments.add(environment);
    }

    public void removeEnvironment(MetadataEnvironment environment) {
        this.environments.remove(environment);
    }

    public MetadataEnvironment[] getEnvironments() {
        return this.environments.toArray(new MetadataEnvironment[0]);
    }

    @Override
    public String[] getAllElements() {
        ArrayList<String> allElements = new ArrayList<String>();
        for (MetadataEnvironment name : this.environments) {
            ElementMetadata[] elements = name.getAllElements();
            int i = 0;
            while (i < elements.length) {
                ElementMetadata elementMetadata = elements[i];
                String elementName = elementMetadata.getName().toLowerCase();
                if (!allElements.contains(elementName)) {
                    allElements.add(elementName);
                }
                ++i;
            }
        }
        return allElements.toArray(new String[0]);
    }

    @Override
    public Hashtable<String, FieldMetadata> getGlobalFields() {
        Hashtable<String, FieldMetadata> globalFields = new Hashtable<String, FieldMetadata>();
        for (MetadataEnvironment name : this.environments) {
            Hashtable<String, FieldMetadata> fields = name.getGlobalFields();
            Enumeration<FieldMetadata> fieldSet = fields.elements();
            while (fieldSet.hasMoreElements()) {
                FieldMetadata field = fieldSet.nextElement();
                if (!globalFields.containsKey(field.getName())) {
                    globalFields.put(field.getName(), field);
                    continue;
                }
                globalFields.get(field.getName()).merge(field);
            }
        }
        return globalFields;
    }

    @Override
    public Hashtable<String, EventMetadata> getGlobalEvents() {
        Hashtable<String, EventMetadata> globalEvents = new Hashtable<String, EventMetadata>();
        for (MetadataEnvironment name : this.environments) {
            Hashtable<String, EventMetadata> events = name.getGlobalEvents();
            Enumeration<EventMetadata> eventsSet = events.elements();
            while (eventsSet.hasMoreElements()) {
                EventMetadata field = eventsSet.nextElement();
                if (!globalEvents.containsKey(field.getName())) {
                    globalEvents.put(field.getName(), field);
                    continue;
                }
                globalEvents.get(field.getName()).merge(field);
            }
        }
        return globalEvents;
    }

    @Override
    public ElementMetadata getElement(String tagNameLower) {
        return this.getMergedElement(tagNameLower);
    }

    protected ElementMetadata getMergedElement(String tagNameLower) {
        ElementMetadata data = new ElementMetadata();
        for (MetadataEnvironment name : this.environments) {
            ElementMetadata d = name.getElement(tagNameLower);
            if (d == null) continue;
            data.merge(d);
        }
        return data;
    }

    @Override
    public ElementMetadata getElement(Lexeme lexeme) {
        String lexemeText = lexeme.getText().replaceAll("</", EMPTY);
        lexemeText = lexeme.getText().replaceAll("<", EMPTY);
        return this.getElement(lexemeText);
    }

    @Override
    public String getElementDocumentation(String elementName) {
        ElementMetadata element = this.getElement(elementName);
        return this.getElementDocumentation(element);
    }

    public String getElementDocumentation(ElementMetadata element) {
        StringBuffer docText = new StringBuffer();
        docText.append("<b>" + element.getName() + "</b>");
        if (element.getFullName() != EMPTY) {
            docText.append(" (" + element.getFullName() + ")");
        }
        docText.append("<br>" + element.getDescription());
        UserAgent[] agents = element.getUserAgents();
        if (agents.length > 0) {
            docText.append("<br><br><b>").append(Messages.MetadataEnvironment_Supported_Header).append("</b> ");
            int i = 0;
            while (i < agents.length) {
                UserAgent ua = agents[i];
                docText.append(String.valueOf(ua.getPlatform()) + " " + ua.getVersion());
                if (i < agents.length - 1) {
                    docText.append(", ");
                }
                ++i;
            }
        }
        return docText.toString();
    }

    @Override
    public String[] getUserAgentPlatformNames(String elementName) {
        ElementMetadata element = this.getElement(elementName);
        return element.getUserAgentPlatformNames();
    }

    @Override
    public String getFieldDocumentation(FieldMetadata element) {
        StringBuffer docText = new StringBuffer();
        docText.append("<b>" + element.getName() + "</b>");
        if (element.getType() != EMPTY) {
            docText.append(": " + element.getType());
        }
        docText.append("<br>" + element.getDescription());
        UserAgent[] agents = element.getUserAgents();
        if (agents.length > 0) {
            docText.append("<br><br><b>").append(Messages.MetadataEnvironment_Supported_Header).append("</b> ");
            int i = 0;
            while (i < agents.length) {
                UserAgent ua = agents[i];
                docText.append(String.valueOf(ua.getPlatform()) + " " + ua.getVersion());
                if (i < agents.length - 1) {
                    docText.append(", ");
                }
                ++i;
            }
        }
        return docText.toString();
    }

    @Override
    public String getEventDocumentation(EventMetadata element) {
        StringBuffer docText = new StringBuffer();
        docText.append("<b>" + element.getName() + "</b>");
        if (element.getType() != EMPTY) {
            docText.append(": " + element.getType());
        }
        docText.append("<br>" + element.getDescription());
        UserAgent[] agents = element.getUserAgents();
        if (agents.length > 0) {
            docText.append("<br><br><b>").append(Messages.MetadataEnvironment_Supported_Header).append("</b> ");
            int i = 0;
            while (i < agents.length) {
                UserAgent ua = agents[i];
                docText.append(String.valueOf(ua.getPlatform()) + " " + ua.getVersion());
                if (i < agents.length - 1) {
                    docText.append(", ");
                }
                ++i;
            }
        }
        return docText.toString();
    }

    @Override
    public void addClass(String cssClass, int fileIndex, ParseNodeBase hn) {
        if (!this.cssFileObjects.containsKey(new Integer(fileIndex))) {
            Hashtable<String, ParseNodeBase> h = new Hashtable<String, ParseNodeBase>();
            h.put(cssClass, hn);
            this.cssFileObjects.put(new Integer(fileIndex), h);
        } else {
            Hashtable<String, ParseNodeBase> h = this.cssFileObjects.get(new Integer(fileIndex));
            if (!h.containsKey(hn)) {
                h.put(cssClass, hn);
            }
        }
    }

    @Override
    public List<String> getAllClasses() {
        ArrayList<String> classes = new ArrayList<String>();
        Hashtable<Integer, Hashtable<String, ParseNodeBase>> objs = this.cssFileObjects;
        Enumeration<Integer> keys = objs.keys();
        while (keys.hasMoreElements()) {
            Integer fileIndex = keys.nextElement();
            if (fileIndex < 0) continue;
            Hashtable<String, ParseNodeBase> a = objs.get(fileIndex);
            classes.addAll(a.keySet());
        }
        return classes;
    }
}

