/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.metadata.reader;

import com.aptana.ide.metadata.ElementMetadata;
import com.aptana.ide.metadata.EventMetadata;
import com.aptana.ide.metadata.FieldMetadata;
import com.aptana.ide.metadata.IMetadataItem;
import com.aptana.ide.metadata.UserAgent;
import com.aptana.ide.metadata.ValueMetadata;
import com.aptana.ide.metadata.reader.Messages;
import com.aptana.sax.SchemaBuilder;
import com.aptana.sax.SchemaInitializationException;
import com.aptana.sax.ValidatingReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MetadataReader
extends ValidatingReader {
    private static final String EMPTY = "";
    private static final String METADATA_SCHEMA_XML = "/com/aptana/ide/metadata/resources/MetadataSchema_1_0.xml";
    private boolean _bufferText;
    private String _textBuffer;
    private ArrayList elements;
    private ArrayList _currentValues;
    private ElementMetadata _currentElement;
    private IMetadataItem _currentItem;
    private Hashtable _globalFields = new Hashtable();
    private Hashtable _globalEvents = new Hashtable();
    private ValueMetadata _currentValue;
    private UserAgent _currentUserAgent;

    public ArrayList getElements() {
        return this.elements;
    }

    public Hashtable getGlobalFields() {
        return this._globalFields;
    }

    public Hashtable getGlobalEvents() {
        return this._globalEvents;
    }

    public MetadataReader() throws Exception {
        this.elements = new ArrayList();
        InputStream schemaStream = MetadataReader.class.getResourceAsStream(METADATA_SCHEMA_XML);
        try {
            try {
                this._schema = SchemaBuilder.fromXML(schemaStream, (Object)this);
            }
            catch (SchemaInitializationException e) {
                String msg = Messages.MetadataReader_ErrorLoadingDocumentationXML;
                Exception ie = new Exception(msg, e);
                throw ie;
            }
        }
        finally {
            try {
                schemaStream.close();
            }
            catch (IOException e) {
                String msg = Messages.MetadataReader_IOErrorProcessingDocumentationXML;
                Exception ie = new Exception(msg, e);
                throw ie;
            }
        }
    }

    public void characters(char[] buffer, int offset, int length) {
        if (this._bufferText) {
            this._textBuffer = String.valueOf(this._textBuffer) + new String(buffer, offset, length);
        }
    }

    public void loadXML(String filename) throws Exception {
        FileInputStream fi = null;
        try {
            try {
                fi = new FileInputStream(filename);
                this.loadXML(fi);
            }
            catch (FileNotFoundException e) {
                String msg = MessageFormat.format(Messages.MetadataObjectsReader_UnableToLocateDocumentationXML, filename);
                Exception de = new Exception(msg, e);
                throw de;
            }
        }
        catch (Throwable throwable) {
            try {
                fi.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fi.close();
        }
        catch (IOException iOException) {}
    }

    public void loadXML(InputStream stream) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        this._textBuffer = EMPTY;
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
            saxParser.parse(stream, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            String msg = Messages.MetadataReader_SAXParserConfiguredIncorrectly;
            Exception de = new Exception(msg, e);
            throw de;
        }
        catch (SAXException e) {
            Exception ex = e.getException();
            String msg = null;
            msg = ex != null ? MessageFormat.format(Messages.MetadataReader_ErrorParsingDocumentationXML, ex.getMessage()) : MessageFormat.format(Messages.MetadataReader_ErrorParsingDocumentationXML, e.getMessage());
            Exception de = new Exception(msg, e);
            throw de;
        }
        catch (IOException e) {
            String msg = Messages.MetadataObjectsReader_IOErrorOccurredProcessingDocumentationXML;
            Exception de = new Exception(msg, e);
            throw de;
        }
    }

    public void startTextBuffer(String ns, String name, String qname, Attributes attributes) {
        this._bufferText = true;
    }

    public String decodeHtml(String text) {
        String textTemp = text.replaceAll("&amp;", "&");
        textTemp = textTemp.replaceAll("&quot;", "\"");
        textTemp = textTemp.replaceAll("&lt;", "<");
        textTemp = textTemp.replaceAll("&gt;", ">");
        return textTemp;
    }

    public void enterElement(String ns, String name, String qname, Attributes attributes) {
        ElementMetadata element = new ElementMetadata();
        this.elements.add(element);
        String type = attributes.getValue("name");
        element.setName(type);
        String fullName = attributes.getValue("full-name");
        element.setFullName(fullName);
        this._currentElement = element;
    }

    public void exitElement(String ns, String name, String qname) {
        this._currentElement = null;
    }

    public void enterEvent(String ns, String name, String qname, Attributes attributes) {
        EventMetadata event = new EventMetadata();
        String fieldName = attributes.getValue("name");
        event.setName(fieldName);
        String fieldType = attributes.getValue("type");
        event.setType(fieldType);
        if (this._currentElement != null) {
            this._currentElement.addEvent(event);
        } else {
            this._globalEvents.put(fieldName, event);
        }
        this._currentItem = event;
    }

    public void exitEvent(String ns, String name, String qname) {
        this._currentValues = null;
        this._currentItem = null;
    }

    public void enterField(String ns, String name, String qname, Attributes attributes) {
        FieldMetadata field = new FieldMetadata();
        this._currentValues = field.getValues();
        String fieldName = attributes.getValue("name");
        field.setName(fieldName);
        String fieldType = attributes.getValue("type");
        field.setType(fieldType);
        String allowMultiple = attributes.getValue("allow-multiple-values");
        if (allowMultiple != null && allowMultiple.equals("true")) {
            field.setAllowMultipleValues(true);
        }
        if (this._currentElement != null) {
            this._currentElement.addField(field);
        } else {
            this._globalFields.put(fieldName, field);
        }
        this._currentItem = field;
    }

    public void exitField(String ns, String name, String qname) {
        this._currentValues = null;
        this._currentItem = null;
    }

    public static String join(String delimiter, String[] items) {
        int length = items.length;
        String result = EMPTY;
        if (length > 0) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < length - 1) {
                sb.append(items[i]).append(delimiter);
                ++i;
            }
            sb.append(items[length - 1]);
            result = sb.toString();
        }
        return result;
    }

    public void exitDescription(String ns, String name, String qname) {
        if (this._currentItem != null) {
            this._currentItem.setDescription(this.decodeHtml(this._textBuffer));
        } else if (this._currentElement != null) {
            this._currentElement.setDescription(this.decodeHtml(this._textBuffer));
        } else if (this._currentUserAgent != null) {
            this._currentUserAgent.setDescription(this.decodeHtml(this._textBuffer));
        }
        this._textBuffer = EMPTY;
        this._bufferText = false;
    }

    public void exitDeprecated(String ns, String name, String qname) {
        if (this._currentItem != null) {
            this._currentItem.setDeprecatedDescription(this.decodeHtml(this._textBuffer));
        } else if (this._currentElement != null) {
            this._currentElement.setDeprecatedDescription(this.decodeHtml(this._textBuffer));
        }
        this._textBuffer = EMPTY;
        this._bufferText = false;
    }

    public void exitHint(String ns, String name, String qname) {
        if (this._currentItem != null) {
            this._currentItem.setHint(this.decodeHtml(this._textBuffer));
        } else if (this._currentElement != null) {
            this._currentElement.setDescription(this.decodeHtml(this._textBuffer));
        }
        this._textBuffer = EMPTY;
        this._bufferText = false;
    }

    public void enterSpecification(String ns, String name, String qname, Attributes attributes) {
    }

    public void enterValue(String ns, String name, String qname, Attributes attributes) {
        ValueMetadata field = new ValueMetadata();
        String fieldName = attributes.getValue("name");
        field.setName(fieldName);
        String fieldType = attributes.getValue("description");
        field.setDescription(fieldType);
        this._currentValue = field;
    }

    public void exitValue(String ns, String name, String qname) {
        this._currentValues.add(this._currentValue);
        this._currentValue = null;
    }

    public void exitAvailability(String ns, String name, String qname) {
    }

    public void exitBrowser(String ns, String name, String qname) {
        if (this._currentValue != null) {
            this._currentValue.addUserAgent(this._currentUserAgent);
        } else if (this._currentItem != null) {
            this._currentItem.addUserAgent(this._currentUserAgent);
        } else if (this._currentElement != null) {
            this._currentElement.addUserAgent(this._currentUserAgent);
        }
        this._currentUserAgent = null;
    }

    public void enterBrowser(String ns, String name, String qname, Attributes attributes) {
        String osVersion;
        String os;
        UserAgent field = new UserAgent();
        String platform = attributes.getValue("platform");
        field.setPlatform(platform);
        String version = attributes.getValue("version");
        if (version != null) {
            field.setVersion(version);
        }
        if ((os = attributes.getValue("os")) != null) {
            field.setOs(os);
        }
        if ((osVersion = attributes.getValue("osVersion")) != null) {
            field.setOsVersion(osVersion);
        }
        this._currentUserAgent = field;
    }
}

