/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.bnf;

import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.ParsingPlugin;
import com.aptana.ide.parsing.bnf.IReductionContext;
import com.aptana.ide.parsing.bnf.IReductionHandler;
import com.aptana.ide.parsing.nodes.IParseNode;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public abstract class AbstractHandler
implements IReductionHandler {
    private Stack<Object> _values = new Stack();
    private Map<String, Method> _methods = new HashMap<String, Method>();

    public void afterParse(IParseState parseState, IParseNode parentNode) {
    }

    public void beforeParse(IParseState parseState, IParseNode parentNode) {
        this._values.clear();
    }

    public Object[] getValues() {
        return this._values.toArray();
    }

    public void push(Object value) {
        this._values.push(value);
    }

    public void reduce(IReductionContext context) {
        Method method = null;
        Object result = null;
        String actionName = context.getAction();
        if (actionName != null && actionName.length() > 0) {
            String methodName = "on" + actionName;
            if (!this._methods.containsKey(methodName)) {
                try {
                    method = this.getClass().getMethod(methodName, IReductionContext.class);
                }
                catch (SecurityException e) {
                    ParsingPlugin.logError("Accessing method " + methodName + " failed with a security violation", e);
                }
                catch (NoSuchMethodException e) {
                    ParsingPlugin.logError("Method " + methodName + " does not exist", e);
                }
                this._methods.put(methodName, method);
            } else {
                method = this._methods.get(methodName);
            }
        }
        int count = context.getNodeCount();
        Object[] nodes = new Object[count];
        int i = 0;
        while (i < count) {
            nodes[count - i - 1] = this._values.pop();
            ++i;
        }
        context.setNodes(nodes);
        if (method != null) {
            try {
                result = method.invoke((Object)this, context);
            }
            catch (Exception e) {
                ParsingPlugin.logError("Method for action '" + actionName + "' encountered an error during invocation", e);
            }
        } else if (nodes.length > 0) {
            result = nodes[0];
        }
        this._values.push(result);
    }
}

