/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.parsing.matcher;

import com.aptana.ide.lexer.DynamicEnumerationMap;
import com.aptana.ide.lexer.IEnumerationMap;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.parsing.matcher.ILexemeMatcher;
import com.aptana.ide.parsing.matcher.ParserMatcher;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.ParseFragment;
import com.aptana.ide.parsing.nodes.ParseNodeBase;
import com.aptana.xml.INode;
import com.aptana.xml.NodeBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLexemeMatcher
extends NodeBase
implements ILexemeMatcher {
    private String _node;
    private ParseFragment _childNodes;
    private Map<String, String> _attributes;
    protected IParseNode result;

    public AbstractLexemeMatcher() {
        this.addChildTypes();
    }

    protected void accept(Lexeme[] lexemes, int startingIndex, int endingIndex) {
        if (this._node != null && this._node.length() > 0) {
            Lexeme startingLexeme = lexemes[startingIndex];
            String language = startingLexeme.getLanguage();
            int type = this.getOwningParser().getNodeTypeIndex(this._node);
            ParseNodeBase node = new ParseNodeBase(this._node, type, language, startingLexeme);
            node.setName(this._node.toLowerCase());
            if (startingIndex <= endingIndex - 1) {
                Lexeme endingLexeme = lexemes[endingIndex - 1];
                node.includeLexemeInRange(endingLexeme);
            }
            this.result = node;
            if (this._childNodes != null) {
                this.result.appendChild(this._childNodes);
            }
        } else {
            this.result = this._childNodes;
        }
        if (this.result != null && this._attributes != null && this._attributes.size() > 0) {
            Set<Map.Entry<String, String>> entries = this._attributes.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                this.result.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void addAttribute(String name, String value) {
        if (name != null && name.length() > 0 && value != null && value.length() > 0) {
            if (this._attributes == null) {
                this._attributes = new HashMap<String, String>();
            }
            this._attributes.put(name, value);
            if (this._childNodes == null) {
                this._childNodes = new ParseFragment();
            }
        }
    }

    protected void addChildParseNode(IParseNode childParseNode) {
        if (childParseNode != null) {
            if (this._childNodes == null) {
                this._childNodes = new ParseFragment();
            }
            this._childNodes.appendChild(childParseNode);
        }
    }

    public abstract void addChildTypes();

    protected void addTypesToMap(IEnumerationMap indexMap) {
        if (indexMap instanceof DynamicEnumerationMap) {
            DynamicEnumerationMap map = (DynamicEnumerationMap)indexMap;
            if (this._node != null && this._node.length() > 0) {
                map.getIntValue(this._node);
            }
            int i = 0;
            while (i < this.getChildCount()) {
                INode child = this.getChild(i);
                if (child instanceof AbstractLexemeMatcher) {
                    ((AbstractLexemeMatcher)child).addTypesToMap(indexMap);
                }
                ++i;
            }
        }
    }

    protected void reset() {
        this._childNodes = null;
        if (this._attributes != null) {
            this._attributes.clear();
        }
        this.result = null;
    }

    public String getNode() {
        return this._node;
    }

    public ParserMatcher getOwningParser() {
        ParserMatcher result = null;
        INode current = this;
        while (current != null) {
            if (current instanceof ParserMatcher) {
                result = (ParserMatcher)current;
                break;
            }
            current = current.getParent();
        }
        return result;
    }

    public IParseNode getParseResults() {
        return this.result;
    }

    public void setNode(String node) {
        this._node = node;
    }
}

