/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.regex.dfa;

import com.aptana.ide.regex.IRegexRunner;
import com.aptana.ide.regex.IRegexRunnerNode;
import com.aptana.ide.regex.dfa.DFANode;
import com.aptana.ide.regex.sets.CharacterSet;
import com.aptana.ide.regex.sets.NumberSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DFAGraph
implements IRegexRunner {
    private IRegexRunnerNode[] _nodes = new DFANode[0];
    private int _acceptState;
    public CharacterSet _transitionSet = null;

    public IRegexRunnerNode getItem(int index) {
        return this._nodes[index];
    }

    public int getSize() {
        return this._nodes.length;
    }

    public int add(DFANode node) {
        int length = this._nodes.length;
        DFANode[] newNodes = new DFANode[length + 1];
        System.arraycopy(this._nodes, 0, newNodes, 0, length);
        newNodes[length] = node;
        this._nodes = newNodes;
        return length;
    }

    public int add(NumberSet inputs) {
        return this.add(new DFANode(inputs));
    }

    public int getAcceptState() {
        return this._acceptState;
    }

    public int match(String source, int startPosition, int endPosition) {
        return this.match(source.toCharArray(), startPosition, endPosition);
    }

    public int match(char[] source, int startPosition, int endPosition) {
        int currentState = 0;
        this._acceptState = this._nodes[0].getAcceptState();
        int lastAccept = this._acceptState == -1 ? -2 : startPosition;
        int i = startPosition;
        while (i < endPosition) {
            int index = this._transitionSet.inputIndex(source[i]);
            if (index == -1) break;
            IRegexRunnerNode move = this._nodes[currentState];
            if (move != null) {
                int nextState = move.getItem(index);
                if (nextState == -1) break;
                currentState = nextState;
                int acceptState = this._nodes[currentState].getAcceptState();
                if (acceptState != -1) {
                    lastAccept = i;
                    this._acceptState = acceptState;
                }
            }
            ++i;
        }
        return lastAccept + 1;
    }

    public void read(DataInput input) throws IOException {
        this._transitionSet = new CharacterSet();
        this._transitionSet.setMembers(input.readUTF());
        int nodeCount = input.readInt();
        this._nodes = new IRegexRunnerNode[nodeCount];
        int i = 0;
        while (i < nodeCount) {
            DFANode node = new DFANode();
            node.read(input);
            this._nodes[i] = node;
            ++i;
        }
    }

    public void write(DataOutput output) throws IOException {
        String members = new String(this._transitionSet.getMembers());
        output.writeUTF(members);
        int nodeCount = this._nodes.length;
        output.writeInt(nodeCount);
        int i = 0;
        while (i < nodeCount) {
            this._nodes[i].write(output);
            ++i;
        }
    }
}

