/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ui.secureftp.dialogs;

import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ide.core.ui.PixelConverter;
import com.aptana.ide.filesystem.secureftp.Policy;
import com.aptana.ide.filesystem.secureftp.SFTPConnectionPoint;
import com.aptana.ide.filesystem.secureftp.SecureUtils;
import com.aptana.ide.ui.UIUtils;
import com.aptana.ide.ui.ftp.dialogs.FTPConnectionPointPropertyDialog;
import com.aptana.ide.ui.ftp.internal.FTPAdvancedOptionsComposite;
import com.aptana.ide.ui.ftp.internal.IConnectionDialog;
import com.aptana.ide.ui.ftp.internal.IOptionsComposite;
import com.aptana.ide.ui.secureftp.internal.FTPSAdvancedOptionsComposite;
import com.aptana.ide.ui.secureftp.internal.SFTPAdvancedOptionsComposite;
import java.io.File;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CommonFTPConnectionPointPropertyDialog
extends FTPConnectionPointPropertyDialog {
    private final ConnectionPointType[] protoTypes = new ConnectionPointType[]{CoreIOPlugin.getConnectionPointManager().getType("ftp"), CoreIOPlugin.getConnectionPointManager().getType("ftps"), CoreIOPlugin.getConnectionPointManager().getType("sftp")};
    private ConnectionPointType connectionType;
    private Combo protocolButton;
    private Composite keyAuthComposite;
    private Button keyAuthButton;
    private Label keyPathLabel;
    private Composite[] advancedOptionsComposites;

    public CommonFTPConnectionPointPropertyDialog(Shell parentShell) {
        super(parentShell);
    }

    protected ConnectionPointType getConnectionPointType() {
        if (this.connectionType != null) {
            return this.connectionType;
        }
        return super.getConnectionPointType();
    }

    public void setPropertySource(Object element) {
        super.setPropertySource(element);
        if (this.ftpConnectionPoint != null) {
            this.connectionType = CoreIOPlugin.getConnectionPointManager().getType((IConnectionPoint)this.ftpConnectionPoint);
        } else if (element instanceof ConnectionPointType) {
            this.connectionType = (ConnectionPointType)element;
        }
    }

    protected void createSiteSection(Composite parent) {
        super.createSiteSection(parent);
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        label.setText(StringUtils.makeFormLabel((String)"Protocol"));
        this.protocolButton = new Combo(parent, 12);
        String[] items = new String[this.protoTypes.length];
        int i = 0;
        while (i < items.length) {
            items[i] = this.protoTypes[i].getName();
            ++i;
        }
        this.protocolButton.setItems(items);
        this.updateProtocolButton();
        this.protocolButton.setLayoutData((Object)GridDataFactory.swtDefaults().hint(Math.max(new PixelConverter((Control)this.protocolButton).convertHorizontalDLUsToPixels(61), this.protocolButton.computeSize((int)-1, (int)-1, (boolean)true).x), -1).create());
        this.protocolButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonFTPConnectionPointPropertyDialog.this.changeProtocolType(CommonFTPConnectionPointPropertyDialog.this.protoTypes[CommonFTPConnectionPointPropertyDialog.this.protocolButton.getSelectionIndex()]);
            }
        });
    }

    protected void createPasswordSection(Composite parent) {
        this.keyAuthComposite = new Composite(parent, 0);
        this.keyAuthComposite.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).grab(true, false).create());
        CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.keyAuthComposite, false);
        this.keyAuthComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(LayoutConstants.getSpacing().x, 0).numColumns(2).create());
        Label label = new Label(this.keyAuthComposite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        this.keyAuthButton = new Button(this.keyAuthComposite, 32);
        this.keyAuthButton.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.keyAuthButton.setText("Use &Public Key Authentication");
        label = new Label(this.keyAuthComposite, 0);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().hint(new PixelConverter((Control)label).convertHorizontalDLUsToPixels(55), -1).create());
        this.keyPathLabel = new Label(this.keyAuthComposite, 0);
        this.keyPathLabel.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.keyPathLabel.setFont(this.smallFont);
        this.keyPathLabel.setText("No Private Key selected");
        super.createPasswordSection(parent);
        this.updateKeyAuth();
        this.keyAuthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommonFTPConnectionPointPropertyDialog.this.changeKeyAuthentication();
            }
        });
    }

    protected void createAdvancedOptions(Composite parent) {
        Composite[] compositeArray = this.advancedOptionsComposites = new Composite[]{new FTPAdvancedOptionsComposite(parent, 0, (IConnectionDialog)this), new FTPSAdvancedOptionsComposite(parent, 0, (IConnectionDialog)this), new SFTPAdvancedOptionsComposite(parent, 0, (IConnectionDialog)this)};
        int n = this.advancedOptionsComposites.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite = compositeArray[n2];
            composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
            CommonFTPConnectionPointPropertyDialog.makeVisible((Control)composite, false);
            ++n2;
        }
        this.updateAdvancedOptions();
    }

    protected String getAuthId(IBaseRemoteConnectionPoint connectionPoint) {
        if ("sftp".equals(this.connectionType.getType()) && this.keyAuthButton.getSelection()) {
            return Policy.generateAuthId((String)(String.valueOf(this.getConnectionPointType().getType().toUpperCase()) + "/PUBLICKEY"), (IBaseRemoteConnectionPoint)connectionPoint);
        }
        return super.getAuthId(connectionPoint);
    }

    protected void loadPropertiesFrom(IBaseRemoteConnectionPoint connectionPoint) {
        if (connectionPoint instanceof SFTPConnectionPoint) {
            SFTPConnectionPoint sftpConnectionPoint = (SFTPConnectionPoint)connectionPoint;
            IPath keyFilePath = sftpConnectionPoint.getKeyFilePath();
            CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.passwordLabel, true);
            CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.passwordText, true);
            CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.savePasswordButton, true);
            if (keyFilePath != null && !keyFilePath.isEmpty()) {
                this.keyAuthButton.setSelection(true);
                this.keyPathLabel.setText(keyFilePath.toOSString());
                this.passwordLabel.setText(StringUtils.makeFormLabel((String)"Passphrase"));
                try {
                    boolean passphraseProtected = SecureUtils.isKeyPassphraseProtected((File)keyFilePath.toFile());
                    CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.passwordLabel, passphraseProtected);
                    CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.passwordText, passphraseProtected);
                    CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.savePasswordButton, passphraseProtected);
                }
                catch (CoreException coreException) {}
            }
            this.updateLayout();
        }
        super.loadPropertiesFrom(connectionPoint);
    }

    protected boolean savePropertiesTo(IBaseRemoteConnectionPoint connectionPoint) {
        boolean updated = false;
        if (connectionPoint instanceof SFTPConnectionPoint) {
            SFTPConnectionPoint sftpConnectionPoint = (SFTPConnectionPoint)connectionPoint;
            if (this.keyAuthButton.getSelection()) {
                IPath keyFilePath = Path.fromPortableString((String)this.keyPathLabel.getText());
                if (!connectionPoint.getPath().equals((Object)keyFilePath)) {
                    sftpConnectionPoint.setKeyFilePath(keyFilePath);
                    updated = true;
                }
            }
        }
        return super.savePropertiesTo(connectionPoint) || updated;
    }

    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        String message = null;
        if (this.keyAuthButton.getSelection()) {
            IPath keyFilePath = Path.fromPortableString((String)this.keyPathLabel.getText());
            try {
                boolean passphraseProtected = SecureUtils.isKeyPassphraseProtected((File)keyFilePath.toFile());
                char[] password = this.passwordText.getText().toCharArray();
                if (passphraseProtected && password.length > 0 && !SecureUtils.isPassphraseValid((File)keyFilePath.toFile(), (char[])password)) {
                    message = "Private Key Passphrase is incorrect";
                }
            }
            catch (CoreException e) {
                message = e.getLocalizedMessage();
            }
        }
        if (message == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
            return true;
        }
        this.setErrorMessage(message);
        return false;
    }

    private void updateProtocolButton() {
        int currentIndex = Arrays.asList(this.protoTypes).indexOf(this.getConnectionPointType());
        if (currentIndex == -1) {
            currentIndex = 0;
        }
        this.protocolButton.setText(this.protoTypes[currentIndex].getName());
    }

    private void updateKeyAuth() {
        boolean keyAuthEnabled = "sftp".equals(this.connectionType.getType());
        CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.keyAuthComposite, keyAuthEnabled);
        this.keyAuthButton.setSelection(false);
        this.changeKeyAuthentication();
    }

    private void updateAdvancedOptions() {
        int currentIndex = Arrays.asList(this.protoTypes).indexOf(this.getConnectionPointType());
        if (currentIndex == -1) {
            currentIndex = 0;
        }
        Composite[] compositeArray = this.advancedOptionsComposites;
        int n = this.advancedOptionsComposites.length;
        int n2 = 0;
        while (n2 < n) {
            Composite composite = compositeArray[n2];
            CommonFTPConnectionPointPropertyDialog.makeVisible((Control)composite, false);
            ++n2;
        }
        Composite advancedOptionComposite = this.advancedOptionsComposites[currentIndex];
        CommonFTPConnectionPointPropertyDialog.makeVisible((Control)advancedOptionComposite, true);
        this.advancedOptions = (IOptionsComposite)advancedOptionComposite;
    }

    private void changeProtocolType(ConnectionPointType newType) {
        if (newType == null || newType == this.getConnectionPointType()) {
            return;
        }
        this.connectionType = newType;
        this.updateProtocolButton();
        this.updateKeyAuth();
        this.updateAdvancedOptions();
        this.updateLayout();
        this.ftpConnectionPoint = this.getOrCreateConnectionPoint(this.connectionType);
        this.advancedOptions.loadPropertiesFrom((Object)this.ftpConnectionPoint);
    }

    private void changeKeyAuthentication() {
        boolean enabled = this.keyAuthButton.getSelection();
        if (enabled) {
            String keyFilePath;
            while (true) {
                File dir;
                FileDialog dlg = new FileDialog(this.getShell(), 4096);
                dlg.setText("Specify Private Key file");
                String ssh_home = SecureUtils.getSSH_HOME();
                if (ssh_home != null && ssh_home.length() != 0 && (dir = new File(ssh_home)).exists() && dir.isDirectory()) {
                    dlg.setFilterPath(ssh_home);
                    String[] stringArray = SecureUtils.getPrivateKeys();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String key = stringArray[n2];
                        if (new File(dir, key).exists()) {
                            dlg.setFileName(key);
                            break;
                        }
                        ++n2;
                    }
                }
                if ((keyFilePath = dlg.open()) == null) {
                    this.keyAuthButton.setSelection(false);
                    return;
                }
                try {
                    boolean passphraseProtected = SecureUtils.isKeyPassphraseProtected((File)new File(keyFilePath));
                    CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.passwordLabel, passphraseProtected);
                    CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.passwordText, passphraseProtected);
                    CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.savePasswordButton, passphraseProtected);
                }
                catch (CoreException e) {
                    UIUtils.showErrorMessage((String)"Private Key File Error", (String)e.getLocalizedMessage());
                    continue;
                }
                break;
            }
            this.keyPathLabel.setText(keyFilePath);
            this.passwordText.setText("");
        } else {
            this.keyPathLabel.setText("No Private Key selected");
            CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.passwordLabel, true);
            CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.passwordText, true);
            CommonFTPConnectionPointPropertyDialog.makeVisible((Control)this.savePasswordButton, true);
        }
        this.updateLayout();
        this.passwordLabel.setText(StringUtils.makeFormLabel((String)(enabled ? "Passphrase" : "Password")));
        this.savePasswordButton.setSelection(false);
        this.validate();
    }

    private static void makeVisible(Control control, boolean visible) {
        control.setVisible(visible);
        ((GridData)control.getLayoutData()).exclude = !visible;
    }

    private void updateLayout() {
        if (this.dialogArea != null) {
            ((Composite)this.dialogArea).layout(true, true);
            this.layoutShell();
        }
    }
}

