/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.wizards;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.wizards.BaseWizard;
import com.aptana.ide.core.ui.wizards.IBaseWizardPage;
import com.aptana.ide.installer.Activator;
import com.aptana.ide.librarymanager.LibraryInfo;
import com.aptana.ide.librarymanager.LibraryManager;
import com.aptana.ide.projects.ProjectsPlugin;
import com.aptana.ide.wizards.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

public class LibraryWizardPage
extends WizardPage
implements IBaseWizardPage {
    private CheckboxTableViewer referenceProjectsViewer;
    private static final String JS_LIBS_TITLE = Messages.LibraryWizardPage_SelectAJAXLibraries;
    private static final String INSTALL_JS_LIBS_LABEL = Messages.LibraryWizardPage_InstallJavascriptLibraries;
    private static final int LIB_LIST_MULTIPLIER = 15;
    private IStructuredContentProvider _contentProvider;
    private ILabelProvider _labelProvider;

    public LibraryWizardPage(String pageName, IStructuredContentProvider contentProvider, ILabelProvider labelProvider) {
        super(pageName);
        this._contentProvider = contentProvider;
        this._labelProvider = labelProvider;
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(font);
        LibraryInfo[] libraryInfoExtensions = LibraryManager.getInstance().getLibraryInfoExtensions();
        if (libraryInfoExtensions.length == 0) {
            Browser browser = new Browser(composite, 2048);
            browser.setLayoutData((Object)new GridData(4, 4, true, true));
            browser.setFont(font);
            Bundle bundle = Platform.getBundle((String)"com.aptana.ide.projects");
            URL url = null;
            try {
                url = FileLocator.toFileURL((URL)bundle.getEntry("html/librarywizardpage.html"));
                browser.setUrl(url.toString());
            }
            catch (IOException e) {
                IdeLog.logInfo((Plugin)ProjectsPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
        } else {
            Label referenceLabel = new Label(composite, 0);
            referenceLabel.setText(JS_LIBS_TITLE);
            referenceLabel.setFont(font);
            this.referenceProjectsViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
            this.referenceProjectsViewer.getTable().setFont(composite.getFont());
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.heightHint = LibraryWizardPage.getDefaultFontHeight((Control)this.referenceProjectsViewer.getTable(), 15);
            this.referenceProjectsViewer.getTable().setLayoutData((Object)data);
            this.referenceProjectsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            this.referenceProjectsViewer.setContentProvider((IContentProvider)this._contentProvider);
            this.referenceProjectsViewer.setLabelProvider((IBaseLabelProvider)this._labelProvider);
            this.referenceProjectsViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        }
        Button installLibrariesButton = new Button(composite, 8);
        installLibrariesButton.setText(INSTALL_JS_LIBS_LABEL);
        installLibrariesButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        installLibrariesButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LibraryWizardPage.this.getWizard().performCancel();
                LibraryWizardPage.this.getWizard().getContainer().getShell().close();
                Activator.launchWizard((boolean)false, (String[])new String[]{"installer.ajax"});
            }
        });
        this.setControl((Control)composite);
    }

    private static int getDefaultFontHeight(Control control, int lines) {
        FontData[] viewerFontData = control.getFont().getFontData();
        int fontHeight = 10;
        if (viewerFontData.length > 0) {
            fontHeight = viewerFontData[0].getHeight();
        }
        return lines * fontHeight;
    }

    public String[] getSelectedLibraries() {
        ArrayList<String> libs = new ArrayList<String>();
        if (this.referenceProjectsViewer != null) {
            Object[] elements = this.referenceProjectsViewer.getCheckedElements();
            int i = 0;
            while (i < elements.length) {
                LibraryInfo item = (LibraryInfo)elements[i];
                URL resolved = item.getResolvedURL();
                if (resolved != null) {
                    libs.add(resolved.getFile());
                }
                ++i;
            }
        }
        return libs.toArray(new String[0]);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setPageComplete(true);
        }
    }

    public void performFinish() {
        IProgressMonitor monitor = ((BaseWizard)this.getWizard()).getFinishProgressMonitor();
        IProject p = ((BaseWizard)this.getWizard()).getCreatedProject();
        String toOpen = null;
        String[] selection = this.getSelectedLibraries();
        int j = 0;
        while (j < selection.length) {
            String destinationDir = p.getLocation().toOSString();
            String sourceDir = selection[j];
            try {
                File f = new File(sourceDir);
                File[] files = f.listFiles();
                if (monitor != null) {
                    monitor.beginTask(StringUtils.format((String)Messages.LibraryProjectWizard_CopyingFiles, (String)selection[j]), files.length);
                }
                int i = 0;
                while (i < files.length) {
                    String name = files[i].getName();
                    if (monitor != null) {
                        monitor.subTask(name);
                    }
                    FileUtils.copy((String)sourceDir, (String)destinationDir, (String)name);
                    if (toOpen == null && (name.toLowerCase().endsWith(".htm") || name.toLowerCase().endsWith(".html"))) {
                        toOpen = name;
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)ProjectsPlugin.getDefault(), (String)Messages.LibraryProjectWizard_UnableToCopyFileToProject, (Throwable)e);
            }
            try {
                p.refreshLocal(2, null);
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)ProjectsPlugin.getDefault(), (String)Messages.LibraryProjectWizard_Error, (Throwable)e);
            }
            ++j;
        }
    }
}

