/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.wizards;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.wizards.BaseWizard;
import com.aptana.ide.projects.ProjectsPlugin;
import com.aptana.ide.wizards.Messages;
import java.net.URL;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.osgi.framework.Bundle;

public class WebProjectWizard
extends BaseWizard
implements IExecutableExtension {
    public static final String ID = "com.aptana.ide.wizards.WebProjectWizard";
    private static final String INDEX_PATH = "/project/index.html";
    private IFile indexFile;

    public WebProjectWizard() {
        super.setIncludeProjectPage(true);
        super.setWindowTitle(Messages.WebProjectWizard_WebProjectWizard);
        this.indexFile = null;
    }

    public String getID() {
        return ID;
    }

    protected IProjectDescription createProjectDescription(String name, IPath path) {
        IProjectDescription description = super.createProjectDescription(name, path);
        description.setNatureIds(new String[]{"com.aptana.ide.project.nature.web"});
        ICommand command = description.newCommand();
        command.setBuilderName("com.aptana.ide.core.unifiedBuilder");
        description.setBuildSpec(new ICommand[]{command});
        return description;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDefaultPageImageDescriptor(ProjectsPlugin.getImageDescriptor("icons/web_project_wiz.png"));
    }

    public IFile getFileToOpenOnFinish() {
        if (this.isCreatingHostedSite()) {
            return null;
        }
        if (this.indexFile != null && this.indexFile.exists()) {
            return this.indexFile;
        }
        return null;
    }

    public String[] getFileNamesToSelect() {
        return new String[]{"index.html", "index.htm"};
    }

    public void finishProjectCreation() {
        URL indexUrl;
        Bundle bundle;
        IProject project = super.getCreatedProject();
        this.indexFile = project.getFile("index.html");
        if (this.indexFile != null && !this.indexFile.exists() && (bundle = Platform.getBundle((String)"com.aptana.ide.projects")) != null && (indexUrl = bundle.getEntry(INDEX_PATH)) != null) {
            try {
                indexUrl = FileLocator.toFileURL((URL)indexUrl);
                this.indexFile.create(indexUrl.openStream(), true, null);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)ProjectsPlugin.getDefault(), (String)Messages.WebProjectWizard_ERR_Creating, (Throwable)e);
            }
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

