/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.internal.ui.preferences;

import com.aptana.ide.editors.internal.ui.preferences.TableLayoutComposite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableViewerEditor
extends FieldEditor {
    private TableViewer fTable;
    protected Control fTableControl;
    private ColumnsDescription fTableColumns;
    private ListViewerAdapter fListViewerAdapter;
    private Composite buttonBox;
    protected List<Object> fElements;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private SelectionListener selectionListener;

    protected TableViewerEditor(String labelText, Composite parent) {
        this.init("", labelText);
        this.fListViewerAdapter = new ListViewerAdapter();
        this.fElements = new ArrayList<Object>(10);
        this.fTableColumns = this.createTableColumns();
        this.createControl(parent);
    }

    protected ColumnsDescription createTableColumns() {
        return null;
    }

    protected abstract ITableLabelProvider createLabelProvider();

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        Object input = this.createObject();
        if (input != null) {
            this.addElement(input);
        }
    }

    private void editPressed() {
        this.setPresentsDefaultValue(false);
        Object toEdit = this.getSelectedElements().get(0);
        Object input = this.editObject(toEdit);
        if (input != null) {
            this.replaceElement(toEdit, input);
        }
    }

    protected abstract Object editObject(Object var1);

    private void replaceElement(Object oldElement, Object newElement) throws IllegalArgumentException {
        int idx = this.fElements.indexOf(oldElement);
        if (idx != -1) {
            this.fElements.set(idx, newElement);
            if (this.isOkToUse(this.fTableControl)) {
                List selected = this.getSelectedElements();
                if (selected.remove(oldElement)) {
                    selected.add(newElement);
                }
                this.fTable.refresh();
                this.selectElements((ISelection)new StructuredSelection(selected));
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.selectionChanged();
    }

    private void selectElements(ISelection selection) {
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.setSelection(selection, true);
        }
    }

    public boolean addElement(Object element) {
        return this.addElement(element, this.fElements.size());
    }

    public boolean addElement(Object element, int index) {
        if (this.fElements.contains(element)) {
            return false;
        }
        this.fElements.add(index, element);
        if (this.isOkToUse(this.fTableControl)) {
            this.fTable.refresh();
            this.fTable.setSelection((ISelection)new StructuredSelection(element));
        }
        this.selectionChanged();
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.fTableControl.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, "ListEditor.add");
        this.editButton = this.createPushButton(box, "TableViewerEditor.edit");
        this.editButton.setText("&Edit...");
        this.removeButton = this.createPushButton(box, "ListEditor.remove");
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    public void createSelectionListener() {
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Widget widget = event.widget;
                if (widget == TableViewerEditor.this.addButton) {
                    TableViewerEditor.this.addPressed();
                } else if (widget == TableViewerEditor.this.editButton) {
                    TableViewerEditor.this.editPressed();
                } else if (widget == TableViewerEditor.this.removeButton) {
                    TableViewerEditor.this.removePressed();
                } else if (widget == TableViewerEditor.this.fTable.getTable()) {
                    TableViewerEditor.this.selectionChanged();
                }
            }
        };
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        Control list = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        list.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected abstract void doLoad();

    public void removeAllElements() {
        if (this.fElements.size() > 0) {
            this.fElements.clear();
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.refresh();
            }
            this.selectionChanged();
        }
    }

    protected abstract void doLoadDefault();

    protected void doStore() {
        Map<String, String> s = this.createPrefMap(this.fElements);
        if (s != null) {
            for (Map.Entry<String, String> entry : s.entrySet()) {
                this.getPreferenceStore().setValue(entry.getKey(), entry.getValue());
            }
        }
    }

    protected abstract Map<String, String> createPrefMap(List<Object> var1);

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    TableViewerEditor.this.addButton = null;
                    TableViewerEditor.this.editButton = null;
                    TableViewerEditor.this.removeButton = null;
                    TableViewerEditor.this.buttonBox = null;
                }
            });
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public Control getListControl(Composite parent) {
        if (this.fTableControl == null) {
            if (this.fTableColumns == null) {
                this.fTable = this.createTableViewer(parent);
                Table tableControl = this.fTable.getTable();
                this.fTableControl = tableControl;
                tableControl.setLayout((Layout)new TableLayout());
            } else {
                TableLayoutComposite composite = new TableLayoutComposite(parent, 0);
                this.fTableControl = composite;
                this.fTable = this.createTableViewer(composite);
                Table tableControl = this.fTable.getTable();
                tableControl.setHeaderVisible(this.fTableColumns.headers != null);
                tableControl.setLinesVisible(this.fTableColumns.drawLines);
                ColumnLayoutData[] columns = this.fTableColumns.columns;
                int i = 0;
                while (i < columns.length) {
                    composite.addColumnData(columns[i]);
                    TableColumn column = new TableColumn(tableControl, 0);
                    if (this.fTableColumns.headers != null) {
                        column.setText(this.fTableColumns.headers[i]);
                    }
                    ++i;
                }
            }
            this.fTable.getTable().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.character == '\u007f' && e.stateMask == 0) {
                        TableViewerEditor.this.removePressed();
                    }
                }
            });
            this.fTable.setContentProvider((IContentProvider)this.fListViewerAdapter);
            this.fTable.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
            this.fTable.addSelectionChangedListener((ISelectionChangedListener)this.fListViewerAdapter);
            this.fTable.addDoubleClickListener((IDoubleClickListener)this.fListViewerAdapter);
            this.fTable.setInput((Object)this);
        }
        return this.fTableControl;
    }

    protected TableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, this.getTableStyle());
        return new TableViewer(table);
    }

    protected int getTableStyle() {
        int style = 2818;
        if (this.fTableColumns != null) {
            style |= 0x10000;
        }
        return style;
    }

    protected abstract Object createObject();

    public int getNumberOfControls() {
        return 3;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        this.removeElements(this.getSelectedElements());
    }

    public List getSelectedElements() {
        ISelection selection;
        ArrayList result = new ArrayList();
        if (this.isOkToUse(this.fTableControl) && (selection = this.fTable.getSelection()) instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                result.add(iter.next());
            }
        }
        return result;
    }

    protected final boolean isOkToUse(Control control) {
        return control != null && Display.getCurrent() != null && !control.isDisposed();
    }

    public void removeElement(Object element) throws IllegalArgumentException {
        if (this.fElements.remove(element)) {
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.remove(element);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.selectionChanged();
    }

    public void removeElements(List elements) {
        if (elements.size() > 0) {
            this.fElements.removeAll(elements);
            if (this.isOkToUse(this.fTableControl)) {
                this.fTable.remove(elements.toArray());
            }
            this.selectionChanged();
        }
    }

    protected void selectionChanged() {
        this.removeButton.setEnabled(!this.fTable.getSelection().isEmpty());
    }

    public void setFocus() {
        if (this.fTable != null) {
            this.fTableControl.setFocus();
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getListControl(parent).setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.editButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getEditButton() {
        return this.editButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected TableViewer getTableViewer() {
        return this.fTable;
    }

    public void doDoubleClick(DoubleClickEvent event) {
    }

    public void doListSelected(SelectionChangedEvent event) {
    }

    public static class ColumnsDescription {
        private ColumnLayoutData[] columns;
        private String[] headers;
        private boolean drawLines;

        public ColumnsDescription(ColumnLayoutData[] columns, String[] headers, boolean drawLines) {
            this.columns = columns;
            this.headers = headers;
            this.drawLines = drawLines;
        }

        public ColumnsDescription(String[] headers, boolean drawLines) {
            this(ColumnsDescription.createColumnWeightData(headers.length), headers, drawLines);
        }

        public ColumnsDescription(int nColumns, boolean drawLines) {
            this(ColumnsDescription.createColumnWeightData(nColumns), null, drawLines);
        }

        private static ColumnLayoutData[] createColumnWeightData(int nColumns) {
            ColumnLayoutData[] data = new ColumnLayoutData[nColumns];
            int i = 0;
            while (i < nColumns) {
                data[i] = new ColumnWeightData(1);
                ++i;
            }
            return data;
        }
    }

    private class ListViewerAdapter
    implements IStructuredContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private ListViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public void dispose() {
        }

        public Object[] getElements(Object obj) {
            return TableViewerEditor.this.fElements.toArray();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TableViewerEditor.this.doListSelected(event);
        }

        public void doubleClick(DoubleClickEvent event) {
            TableViewerEditor.this.doDoubleClick(event);
        }
    }
}

