/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.internal.ui.preferences;

import com.aptana.ide.editors.internal.ui.preferences.TodoPreferencePage;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TodoTaskDialog
extends StatusDialog {
    private Text fNameDialogField;
    private Combo fPriorityDialogField;
    private List<String> fExistingNames;
    private TodoPreferencePage.TodoTask fTask;

    public TodoTaskDialog(Shell parent, TodoPreferencePage.TodoTask task, List existingEntries) {
        super(parent);
        this.fExistingNames = new ArrayList<String>(existingEntries.size());
        for (TodoPreferencePage.TodoTask curr : existingEntries) {
            if (curr.equals(task)) continue;
            this.fExistingNames.add(curr.name);
        }
        if (task == null) {
            this.setTitle("New Task Tag");
        } else {
            this.setTitle("Edit Task Tag");
        }
        this.fTask = task;
    }

    public TodoPreferencePage.TodoTask getResult() {
        return this.fTask;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        Label label = new Label(inner, 0);
        label.setText("Tag: ");
        this.fNameDialogField = new Text(inner, 2052);
        this.fNameDialogField.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                TodoTaskDialog.this.doValidation();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.fNameDialogField.setText(this.fTask != null ? this.fTask.name : "");
        GridData gridData = new GridData(4, 4, false, false);
        this.fNameDialogField.setLayoutData((Object)gridData);
        String[] items = new String[]{"High", "Normal", "Low"};
        label = new Label(inner, 0);
        label.setText("Priority: ");
        this.fPriorityDialogField = new Combo(inner, 8);
        this.fPriorityDialogField.setItems(items);
        if (this.fTask != null) {
            if ("HIGH".equals(this.fTask.priority)) {
                this.fPriorityDialogField.select(0);
            } else if ("NORMAL".equals(this.fTask.priority)) {
                this.fPriorityDialogField.select(1);
            } else {
                this.fPriorityDialogField.select(2);
            }
        } else {
            this.fPriorityDialogField.select(1);
        }
        TodoTaskDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void doValidation() {
        IStatus status = Status.OK_STATUS;
        String newText = this.fNameDialogField.getText();
        if (newText.length() == 0) {
            status = new Status(4, "com.aptana.ide.editors", -1, "Enter Name", null);
        } else if (newText.indexOf(44) != -1) {
            status = new Status(4, "com.aptana.ide.editors", -1, "Comma not allowed in name", null);
        } else if (this.fExistingNames.contains(newText)) {
            status = new Status(4, "com.aptana.ide.editors", -1, "An existing entry already uses this name", null);
        } else if (Character.isWhitespace(newText.charAt(0)) || Character.isWhitespace(newText.charAt(newText.length() - 1))) {
            status = new Status(4, "com.aptana.ide.editors", -1, "Spaces not allowed in name", null);
        }
        this.updateStatus(status);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected void okPressed() {
        String name = this.fNameDialogField.getText().trim();
        String priority = "NORMAL";
        switch (this.fPriorityDialogField.getSelectionIndex()) {
            case 0: {
                priority = "HIGH";
                break;
            }
            case 1: {
                priority = "NORMAL";
                break;
            }
            default: {
                priority = "LOW";
            }
        }
        this.fTask = new TodoPreferencePage.TodoTask(name, priority);
        super.okPressed();
    }
}

