/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.http;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RequestLineParser {
    private static Pattern HTTP_PATTERN = Pattern.compile("(GET|HEAD|POST)\\s(/[^\\?]*)(.*)\\sHTTP/1\\.[0-9]");
    private String _method;
    private String _uri;
    private String _queryString;
    private Hashtable _keyValuePairs;

    public String getMethod() {
        return this._method;
    }

    public String getUri() {
        return this._uri;
    }

    public String getQueryString() {
        return this._queryString;
    }

    public String getKeyValue(String name) {
        return (String)this._keyValuePairs.get(name);
    }

    public boolean hasKey(String name) {
        return this._keyValuePairs.containsKey(name);
    }

    public String[] getKeys() {
        return this._keyValuePairs.keySet().toArray(new String[0]);
    }

    RequestLineParser(String header) {
        if (header != null && header.length() > 0) {
            this._keyValuePairs = new Hashtable();
            String reqLine = header.substring(0, header.indexOf("\r\n"));
            Matcher matcher = HTTP_PATTERN.matcher(reqLine);
            if (matcher.matches()) {
                int groupCount = matcher.groupCount();
                if (groupCount >= 1) {
                    this._method = matcher.group(1).toUpperCase();
                }
                if (groupCount >= 2) {
                    this._uri = matcher.group(2);
                    this._uri = this.getUrlDecodedValue(this._uri);
                }
                if (groupCount == 3) {
                    this._queryString = matcher.group(3);
                    if (this._queryString.length() > 0) {
                        this._queryString = this._queryString.substring(1);
                        this._queryString = this.getUrlDecodedValue(this._queryString);
                    }
                    this.parseQueryString(this._queryString);
                }
            }
        }
    }

    private void parseQueryString(String queryString) {
        if (queryString == null || this._queryString.length() == 0) {
            return;
        }
        String[] pairs = queryString.split("&");
        int i = 0;
        while (i < pairs.length) {
            String[] nameValue = pairs[i].split("=");
            String name = nameValue[0];
            if (name != null && name.length() > 0) {
                this._keyValuePairs.put(name, nameValue.length > 1 ? nameValue[1] : "");
            }
            ++i;
        }
    }

    private String getUrlDecodedValue(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception exception) {
            try {
                return URLDecoder.decode(s, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return s;
            }
        }
    }
}

