/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.resources;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.core.ServerCorePlugin;
import com.aptana.ide.server.http.HttpContentTypes;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.resources.IHttpResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;

public class WorkspaceHttpResource
implements IHttpResource {
    IFile _resource;

    public WorkspaceHttpResource(IFile resource) {
        this._resource = resource;
    }

    public InputStream getContentInputStream(HttpServer server) throws IOException {
        try {
            return this._resource.getContents();
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
    }

    public long getContentLength() {
        try {
            IFileStore store = EFS.getStore((URI)this._resource.getLocationURI());
            IFileInfo info = store.fetchInfo();
            return info.getLength();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)ServerCorePlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            return -1L;
        }
    }

    public String getContentType() {
        String fileExtension = this._resource.getFileExtension();
        String contentType = HttpContentTypes.getContentType("." + fileExtension);
        if (contentType == null) {
            contentType = "text/plain";
        }
        return contentType;
    }
}

