/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.update.internal.manager;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.internal.update.manager.AbstractPluginManager;
import com.aptana.ide.update.P2Activator;
import com.aptana.ide.update.internal.manager.Messages;
import com.aptana.ide.update.manager.IPlugin;
import com.aptana.ide.update.manager.PluginManagerException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.console.ProvisioningHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.SimpleLicenseManager;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.InstallAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.UninstallWizard;
import org.eclipse.equinox.internal.provisional.p2.ui.model.ProfileElement;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.LicenseManager;
import org.eclipse.equinox.internal.provisional.p2.ui.sdk.ProvPolicies;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P2PluginManager
extends AbstractPluginManager {
    public void checkForUpdates(boolean immediate) {
        if (!immediate) {
            ProvSDKUIActivator.getDefault().getScheduler().earlyStartup();
            return;
        }
        Preferences prefs = ProvSDKUIActivator.getDefault().getPluginPreferences();
        boolean wasEnabled = prefs.getBoolean("enabled");
        String oldSchedule = prefs.getString("schedule");
        prefs.setValue("enabled", true);
        prefs.setValue("schedule", "on-startup");
        ProvSDKUIActivator.getDefault().savePluginPreferences();
        ProvSDKUIActivator.getDefault().getScheduler().earlyStartup();
        prefs.setValue("enabled", wasEnabled);
        prefs.setValue("schedule", oldSchedule);
        ProvSDKUIActivator.getDefault().savePluginPreferences();
    }

    public IStatus install(IPlugin[] plugins, IProgressMonitor monitor) throws PluginManagerException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        IInstallableUnit[] toInstall = P2PluginManager.getInstallationUnits(plugins, "_SELF_");
        if (toInstall.length <= 0) {
            throw new PluginManagerException(Messages.P2PluginManager_ERR_MSG_No_installable_units_found);
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        ProvisioningPlan result = P2PluginManager.getInstallationProvisioningPlan(toInstall, "_SELF_");
        if (!P2PluginManager.validatePlan(result)) {
            return Status.CANCEL_STATUS;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        SimpleLicenseManager licenseManager = ProvSDKUIActivator.getDefault().getLicenseManager();
        InstallWizard wizard = new InstallWizard("_SELF_", toInstall, result, (LicenseManager)licenseManager);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.install_wizard_context");
        dialog.open();
        return Status.OK_STATUS;
    }

    private static IInstallableUnit[] getInstallationUnits(final IPlugin[] plugins, final String profileId) throws PluginManagerException {
        final ArrayList units = new ArrayList();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * Unable to fully structure code
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(plugins.length * 4));
                sub.setTaskName(Messages.P2PluginManager_Locating_selected_features_job_title);
                try {
                    i = 0;
                    while (i < plugins.length) {
                        plugin = plugins[i];
                        manager = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)P2Activator.getContext(), (String)IMetadataRepositoryManager.class.getName());
                        repo = manager.loadRepository(plugin.getURL(), (IProgressMonitor)new NullProgressMonitor());
                        if (repo == null) {
                            throw new ProvisionException(String.valueOf(Messages.P2PluginManager_ERR_MSG_Metadata_repo_not_found) + plugin.getURL());
                        }
                        if (!manager.isEnabled(plugin.getURL())) {
                            manager.setEnabled(plugin.getURL(), true);
                        }
                        sub.worked(1);
                        artifactManager = (IArtifactRepositoryManager)ServiceHelper.getService((BundleContext)P2Activator.getContext(), (String)IArtifactRepositoryManager.class.getName());
                        artifactRepo = artifactManager.loadRepository(plugin.getURL(), (IProgressMonitor)new NullProgressMonitor());
                        if (artifactRepo == null) {
                            throw new ProvisionException(String.valueOf(Messages.P2PluginManager_ERR_MSG_Artifact_repo_not_found) + plugin.getURL());
                        }
                        if (!artifactManager.isEnabled(plugin.getURL())) {
                            artifactManager.setEnabled(plugin.getURL(), true);
                        }
                        sub.worked(1);
                        query = new InstallableUnitQuery(P2PluginManager.access$1(plugin), VersionRange.emptyRange);
                        roots = repo.query((Query)query, (Collector)new LatestIUVersionCollector(), monitor);
                        if (roots.size() > 0) ** GOTO lbl29
                        if (monitor.isCanceled()) {
                            return;
                        }
                        try {
                            profile = ProvisioningHelper.getProfile((String)profileId);
                            roots = profile.query((Query)query, roots, monitor);
lbl29:
                            // 2 sources

                            units.addAll(roots.toCollection());
                            sub.worked(2);
                            ++i;
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
                finally {
                    sub.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            throw new PluginManagerException(Messages.ProfileModificationAction_UnexpectedError, e.getCause());
        }
        return units.toArray(new IInstallableUnit[units.size()]);
    }

    private static ProvisioningPlan getInstallationProvisioningPlan(final IInstallableUnit[] ius, final String profileId) {
        final ProvisioningPlan[] plan = new ProvisioningPlan[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    plan[0] = InstallAction.computeProvisioningPlan((IInstallableUnit[])ius, (String)profileId, (IProgressMonitor)monitor);
                }
                catch (ProvisionException e) {
                    ProvUI.handleException((Throwable)e, (String)Messages.ProfileModificationAction_UnexpectedError, (int)5);
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            ProvUI.handleException((Throwable)e.getCause(), (String)Messages.ProfileModificationAction_UnexpectedError, (int)5);
        }
        return plan[0];
    }

    private static boolean validatePlan(ProvisioningPlan plan) {
        if (plan != null) {
            if (plan.getStatus().getSeverity() == 8) {
                return false;
            }
            if (ProvPolicies.getDefault().getPlanValidator() != null) {
                return ProvPolicies.getDefault().getPlanValidator().continueWorkingWithPlan(plan, Display.getDefault().getActiveShell());
            }
            if (plan.getStatus().isOK()) {
                return true;
            }
            ProvUI.reportStatus((IStatus)plan.getStatus(), (int)5);
            return false;
        }
        return false;
    }

    public IStatus uninstall(IPlugin plugin, IProgressMonitor monitor) throws PluginManagerException {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        Collector roots = new Collector();
        try {
            InstallableUnitQuery query = new InstallableUnitQuery(P2PluginManager.getFeatureGroupName(plugin), new Version(plugin.getVersion()));
            ProfileElement element = new ProfileElement("_SELF_");
            roots = element.getQueryable().query((Query)query, roots, monitor);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)P2Activator.getDefault(), (String)e.getMessage(), (Throwable)e);
        }
        if (roots == null || roots.size() <= 0) {
            throw new PluginManagerException(Messages.P2PluginManager_ERR_MSG_No_installable_units_found);
        }
        IInstallableUnit[] ius = (IInstallableUnit[])roots.toArray(IInstallableUnit.class);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        ProvisioningPlan plan = P2PluginManager.getUninstallationProvisioningPlan(ius, "_SELF_");
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        UninstallWizard wizard = new UninstallWizard("_SELF_", ius, plan);
        WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.equinox.p2.ui.uinstall_wizard_context");
        dialog.open();
        return Status.OK_STATUS;
    }

    public boolean addUpdateSite(URL siteURL) {
        URL[] existingMetaRepos = ProvisioningHelper.getMetadataRepositories();
        if (P2PluginManager.contains(existingMetaRepos, siteURL)) {
            return false;
        }
        ProvisioningHelper.addMetadataRepository((URL)siteURL);
        ProvisioningHelper.addArtifactRepository((URL)siteURL);
        return true;
    }

    public void removeUpdateSite(URL siteURL) {
        ProvisioningHelper.removeMetadataRepository((URL)siteURL);
        ProvisioningHelper.removeArtifactRepository((URL)siteURL);
    }

    private static String getFeatureGroupName(IPlugin plugin) throws CoreException {
        return String.valueOf(plugin.getId()) + ".feature.group";
    }

    private static ProvisioningPlan getUninstallationProvisioningPlan(final IInstallableUnit[] ius, final String profileId) {
        final ProvisioningPlan[] plan = new ProvisioningPlan[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)profileId);
                    request.removeInstallableUnits(ius);
                    plan[0] = ProvisioningUtil.getProvisioningPlan((ProfileChangeRequest)request, (ProvisioningContext)new ProvisioningContext(), (IProgressMonitor)monitor);
                }
                catch (ProvisionException e) {
                    ProvUI.handleException((Throwable)e, (String)Messages.ProfileModificationAction_UnexpectedError, (int)5);
                }
            }
        };
        try {
            new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            ProvUI.handleException((Throwable)e.getCause(), (String)Messages.ProfileModificationAction_UnexpectedError, (int)5);
        }
        return plan[0];
    }

    private static boolean contains(URL[] existingMetaRepos, URL updateSiteURL) {
        if (existingMetaRepos == null) {
            return false;
        }
        int i = 0;
        while (i < existingMetaRepos.length) {
            if (existingMetaRepos[i].equals(updateSiteURL)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isFeatureInstalled(String id) {
        return this.getInstalledFeature(id) != null;
    }

    public com.aptana.ide.update.manager.Plugin getInstalledFeature(String id) {
        Collector roots;
        IProfile[] profiles;
        BundleContext context;
        ServiceReference ref;
        if (id == null) {
            return null;
        }
        if (!id.endsWith(".feature.group")) {
            id = String.valueOf(id) + ".feature.group";
        }
        if ((ref = (context = P2Activator.getDefault().getBundle().getBundleContext()).getServiceReference(IProfileRegistry.class.getName())) == null) {
            return null;
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)context.getService(ref);
        if (profileRegistry == null) {
            return null;
        }
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null && (profiles = profileRegistry.getProfiles()) != null && profiles.length > 0) {
            profile = profiles[0];
        }
        if ((roots = profile.available((Query)new InstallableUnitQuery(id), new Collector(), (IProgressMonitor)new NullProgressMonitor())) == null || roots.size() == 0) {
            return null;
        }
        try {
            return this.toPlugin((IInstallableUnit)roots.iterator().next());
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)P2Activator.getDefault(), (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public List<IPlugin> getInstalledPlugins() {
        IProfile[] profiles;
        BundleContext context = P2Activator.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(IProfileRegistry.class.getName());
        if (ref == null) {
            return Collections.emptyList();
        }
        IProfileRegistry profileRegistry = (IProfileRegistry)context.getService(ref);
        if (profileRegistry == null) {
            return Collections.emptyList();
        }
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null && (profiles = profileRegistry.getProfiles()) != null && profiles.length > 0) {
            profile = profiles[0];
        }
        if (profile == null) {
            return Collections.emptyList();
        }
        Collector roots = profile.available((Query)new InstallableUnitQuery("FakeId"){

            public boolean isMatch(Object object) {
                if (!(object instanceof IInstallableUnit)) {
                    return false;
                }
                IInstallableUnit candidate = (IInstallableUnit)object;
                String name = candidate.getId();
                return name != null && name.endsWith(".feature.group");
            }
        }, new Collector(), (IProgressMonitor)new NullProgressMonitor());
        IInstallableUnit[] ius = (IInstallableUnit[])roots.toArray(IInstallableUnit.class);
        ArrayList<IPlugin> plugins = new ArrayList<IPlugin>();
        IInstallableUnit[] iInstallableUnitArray = ius;
        int n = ius.length;
        int n2 = 0;
        while (n2 < n) {
            IInstallableUnit iu = iInstallableUnitArray[n2];
            try {
                plugins.add((IPlugin)this.toPlugin(iu));
            }
            catch (MalformedURLException e) {
                IdeLog.logError((Plugin)P2Activator.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
            ++n2;
        }
        return plugins;
    }

    public String getUpdatePreferencePageId() {
        return "org.eclipse.equinox.internal.p2.ui.sdk.AutomaticUpdatesPreferencePage";
    }

    private com.aptana.ide.update.manager.Plugin toPlugin(IInstallableUnit iu) throws MalformedURLException {
        String name = iu.getProperty("df_LT.featureName");
        if (name == null) {
            name = iu.getProperty("org.eclipse.equinox.p2.name");
        }
        if (name == null) {
            name = iu.getId();
        }
        return new com.aptana.ide.update.manager.Plugin(this.stripFeatureGroup(iu.getId()), name, iu.getVersion().toString(), null, iu.getProperty("df_LT.description"), new URL("file:/fake/" + iu.getId()), "", "", 0, null, "", null);
    }

    private String stripFeatureGroup(String id) {
        if (id == null) {
            return null;
        }
        if (id.endsWith(".feature.group")) {
            return id.substring(0, id.length() - ".feature.group".length());
        }
        return id;
    }

    public URI[] getAllMetadataRepositories() {
        URL[] urls;
        ArrayList<URI> uris = new ArrayList<URI>();
        URL[] uRLArray = urls = ProvisioningHelper.getMetadataRepositories();
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            try {
                uris.add(url.toURI());
            }
            catch (Exception exception) {}
            ++n2;
        }
        return uris.toArray(new URI[0]);
    }

    static /* synthetic */ String access$1(IPlugin iPlugin) throws CoreException {
        return P2PluginManager.getFeatureGroupName(iPlugin);
    }

    private static class LatestIUVersionCollector
    extends Collector {
        private Map<String, Object> uniqueIds = new HashMap<String, Object>();

        private LatestIUVersionCollector() {
        }

        public boolean accept(Object match) {
            if (!(match instanceof IInstallableUnit)) {
                return true;
            }
            IInstallableUnit iu = (IInstallableUnit)match;
            Object matchElement = this.uniqueIds.get(iu.getId());
            if (matchElement == null || iu.getVersion().compareTo((Object)this.getIU(matchElement).getVersion()) > 0) {
                if (matchElement != null) {
                    this.getList().remove(matchElement);
                }
                matchElement = this.makeDefaultElement(iu);
                this.uniqueIds.put(iu.getId(), matchElement);
                return super.accept(matchElement);
            }
            return true;
        }

        private Object makeDefaultElement(IInstallableUnit iu) {
            return iu;
        }

        protected IInstallableUnit getIU(Object matchElement) {
            if (matchElement instanceof IInstallableUnit) {
                return (IInstallableUnit)matchElement;
            }
            return null;
        }
    }
}

