/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.Workbench;

public class AutoOpenPerspectivesJob
extends Job {
    private static final String EXTENSION_POINT = "perspectives";
    private static final String ADDED_PERSPECTIVE = String.valueOf(CoreUIPlugin.getPluginId()) + ".forced_perspective_open.";

    public AutoOpenPerspectivesJob() {
        super(Messages.AutoOpenPerspectivesJob_MSG_AutomaticallyOpeningNewPerspectives);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return Status.CANCEL_STATUS;
        }
        if (wb instanceof Workbench) {
            Workbench wb1 = (Workbench)wb;
            while (!wb1.isRunning()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>(Arrays.asList(registry.getConfigurationElementsFor(CoreUIPlugin.getPluginId(), EXTENSION_POINT)));
        for (IConfigurationElement configurationElement : elements) {
            String id = configurationElement.getAttribute("id");
            if (this.openPerspective(id)) break;
        }
        return Status.OK_STATUS;
    }

    private IPreferenceStore getPreferenceStore() {
        return CoreUIPlugin.getDefault().getPreferenceStore();
    }

    private boolean openPerspective(final String perspectiveId) {
        if (this.getPreferenceStore().getBoolean(String.valueOf(ADDED_PERSPECTIVE) + perspectiveId)) {
            return false;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    PlatformUI.getWorkbench().showPerspective(perspectiveId, window);
                    AutoOpenPerspectivesJob.this.getPreferenceStore().setValue(String.valueOf(ADDED_PERSPECTIVE) + perspectiveId, true);
                }
                catch (WorkbenchException workbenchException) {}
            }
        });
        return true;
    }
}

