/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.ExternalBrowserInstance;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.ui.internal.browser.IBrowserExt;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;

final class BrowserLaunchHelper {
    private BrowserLaunchHelper() {
    }

    static void launchBrowser(String url, String browserId) {
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = null;
            if (browserId != null) {
                List list = BrowserManager.getInstance().getWebBrowsers();
                for (IBrowserDescriptor desc : list) {
                    IBrowserExt ext;
                    if (desc.getLocation() == null || (ext = WebBrowserUIPlugin.findBrowsers((String)desc.getLocation())) == null || !browserId.equals(ext.getId())) continue;
                    browser = ext.createBrowser(browserId, desc.getLocation(), desc.getParameters());
                    if (browser == null) {
                        browser = new ExternalBrowserInstance(browserId, desc);
                    }
                    break;
                }
            } else {
                browser = support.getExternalBrowser();
            }
            if (browser != null) {
                String urlEncoded = StringUtils.urlEncodeForSpaces((char[])url.toCharArray());
                browser.openURL(new URL(urlEncoded));
            }
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.WorkbenchHelper_UnableToLaunchBrowser, (Throwable)e);
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.WorkbenchHelper_UnableToLaunchBrowser, (Throwable)e);
        }
    }
}

