/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;

public class ColorPair {
    private RGB _foregroundColor;
    private RGB _backgroundColor;
    public static final ColorPair COLOR_DEFAULT_DEFAULT = new ColorPair(new RGB(0, 0, 0), null);

    public RGB getBackgroundColor() {
        return this._backgroundColor;
    }

    public void setBackgroundColor(RGB backgroundColor) {
        this._backgroundColor = backgroundColor;
    }

    public RGB getForegroundColor() {
        return this._foregroundColor;
    }

    public void setForegroundColor(RGB foregroundColor) {
        this._foregroundColor = foregroundColor;
    }

    public ColorPair(RGB foregroundColor, RGB backgroundColor) {
        this._foregroundColor = foregroundColor;
        this._backgroundColor = backgroundColor;
    }

    private static ColorPair basicGetColorPair(String value) {
        ColorPair color = ColorPair.asColorPair(value);
        if (color == null) {
            return COLOR_DEFAULT_DEFAULT;
        }
        return color;
    }

    public static ColorPair getColorPair(IPreferenceStore store, String name) {
        return ColorPair.basicGetColorPair(store.getString(name));
    }

    public static ColorPair getDefaultColorPair(IPreferenceStore store, String name) {
        return ColorPair.basicGetColorPair(store.getDefaultString(name));
    }

    public static void setDefault(IPreferenceStore store, String name, ColorPair value) {
        store.setDefault(name, ColorPair.asString(value));
    }

    public static String asString(ColorPair value) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(StringConverter.asString((RGB)value.getForegroundColor()));
        if (value.getBackgroundColor() != null) {
            buffer.append(';');
            buffer.append(StringConverter.asString((RGB)value.getBackgroundColor()));
        }
        return buffer.toString();
    }

    public static ColorPair asColorPair(String value) throws DataFormatException {
        if (value == null) {
            throw new DataFormatException("Null doesn't represent a valid ColorPair");
        }
        StringTokenizer stok = new StringTokenizer(value, ";");
        try {
            String color1 = stok.nextToken();
            String color2 = null;
            if (stok.hasMoreTokens()) {
                color2 = stok.nextToken();
                return new ColorPair(StringConverter.asRGB((String)color1), StringConverter.asRGB((String)color2));
            }
            return new ColorPair(StringConverter.asRGB((String)color1), null);
        }
        catch (NoSuchElementException e) {
            throw new DataFormatException(e.getMessage());
        }
    }

    public static void setValue(IPreferenceStore store, String name, ColorPair value) {
        ColorPair oldValue = ColorPair.getColorPair(store, name);
        if (oldValue == null || !oldValue.equals(value)) {
            store.putValue(name, ColorPair.asString(value));
            store.firePropertyChangeEvent(name, (Object)oldValue, (Object)value);
        }
    }
}

