/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.db.EventInfo;
import com.aptana.ide.core.db.EventLogger;
import com.aptana.ide.core.model.RESTServiceProvider;
import com.aptana.ide.core.online.OnlineDetectionService;
import com.aptana.ide.core.ui.AptanaAuthenticator;
import com.aptana.ide.core.ui.AutoOpenPerspectivesJob;
import com.aptana.ide.core.ui.ConfigExtensionLoader;
import com.aptana.ide.core.ui.InitialRestartStartup;
import com.aptana.ide.core.ui.InitialStartup;
import com.aptana.ide.core.ui.PartListenerAdapter;
import com.aptana.ide.core.ui.RESTServiceListener;
import com.aptana.ide.core.ui.install.PlatformValidatorPatcher;
import java.net.Authenticator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.update.internal.ui.UpdateUI;
import org.osgi.framework.BundleContext;

public class CoreUIPlugin
extends AbstractUIPlugin {
    private static CoreUIPlugin plugin;
    private static Map<String, Image> images;
    private AptanaAuthenticator aptanaAuth;
    public static String ID;
    public static final String WIZARD_EXTENSION_POINT;
    private final IPartListener partListener = new PartListenerAdapter(){

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                CoreUIPlugin.this.checkPortal((IEditorPart)part, false);
                CoreUIPlugin.this.recordEditorOpening(part);
            }
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                CoreUIPlugin.this.checkPortal((IEditorPart)part, true);
            }
        }
    };
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.removePartListener(CoreUIPlugin.this.partListener);
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
            IPartService partService = window.getPartService();
            if (partService != null) {
                partService.addPartListener(CoreUIPlugin.this.partListener);
            }
        }
    };
    private final RESTServiceListener serviceListener = new RESTServiceListener();

    static {
        images = new HashMap<String, Image>();
        ID = "com.aptana.ide.core.ui";
        WIZARD_EXTENSION_POINT = String.valueOf(ID) + ".wizard";
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        super.start(context);
        InitialRestartStartup.start();
        InitialStartup.start();
        PlatformValidatorPatcher.start();
        UpdateUI.getDefault();
        this.aptanaAuth = new AptanaAuthenticator();
        Authenticator.setDefault(this.aptanaAuth);
        AutoOpenPerspectivesJob job = new AutoOpenPerspectivesJob();
        job.setSystem(true);
        job.setPriority(50);
        job.schedule(5000L);
        this.addPartListener();
        RESTServiceProvider.addListener((RESTServiceProvider.Listener)this.serviceListener);
        ConfigExtensionLoader.init();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            this.removePartListener();
            RESTServiceProvider.removeListener((RESTServiceProvider.Listener)this.serviceListener);
        }
        finally {
            super.stop(context);
            plugin = null;
        }
    }

    public static Image getImage(String path) {
        if (images.get(path) == null) {
            ImageDescriptor id = CoreUIPlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            Image i = id.createImage();
            images.put(path, i);
            return i;
        }
        return images.get(path);
    }

    public static CoreUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)path);
    }

    public static String getPluginId() {
        return CoreUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static IWorkbenchPage getActivePage() {
        CoreUIPlugin plugin = CoreUIPlugin.getDefault();
        IWorkbenchWindow window = plugin.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return CoreUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    private void addPartListener() {
        UIJob job = new UIJob("Add part listener"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IWorkbenchWindow[] workbenchWindows;
                try {
                    PlatformUI.getWorkbench();
                }
                catch (IllegalStateException illegalStateException) {
                    this.schedule(500L);
                    return Status.CANCEL_STATUS;
                }
                IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n = workbenchWindows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                    IPartService partService = workbenchWindow.getPartService();
                    if (partService != null) {
                        partService.addPartListener(CoreUIPlugin.this.partListener);
                    }
                    ++n2;
                }
                PlatformUI.getWorkbench().addWindowListener(CoreUIPlugin.this.windowListener);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(20);
        job.schedule();
    }

    private void removePartListener() {
        IWorkbenchWindow[] workbenchWindows;
        IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = workbenchWindows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            IPartService partService = workbenchWindow.getPartService();
            if (partService != null) {
                partService.removePartListener(this.partListener);
            }
            ++n2;
        }
        PlatformUI.getWorkbench().removeWindowListener(this.windowListener);
    }

    private void checkPortal(IEditorPart part, boolean closed) {
        if ("com.aptana.ide.server.cloud.ui.PortalEditor".equals(part.getSite().getId())) {
            OnlineDetectionService.getInstance().setDelay(closed);
        }
    }

    private void recordEditorOpening(IWorkbenchPart part) {
        String keyName = "editor.opened";
        EventInfo[] events = EventLogger.getInstance().getEvents(keyName);
        String editorName = part.getClass().getName();
        if (events != null && events.length > 0) {
            EventInfo[] eventInfoArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                EventInfo event = eventInfoArray[n2];
                String msg = event.getMessage();
                if (msg != null && msg.equals(editorName)) {
                    return;
                }
                ++n2;
            }
        }
        EventLogger.getInstance().logEvent(keyName, editorName);
    }
}

