/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.db.AptanaDB;
import com.aptana.ide.core.db.IResultSetHandler;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.Messages;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageUtils {
    private static Color whiteBackground = null;
    private static ImageRegistry imageRegistry = null;
    private static Image fIconDrive = null;
    private static ISharedImages sharedImages = null;
    private static Image iconFolder = null;
    private static Image iconFile = null;
    private static boolean imageCacheLoaded = false;
    public static Map<String, Image> fileIconsHash = new HashMap<String, Image>();

    private ImageUtils() {
    }

    public static ImageDescriptor getImageDescriptor(String imageFilePath) {
        ImageDescriptor imageDescriptor = CoreUIPlugin.getImageDescriptor(imageFilePath);
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return imageDescriptor;
    }

    public static Image getIcon(File file, org.eclipse.swt.graphics.Color backgroundColor) {
        if (!CoreUIUtils.onMacOSX) {
            String fileType = null;
            String fileDisplayName = null;
            try {
                fileType = FileSystemView.getFileSystemView().getSystemTypeDescription(file);
                fileDisplayName = FileSystemView.getFileSystemView().getSystemDisplayName(file);
            }
            catch (Exception exception) {}
            if (fileDisplayName != null && fileType != null) {
                if (fileDisplayName.equals("Desktop")) {
                    fileType = "Desktop";
                }
                if (fileIconsHash.containsKey(fileType)) {
                    return fileIconsHash.get(fileType);
                }
                if (fileIconsHash.containsKey(String.valueOf(fileType) + "#" + fileDisplayName)) {
                    return fileIconsHash.get(String.valueOf(fileType) + "#" + fileDisplayName);
                }
                Icon icon = FileSystemView.getFileSystemView().getSystemIcon(file);
                if (icon instanceof ImageIcon) {
                    Image image = ImageUtils.awtImageIconToSWTImage(icon, backgroundColor);
                    if (fileType.equals("Application") || fileType.equals("System Folder") || fileDisplayName.equals("Desktop") || fileType.indexOf("Shortcut") > -1) {
                        fileIconsHash.put(String.valueOf(fileType) + "#" + fileDisplayName, image);
                    } else {
                        fileIconsHash.put(fileType, image);
                    }
                    return image;
                }
            }
        }
        if (file.getName().equals("")) {
            return ImageUtils.getDriveIcon();
        }
        if (FileUtils.isDirectory((File)file)) {
            return ImageUtils.getFolderIcon();
        }
        int lastDotPos = file.getName().indexOf(46);
        if (lastDotPos == -1) {
            return ImageUtils.getFileIcon();
        }
        Image image = ImageUtils.getIcon(file.getName().substring(lastDotPos + 1));
        return image == null ? ImageUtils.getFileIcon() : image;
    }

    public static Image getDriveIcon() {
        if (fIconDrive == null) {
            fIconDrive = ImageUtils.getImageDescriptor("icons/drive.gif").createImage();
        }
        return fIconDrive;
    }

    public static Image getFolderIcon() {
        ImageUtils.checkSharedImages();
        if (iconFolder == null) {
            iconFolder = sharedImages.getImage("IMG_OBJ_FOLDER");
        }
        return iconFolder;
    }

    public static Image getFileIcon() {
        ImageUtils.checkSharedImages();
        if (iconFile == null) {
            iconFile = sharedImages.getImage("IMG_OBJ_FILE");
        }
        return iconFile;
    }

    private static void checkSharedImages() {
        if (sharedImages == null) {
            sharedImages = PlatformUI.getWorkbench().getSharedImages();
        }
    }

    public static Image getIcon(String extension) {
        ImageData imageData;
        Image image;
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        if ((image = imageRegistry.get(extension)) != null) {
            return image;
        }
        if (extension == null) {
            return iconFile;
        }
        Program program = Program.findProgram((String)extension);
        ImageData imageData2 = imageData = program == null ? null : program.getImageData();
        if (imageData != null) {
            image = new Image((Device)Display.getCurrent(), imageData);
            imageRegistry.put(extension, image);
        } else {
            image = iconFile;
        }
        return image;
    }

    public static Image awtImageIconToSWTImage(Icon icon, org.eclipse.swt.graphics.Color backgroundColor) {
        ImageIcon i = (ImageIcon)icon;
        Color backColor = null;
        if (backgroundColor != null) {
            backColor = ImageUtils.swtColorToAWTColor(backgroundColor);
        } else {
            if (whiteBackground == null) {
                whiteBackground = ImageUtils.swtColorToAWTColor(new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), 255, 255, 255));
            }
            backColor = whiteBackground;
        }
        BufferedImage bi = new BufferedImage(i.getIconWidth(), i.getIconHeight(), 1);
        Graphics2D imageGraphics = bi.createGraphics();
        imageGraphics.drawImage(i.getImage(), 0, 0, backColor, null);
        ImageData data = ImageUtils.awtBufferedImageToSWTImageData(bi);
        try {
            Image image = new Image((Device)Display.getCurrent(), data);
            return image;
        }
        finally {
            imageGraphics.dispose();
        }
    }

    public static Color swtColorToAWTColor(org.eclipse.swt.graphics.Color background) {
        return new Color(background.getRed(), background.getGreen(), background.getBlue());
    }

    public static ImageData awtBufferedImageToSWTImageData(BufferedImage bufferedImage) {
        if (bufferedImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel colorModel = (DirectColorModel)bufferedImage.getColorModel();
            PaletteData palette = new PaletteData(colorModel.getRedMask(), colorModel.getGreenMask(), colorModel.getBlueMask());
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[3];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    int pixel = palette.getPixel(new RGB(pixelArray[0], pixelArray[1], pixelArray[2]));
                    data.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
            int size = colorModel.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            colorModel.getReds(reds);
            colorModel.getGreens(greens);
            colorModel.getBlues(blues);
            RGB[] rgbs = new RGB[size];
            int i = 0;
            while (i < rgbs.length) {
                rgbs[i] = new RGB(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                ++i;
            }
            PaletteData palette = new PaletteData(rgbs);
            ImageData data = new ImageData(bufferedImage.getWidth(), bufferedImage.getHeight(), colorModel.getPixelSize(), palette);
            data.transparentPixel = colorModel.getTransparentPixel();
            WritableRaster raster = bufferedImage.getRaster();
            int[] pixelArray = new int[1];
            int y = 0;
            while (y < data.height) {
                int x = 0;
                while (x < data.width) {
                    raster.getPixel(x, y, pixelArray);
                    data.setPixel(x, y, pixelArray[0]);
                    ++x;
                }
                ++y;
            }
            return data;
        }
        return null;
    }

    private static List<String> getImageCacheNames(Connection conn) {
        AptanaDB db = AptanaDB.getInstance();
        final ArrayList<String> list = new ArrayList<String>();
        db.execute("select name FROM CACHE", new IResultSetHandler(){

            public void processResultSet(ResultSet resultSet) throws SQLException {
                String name = resultSet.getString(1);
                list.add(name);
            }
        });
        return list;
    }

    public static int loadImageCache(Display display) {
        int result = -1;
        if (!imageCacheLoaded) {
            block4: {
                imageCacheLoaded = true;
                try {
                    if (!ImageUtils.checkTable()) {
                        ImageUtils.createTable();
                    }
                }
                catch (SQLException e) {
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.ImageUtils_ErrorInitializingDbConnection, (Throwable)e);
                    if (e.getNextException() == null) break block4;
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.ImageUtils_ErrorInitializingDbConnection, (Throwable)e.getNextException());
                }
            }
            AptanaDB db = AptanaDB.getInstance();
            final class Handler
            implements IResultSetHandler {
                public int count = 0;
                private final /* synthetic */ Display val$display;

                Handler(Display display) {
                    this.val$display = display;
                }

                public void processResultSet(ResultSet resultSet) throws SQLException {
                    String name = resultSet.getString(1);
                    byte[] data = resultSet.getBytes(2);
                    ImageLoader loader = new ImageLoader();
                    ByteArrayInputStream in = new ByteArrayInputStream(data);
                    loader.load((InputStream)in);
                    fileIconsHash.put(name, new Image((Device)this.val$display, loader.data[0]));
                    ++this.count;
                }
            }
            Handler handler = new Handler(display);
            db.execute("SELECT * FROM CACHE", (IResultSetHandler)handler);
            result = handler.count;
        }
        return result;
    }

    public static int saveImageCache() {
        Connection conn = AptanaDB.getInstance().getConnection();
        int numRows = 0;
        if (conn != null) {
            List<String> currentList = ImageUtils.getImageCacheNames(conn);
            Iterator<String> keys = fileIconsHash.keySet().iterator();
            String sql = "insert into CACHE (name, image, filesize) values (?,?,?)";
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while (keys.hasNext()) {
                String name = keys.next();
                if (!currentList.contains(name)) {
                    Image image = fileIconsHash.get(name);
                    try {
                        ImageLoader saver = new ImageLoader();
                        saver.data = new ImageData[]{image.getImageData()};
                        saver.save((OutputStream)out, 0);
                        byte[] imageBytes = out.toByteArray();
                        PreparedStatement prepStmt = conn.prepareStatement(sql);
                        prepStmt.setString(1, name);
                        prepStmt.setBytes(2, imageBytes);
                        prepStmt.setInt(3, imageBytes.length);
                        numRows += prepStmt.executeUpdate();
                        prepStmt.close();
                    }
                    catch (SQLException e) {
                        IdeLog.logInfo((Plugin)CoreUIPlugin.getDefault(), (String)Messages.ImageUtils_ErrorSavingIconImageCache, (Throwable)e);
                    }
                }
                out.reset();
            }
        }
        return numRows;
    }

    private static void createTable() {
        AptanaDB db = AptanaDB.getInstance();
        db.execute("CREATE TABLE CACHE (name varchar(255) PRIMARY KEY,image BLOB(25000),filesize int)");
    }

    private static boolean checkTable() throws SQLException {
        boolean result;
        block12: {
            Connection conn = null;
            Statement s = null;
            result = true;
            try {
                try {
                    conn = AptanaDB.getInstance().getConnection();
                    if (conn != null) {
                        s = conn.createStatement();
                        s.execute("select name FROM CACHE where name='test'");
                        break block12;
                    }
                    IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.ImageUtils_NoConnection);
                    result = false;
                }
                catch (SQLException sqle) {
                    String theError = sqle.getSQLState();
                    if (!theError.equals("42X05")) {
                        if (theError.equals("42X14") || theError.equals("42821")) {
                            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.ImageUtils_IncorrectTableDefinition);
                            throw sqle;
                        }
                        IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.ImageUtils_SQLException);
                        throw sqle;
                    }
                    result = false;
                    if (s != null) {
                        s.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            finally {
                if (s != null) {
                    s.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        return result;
    }
}

