/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.ping;

import com.aptana.ide.core.AptanaCorePlugin;
import com.aptana.ide.core.DateUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.db.EventInfo;
import com.aptana.ide.core.db.EventLogger;
import com.aptana.ide.core.db.FeatureInfo;
import com.aptana.ide.core.db.FeatureTracker;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.WorkbenchHelper;
import com.aptana.ide.core.ui.ping.Messages;
import com.aptana.ide.core.ui.preferences.ApplicationPreferences;
import com.aptana.ide.update.FeatureUtil;
import com.aptana.ide.update.manager.IPlugin;
import com.eaio.uuid.MACAddress;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.ui.IStartup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingStartup
implements IStartup {
    private static final String FEATURE_IU_SUFFIX = ".feature.group";
    private static final String INSTALL_URL = "http://ping.aptana.com/welcome.php";
    private static final String UPDATE_URL = "https://ping.aptana.com/ping.php";
    private static final int READ_TIMEOUT = 900000;
    private static final long TWENTY_FOUR_HOURS = 86400000L;
    private static boolean ranOnce = false;

    private static void addFeatureList() {
        HashSet<FeatureInfo> featureList = new HashSet<FeatureInfo>();
        List installed = FeatureUtil.getInstalledFeatures();
        for (IPlugin iu : installed) {
            featureList.add(new FeatureInfo(PingStartup.stripFeatureNameToBaseID(iu.getId()), iu.getVersion(), true));
        }
        FeatureInfo[] features = featureList.toArray(new FeatureInfo[featureList.size()]);
        if (!PingStartup.featuresMatch(features)) {
            FeatureTracker tracker = FeatureTracker.getInstance();
            tracker.clearFeatures();
            EventLogger logger = EventLogger.getInstance();
            for (FeatureInfo feature : featureList) {
                logger.logEvent("FEATURE", feature.toString());
                tracker.addFeature(feature);
            }
        }
    }

    private static void addKeyPair(List<String> keyValues, String key, String value) {
        if (value == null) {
            value = "";
        }
        keyValues.add(StringUtils.urlEncodeKeyValuePair((String)key, (String)value));
    }

    private static boolean featuresMatch(FeatureInfo[] currentFeatures) {
        boolean result;
        Object[] savedFeatures = FeatureTracker.getInstance().getFeatures();
        boolean bl = result = currentFeatures.length == savedFeatures.length;
        if (result) {
            Arrays.sort(savedFeatures);
            Arrays.sort(currentFeatures);
            int i = 0;
            while (i < savedFeatures.length) {
                if (!savedFeatures[i].equals((Object)currentFeatures[i])) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    private static String getApplicationId(ApplicationPreferences preferences) {
        String applicationId = preferences.getString("ide-id");
        String workspaceId = PingStartup.getWorkspaceId();
        String previousId = null;
        if (applicationId == null || applicationId.length() == 0) {
            if (workspaceId == null || workspaceId.length() == 0) {
                Map<String, String> previousPreferences = preferences.loadPreviousPreferences();
                previousId = previousPreferences.get("ide-id");
                applicationId = previousId != null ? previousId : UUID.randomUUID().toString();
                preferences.setString("ide-id", applicationId);
                preferences.setBoolean("ide-has-run", true);
                preferences.savePreferences();
            } else {
                applicationId = workspaceId;
                preferences.setString("ide-id", applicationId);
                preferences.savePreferences();
            }
        } else if (workspaceId != null && workspaceId.length() > 0 && !workspaceId.equals(applicationId)) {
            applicationId = workspaceId;
        }
        return applicationId;
    }

    private static String getUserAgent() {
        return "Aptana/1.5";
    }

    private static String getWorkspaceId() {
        IPreferencesService preferencesService = Platform.getPreferencesService();
        String result = "";
        if (preferencesService != null) {
            result = preferencesService.getString(CoreUIPlugin.getPluginId(), "ide-id", "", null);
        }
        return result;
    }

    private static boolean sendUpdate(ApplicationPreferences preferences, String queryString) {
        URL url = null;
        boolean result = false;
        try {
            String line;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            gos.write(queryString.getBytes());
            gos.flush();
            gos.finish();
            gos.close();
            baos.close();
            byte[] gzippedData = baos.toByteArray();
            url = new URL(UPDATE_URL);
            URLConnection connection = url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Encoding", "gzip");
            connection.setRequestProperty("Content-Length", String.valueOf(gzippedData.length));
            connection.setRequestProperty("User-Agent", PingStartup.getUserAgent());
            connection.setReadTimeout(900000);
            DataOutputStream output = new DataOutputStream(connection.getOutputStream());
            output.write(gzippedData);
            output.flush();
            BufferedReader input = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer sb = new StringBuffer();
            while ((line = input.readLine()) != null) {
                sb.append(line);
            }
            output.close();
            input.close();
            result = true;
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.SchedulerStartup_UrlIsMalformed, url), (Throwable)e);
        }
        catch (IOException iOException) {
            boolean hasRun = preferences.getBoolean("ide-has-run");
            if (!hasRun) {
                WorkbenchHelper.launchBrowser("http://ping.aptana.com/welcome.php?" + queryString);
                preferences.setBoolean("ide-has-run", true);
                preferences.savePreferences();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.SchedulerStartup_UnableToContactUpdateServer, (Throwable)e);
        }
        return result;
    }

    private static String stripFeatureNameToBaseID(String name) {
        if (name == null || !name.endsWith(FEATURE_IU_SUFFIX)) {
            return name;
        }
        return name.substring(0, name.length() - FEATURE_IU_SUFFIX.length());
    }

    private static void updateAnonymousId() {
        EventInfo[] events;
        String queryString = null;
        ArrayList<String> keyValues = new ArrayList<String>();
        ApplicationPreferences preferences = ApplicationPreferences.getInstance();
        preferences.loadPreferences();
        if (!preferences.getBoolean("ide-has-run")) {
            PingStartup.addKeyPair(keyValues, "first_run", Long.toString(System.currentTimeMillis()));
        }
        PingStartup.addKeyPair(keyValues, "id", PingStartup.getApplicationId(preferences));
        PingStartup.addKeyPair(keyValues, "version", PluginUtils.getPluginVersion((Plugin)AptanaCorePlugin.getDefault()));
        PingStartup.addKeyPair(keyValues, "product", System.getProperty("eclipse.product"));
        PingStartup.addKeyPair(keyValues, "eclipse_version", System.getProperty("osgi.framework.version"));
        PingStartup.addKeyPair(keyValues, "os_architecture", System.getProperty("os.arch"));
        PingStartup.addKeyPair(keyValues, "os_name", System.getProperty("os.name"));
        PingStartup.addKeyPair(keyValues, "os_version", System.getProperty("os.version"));
        PingStartup.addKeyPair(keyValues, "STUDIO_KEY", MACAddress.getMACAddress());
        PingStartup.addFeatureList();
        EventLogger.getInstance().logEvent("DATE_TIME");
        EventInfo[] eventInfoArray = events = EventLogger.getInstance().getEvents();
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            EventInfo event = eventInfoArray[n2];
            if (!event.getEventType().equals("PREVIEW")) {
                String key = String.valueOf(event.getEventType()) + "[]";
                String value = String.valueOf(Long.toString(event.getDateTime())) + ":" + event.getMessage();
                PingStartup.addKeyPair(keyValues, key, value);
            }
            ++n2;
        }
        queryString = StringUtils.join((String)"&", (String[])keyValues.toArray(new String[keyValues.size()]));
        if (PingStartup.sendUpdate(preferences, queryString)) {
            EventLogger.getInstance().clearEvents();
        } else {
            long fourWeeksAgo = DateUtils.addDayInterval((long)System.currentTimeMillis(), (int)-28);
            EventLogger.getInstance().clearEvents(fourWeeksAgo);
        }
    }

    public void earlyStartup() {
        if (Platform.inDevelopmentMode()) {
            return;
        }
        Job job = new Job("Sending Ping..."){

            protected IStatus run(IProgressMonitor monitor) {
                PingStartup.updateAnonymousId();
                if (!ranOnce) {
                    ranOnce = true;
                }
                this.schedule(86400000L);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(40);
        job.schedule();
    }
}

