/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.reporting.doms;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.intro.browser.CoreBrowserEditorInput;
import com.aptana.ide.reporting.Activator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;

public class Report {
    private static final String NAVIGATOR_ID = "com.aptana.ide.ui.io.fileExplorerView";

    public String getSelectedProject() {
        IProject project = Report.getSelectedNavigatorProject();
        return project == null ? null : project.getName();
    }

    public String getSelectedProjectPath() {
        IProject project = Report.getSelectedNavigatorProject();
        return project == null ? null : project.getLocation().toPortableString();
    }

    public String getTemplate(String name) {
        File file;
        block4: {
            file = null;
            URL url = Platform.getBundle((String)"com.aptana.ide.reporting").getEntry(name);
            try {
                if (url != null) {
                    URL fileURL = FileLocator.toFileURL((URL)url);
                    file = new File(fileURL.getPath());
                    break block4;
                }
                file = new File(name);
                if (file.exists()) break block4;
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        String s = FileUtils.readContent((File)file);
        return s;
    }

    public void createReportView(String contents, String reportType, String projectName) {
        String newFileName = FileUtils.getRandomFileName((String)"_report", (String)"html");
        File newFile = new File(String.valueOf(FileUtils.systemTempDir) + File.separator + newFileName);
        String saveAsFile = String.valueOf(projectName) + "_" + reportType + "_" + "Report.html";
        try {
            FileWriter fw = new FileWriter(newFile);
            fw.write(contents);
            fw.close();
            URL url = newFile.toURI().toURL();
            if (url != null) {
                IWorkbenchPage page;
                CoreBrowserEditorInput input = new CoreBrowserEditorInput(url);
                input.setImage(Activator.getImageDescriptor("icons/view_detailed.png"));
                input.setSaveAsAllowed(true);
                input.setSaveAsFile(newFile);
                input.setSaveAsFileName(saveAsFile);
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    page.openEditor((IEditorInput)input, "com.aptana.ide.intro.browserEditor");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static IProject getSelectedNavigatorProject() {
        Tree projectTree;
        TreeItem[] selection;
        IWorkbenchPart[] views = CoreUIUtils.getViewsInternal((String)NAVIGATOR_ID);
        if (views != null && views.length == 1 && views[0] instanceof CommonNavigator && (selection = (projectTree = ((CommonNavigator)views[0]).getCommonViewer().getTree()).getSelection()) != null && selection.length > 0) {
            Object data = selection[0].getData();
            if (data instanceof IProject) {
                return (IProject)data;
            }
            if (data instanceof IResource) {
                return ((IResource)data).getProject();
            }
        }
        return null;
    }
}

