/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.coloring;

import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.ITokenList;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.LoggingPreferences;
import com.aptana.ide.logging.coloring.LoggingLexerFactory;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenTypes {
    public static final String LANGUAGE = "text/log";
    public static final String START_GROUP_NAME = "default";
    public static final String ERROR = "SYSTEM_ERROR_LEXEME";
    public static String WHITESPACE = "SYSTE_WHITESPACE_LEXEME";
    public static String DEFAULT_CATEGORY = "DEFAULT";
    private static int SYS_TOKENS_NUM = 1;
    static String UNKNOWN = "<unknown>";
    static String SYSTEM = "SYSTEM";
    private static LoggingLexerFactory lexerFactory;

    protected TokenTypes() {
    }

    public static String[] getNames() {
        List<LoggingPreferences.Rule> rules = LoggingPlugin.getDefault().getLoggingPreferences().getRules();
        String[] result = new String[rules.size() + SYS_TOKENS_NUM];
        result[0] = ERROR;
        result[1] = WHITESPACE;
        int i = 0;
        while (i < rules.size()) {
            result[i + TokenTypes.SYS_TOKENS_NUM] = rules.get(i).getName();
            ++i;
        }
        return result;
    }

    public static String getName(int type) {
        if (type < SYS_TOKENS_NUM) {
            switch (type) {
                case 0: {
                    return ERROR;
                }
                case 1: {
                    return WHITESPACE;
                }
            }
            return UNKNOWN;
        }
        List<LoggingPreferences.Rule> rules = LoggingPlugin.getDefault().getLoggingPreferences().getRules();
        if (type - SYS_TOKENS_NUM >= rules.size()) {
            return UNKNOWN;
        }
        return rules.get(type - SYS_TOKENS_NUM).getName();
    }

    public static int getIntValue(String name) {
        if (ERROR.equals(name)) {
            return 0;
        }
        if (WHITESPACE.equals(name)) {
            return 1;
        }
        List<LoggingPreferences.Rule> rules = LoggingPlugin.getDefault().getLoggingPreferences().getRules();
        int i = 0;
        while (i < rules.size()) {
            LoggingPreferences.Rule rule = rules.get(i);
            if (rule.getName().equals(name)) {
                return i + SYS_TOKENS_NUM;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isRegexpType(String type) {
        int typeIndex = TokenTypes.getIntValue(type);
        return typeIndex >= SYS_TOKENS_NUM;
    }

    public static LoggingLexerFactory getLexerFactory() {
        if (lexerFactory == null) {
            lexerFactory = new LoggingLexerFactory();
        }
        return lexerFactory;
    }

    public static ITokenList getTokenList() {
        return TokenTypes.getLexerFactory().getLexer().getTokenList(LANGUAGE);
    }

    public static List<IToken> getRegexpTokenList() {
        ITokenList lst = TokenTypes.getLexerFactory().getLexer().getTokenList(LANGUAGE);
        ArrayList<IToken> result = new ArrayList<IToken>();
        int i = 0;
        while (i < lst.size()) {
            IToken token = lst.get(i);
            if (!token.getCategory().equals(SYSTEM)) {
                result.add(token);
            }
            ++i;
        }
        return result;
    }
}

