/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.impl;

import com.aptana.ide.logging.ILogResource;
import com.aptana.ide.logging.ILogWatcher;
import com.aptana.ide.logging.IThreadProxy;
import com.aptana.ide.logging.impl.LogWatcherConfiguration;
import com.aptana.ide.logging.impl.LogWatcherFactory;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLogResource
implements ILogResource {
    private URI uri;
    private Map<LogWatcherConfiguration, ILogWatcher> watchers = new HashMap<LogWatcherConfiguration, ILogWatcher>();
    private Charset encoding;

    public AbstractLogResource(URI uri) {
        this.uri = uri;
    }

    public ILogWatcher getResourceWatcher(IThreadProxy threadProxy, int maxBytesPerSecond, int maxNotificationSize, int checkWait, Charset encoding, int backlogRows) {
        LogWatcherConfiguration config = new LogWatcherConfiguration(threadProxy, maxBytesPerSecond, maxNotificationSize, checkWait, encoding, backlogRows);
        ILogWatcher watcher = this.watchers.get(config);
        if (watcher != null) {
            return watcher;
        }
        watcher = LogWatcherFactory.createWatcher(this, config);
        this.watchers.put(config, watcher);
        return watcher;
    }

    public void releaseWatcher(ILogWatcher watcher) throws IllegalArgumentException {
        if (this.watchers.containsValue(watcher)) {
            throw new IllegalArgumentException("Watcher is not obtained from current resource");
        }
        Set<Map.Entry<LogWatcherConfiguration, ILogWatcher>> entrySet = this.watchers.entrySet();
        for (Map.Entry<LogWatcherConfiguration, ILogWatcher> entry : entrySet) {
            if (!entry.getValue().equals(watcher)) continue;
            this.watchers.remove(entry.getKey());
            break;
        }
    }

    public URI getURI() {
        return this.uri;
    }

    public void close() throws IOException {
        Collection<ILogWatcher> values = this.watchers.values();
        for (ILogWatcher watcher : values) {
            watcher.close();
        }
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

