/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.impl;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.logging.ILogResource;
import com.aptana.ide.logging.ILogResourceListener;
import com.aptana.ide.logging.ILogTailListener;
import com.aptana.ide.logging.ILogWatcher;
import com.aptana.ide.logging.IThreadProxy;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.impl.LogWatcherConfiguration;
import com.aptana.ide.logging.impl.Messages;
import java.io.IOException;
import java.util.HashSet;
import org.eclipse.core.runtime.Plugin;

public abstract class AbstractLogWatcher
implements ILogWatcher,
Runnable {
    private static final int TIMEOUT = 1000;
    private final IThreadProxy threadProxy;
    private final HashSet<ILogTailListener> tailListeners = new HashSet();
    private final HashSet<ILogResourceListener> resourceListeners = new HashSet();
    private final LogWatcherConfiguration configuration;
    private final long checkWait;
    private volatile boolean checkData;
    private Thread thread;
    private final ILogResource resource;
    private boolean _notifyListeners = true;

    public AbstractLogWatcher(LogWatcherConfiguration config, ILogResource resource) {
        this.threadProxy = config.getThreadProxy();
        this.checkWait = config.getCheckWait();
        this.configuration = config;
        this.resource = resource;
    }

    public final void registerListener(ILogTailListener listener) {
        this.tailListeners.add(listener);
    }

    public final void removeListener(ILogTailListener listener) {
        this.tailListeners.remove(listener);
    }

    public final void registerListener(ILogResourceListener listener) {
        this.resourceListeners.add(listener);
    }

    public final void removeListener(ILogResourceListener listener) {
        this.resourceListeners.remove(listener);
    }

    public final void startWatching() {
        if (this.thread != null && this.thread.isAlive()) {
            this.checkData = true;
            return;
        }
        this.checkData = true;
        this.thread = new Thread((Runnable)this, String.valueOf(this.resource.getURI().toString()) + " watching thread");
        this.thread.start();
    }

    public final void stopWatching() {
        this.checkData = false;
    }

    public final void synchronizedStopWatching() {
        this.checkData = false;
        if (this.thread == null || !this.thread.isAlive()) {
            return;
        }
        try {
            this.thread.join(0L);
        }
        catch (InterruptedException e) {
            IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)Messages.AbstractLogWatcher_ERR_Exception, (Throwable)e);
        }
    }

    public final void run() {
        while (true) {
            try {
                if (!this.checkData) break;
                DataChange change = this.getData();
                if (change == null) {
                    try {
                        Thread.sleep(this.checkWait);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                String toSend = change.getData();
                this.notifyListeners(toSend, change.getGlobalOffset(), change.getGlobalLength());
                this.notifyListenersResourceAvailable(true);
                try {
                    Thread.sleep(this.checkWait);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            catch (Throwable th) {
                this.notifyListeners(th);
                this.stopWatching();
                break;
            }
        }
    }

    protected void notifyListeners(final String data, final long globalOffset, final long globalLength) {
        if (this._notifyListeners) {
            this.threadProxy.run(new Runnable(){

                public void run() {
                    for (ILogTailListener listener : AbstractLogWatcher.this.tailListeners) {
                        listener.dataAvailable(data, globalOffset, globalLength);
                    }
                }
            });
        }
    }

    protected void notifyListeners(final Throwable error) {
        if (this._notifyListeners) {
            this.threadProxy.run(new Runnable(){

                public void run() {
                    for (ILogTailListener listener : AbstractLogWatcher.this.tailListeners) {
                        listener.errorHappened(error);
                    }
                }
            });
        }
    }

    protected void setNotifyListeners(boolean notify) {
        this._notifyListeners = notify;
    }

    protected void notifyListenersResourceAvailable(final boolean available) {
        this.threadProxy.run(new Runnable(){

            public void run() {
                for (ILogResourceListener listener : AbstractLogWatcher.this.resourceListeners) {
                    listener.resourceAvailable(available);
                }
            }
        });
    }

    protected LogWatcherConfiguration getConfiguration() {
        return this.configuration;
    }

    public void close() {
        this.stopWatching();
        this.tailListeners.clear();
        this.resourceListeners.clear();
    }

    public boolean isWatching() {
        return this.thread != null && this.thread.isAlive();
    }

    public boolean watchingStatus() {
        return this.checkData;
    }

    public ILogResource getResource() {
        return this.resource;
    }

    protected abstract DataChange getData() throws IOException;

    protected static class DataChange {
        private String data;
        private long globalLength;
        private long globalOffset;

        public DataChange(String data, int globalOffset, int globalLength) {
            this.data = data;
            this.globalLength = globalLength;
            this.globalOffset = globalOffset;
        }

        public String getData() {
            return this.data;
        }

        public long getGlobalOffset() {
            return this.globalOffset;
        }

        public long getGlobalLength() {
            return this.globalLength;
        }
    }
}

