/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.preferences;

import com.aptana.ide.editors.unified.colorizer.ColorizerWriter;
import com.aptana.ide.editors.unified.colorizer.LanguageColorizer;
import com.aptana.ide.logging.LoggingPreferences;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingColorizerWriter
extends ColorizerWriter {
    private List<LoggingPreferences.Rule> rules;

    public LoggingColorizerWriter(List<LoggingPreferences.Rule> rules) {
        this.rules = rules;
    }

    protected Document buildDom(LanguageColorizer lc, String language) throws ParserConfigurationException {
        Document document = super.buildDom(lc, language);
        NodeList colorizersList = document.getElementsByTagName("colorizer");
        if (colorizersList == null || colorizersList.getLength() != 1) {
            throw new IllegalArgumentException("Serialized colorization may only have a single colorizer");
        }
        Node colorizerElement = colorizersList.item(0);
        Element metadataElement = document.createElement("metadata");
        colorizerElement.appendChild(metadataElement);
        for (LoggingPreferences.Rule rule : this.rules) {
            Element ruleElement = rule.isRegexp() ? document.createElement("regex") : document.createElement("string");
            metadataElement.appendChild(ruleElement);
            ruleElement.setAttribute("name", rule.getName());
            ruleElement.setAttribute("value", rule.getRule());
            ruleElement.setAttribute("caseInsensitive", Boolean.toString(rule.isCaseInsensitive()));
        }
        return document;
    }
}

