/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.preferences;

import com.aptana.ide.core.ui.contentassist.ContentAssistHandler;
import com.aptana.ide.core.ui.contentassist.LoggingRegExContentAssistProcessor;
import com.aptana.ide.logging.LoggingPreferences;
import com.aptana.ide.logging.preferences.Messages;
import java.util.List;
import org.eclipse.jface.contentassist.SubjectControlContentAssistant;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewRuleDialog
extends TitleAreaDialog {
    private static final String ADD_REGEXP_RULE_CONTEXT = "com.aptana.ide.logging.loggingview_add_simple_rule_context";
    private static final String SIMPLE_RULE_ITEM = Messages.NewRuleDialog_6;
    private static final String REGEXP_RULE_ITEM = Messages.NewRuleDialog_7;
    private final boolean newRuleMode;
    private Text nameEdit;
    private Text contentEdit;
    private String name;
    private String content;
    private boolean isRegexp = false;
    private boolean isCaseInsensitive = false;
    private ContentAssistHandler fContentAssistHandler;
    private Combo ruleTypeCombo;
    private List<String> forbiddenNames = null;

    public NewRuleDialog(Shell parentShell, LoggingPreferences.Rule initialContent) {
        super(parentShell);
        if (initialContent != null) {
            this.newRuleMode = false;
            this.name = initialContent.getName();
            this.isRegexp = initialContent.isRegexp();
            this.isCaseInsensitive = initialContent.isCaseInsensitive();
            this.content = initialContent.getRule();
        } else {
            this.newRuleMode = true;
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validate();
    }

    public NewRuleDialog(String initialContent, Shell parentShell) {
        super(parentShell);
        if (!this.hasIgnorableCharacters(initialContent)) {
            this.content = initialContent;
        } else {
            this.content = this.replaceIgnorableCharacters(initialContent);
            this.isRegexp = true;
        }
        this.newRuleMode = true;
    }

    public String getName() {
        return this.name;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isRegexp() {
        return this.isRegexp;
    }

    public boolean isCaseInsensitive() {
        return this.isCaseInsensitive;
    }

    public void setForbiddenNames(List<String> names) {
        this.forbiddenNames = names;
    }

    protected void okPressed() {
        if (this.nameEdit != null) {
            this.name = this.nameEdit.getText();
        }
        this.content = this.contentEdit.getText();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite returned = (Composite)super.createDialogArea(parent);
        Composite par = new Composite(returned, 0);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 200;
        par.setLayoutData((Object)data);
        if (this.newRuleMode) {
            this.getShell().setText(Messages.NewRuleDialog_0);
            this.setTitle(Messages.NewRuleDialog_0);
            this.setMessage(Messages.NewRuleDialog_Rule_Message);
        } else {
            this.getShell().setText(Messages.EditRuleDialog_0);
            this.setTitle(Messages.EditRuleDialog_0);
            this.setMessage(Messages.EditRuleDialog_1);
        }
        par.setLayout((Layout)new GridLayout(4, false));
        if (this.newRuleMode) {
            this.createNameEdit(par);
        }
        this.createContentEdit(par);
        this.createCaseSensetiveEdit(par);
        this.createRuleTypeEdit(par);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)par, ADD_REGEXP_RULE_CONTEXT);
        this.setTooltipText();
        return par;
    }

    private void createRuleTypeEdit(Composite par) {
        Label ruleTypeLabel = new Label(par, 0);
        ruleTypeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        ruleTypeLabel.setText(Messages.NewRuleDialog_8);
        this.ruleTypeCombo = new Combo(par, 8);
        this.ruleTypeCombo.setItems(new String[]{SIMPLE_RULE_ITEM, REGEXP_RULE_ITEM});
        if (this.isRegexp) {
            this.ruleTypeCombo.select(1);
        } else {
            this.ruleTypeCombo.select(0);
        }
        this.ruleTypeCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        this.createContentAssistant();
        this.fContentAssistHandler.setEnabled(this.isRegexp);
        this.ruleTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (NewRuleDialog.this.ruleTypeCombo.getSelectionIndex() == 1) {
                    NewRuleDialog.this.fContentAssistHandler.setEnabled(true);
                    NewRuleDialog.this.contentEdit.setToolTipText(Messages.NewRuleDialog_TTP_RegularExpression);
                    NewRuleDialog.this.isRegexp = true;
                } else {
                    NewRuleDialog.this.fContentAssistHandler.setEnabled(false);
                    NewRuleDialog.this.contentEdit.setToolTipText(Messages.NewRuleDialog_TTP_Search);
                    NewRuleDialog.this.isRegexp = false;
                }
                NewRuleDialog.this.setTooltipText();
            }
        });
    }

    private void createCaseSensetiveEdit(Composite par) {
        Label caseSensetiveLabel = new Label(par, 0);
        caseSensetiveLabel.setText(String.valueOf(Messages.CaseSensitiveLabel) + ":");
        caseSensetiveLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        final Button caseSensitiveBox = new Button(par, 32);
        caseSensitiveBox.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        if (!this.newRuleMode) {
            caseSensitiveBox.setSelection(this.isCaseInsensitive);
        }
        caseSensitiveBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewRuleDialog.this.isCaseInsensitive = caseSensitiveBox.getSelection();
            }
        });
    }

    private void createContentEdit(Composite par) {
        Label contentLabel = new Label(par, 0);
        contentLabel.setText(String.valueOf(Messages.NewRuleDialog_4) + ":");
        contentLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.contentEdit = new Text(par, 2048);
        this.contentEdit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.content != null) {
            this.contentEdit.setText(this.content);
        }
        this.contentEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewRuleDialog.this.validate();
            }
        });
    }

    private void createNameEdit(Composite par) {
        Label nameLabel = new Label(par, 0);
        nameLabel.setText(String.valueOf(Messages.NewRuleDialog_2) + ":");
        nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.nameEdit = new Text(par, 2048);
        this.nameEdit.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.nameEdit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewRuleDialog.this.validate();
            }
        });
        if (this.name != null) {
            this.nameEdit.setText(this.name);
        }
    }

    protected void setTooltipText() {
        if (this.ruleTypeCombo.getSelectionIndex() == 1) {
            this.contentEdit.setToolTipText(Messages.NewRuleDialog_TTP_RegularExpression);
        } else {
            this.contentEdit.setToolTipText(Messages.NewRuleDialog_TTP_Search);
        }
    }

    private void validate() {
        String contentText = this.contentEdit.getText();
        if (this.hasIgnorableCharacters(contentText)) {
            this.contentEdit.setText(this.replaceIgnorableCharacters(contentText));
            this.setRegexpBased(true);
        }
        if (this.newRuleMode) {
            String nameText = this.nameEdit.getText();
            if (nameText.length() == 0) {
                this.disableOKButton();
                this.setErrorMessage(Messages.NewRuleDialog_RuleError_Name);
                return;
            }
            String trimmedName = nameText.trim();
            if (this.forbiddenNames != null && this.forbiddenNames.contains(trimmedName)) {
                this.disableOKButton();
                this.setErrorMessage(Messages.NewRuleDialog_RuleError_Name_AlreadyExists);
                return;
            }
        }
        if (contentText.length() == 0) {
            this.setErrorMessage(Messages.NewRuleDialog_RuleError_RegexpRule_Content);
            this.disableOKButton();
            return;
        }
        this.setErrorMessage(null);
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(true);
        }
    }

    private void disableOKButton() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(false);
        }
    }

    private void createContentAssistant() {
        this.fContentAssistHandler = ContentAssistHandler.createHandlerForText((Text)this.contentEdit, (SubjectControlContentAssistant)LoggingRegExContentAssistProcessor.createContentAssistant());
    }

    private String replaceIgnorableCharacters(String str) {
        StringBuilder builder = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (Character.isIdentifierIgnorable(ch)) {
                builder.append('.');
            } else {
                builder.append(ch);
            }
            ++i;
        }
        return builder.toString();
    }

    private boolean hasIgnorableCharacters(String str) {
        int i = 0;
        while (i < str.length()) {
            if (Character.isIdentifierIgnorable(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setRegexpBased(boolean isRegexp) {
        this.isRegexp = isRegexp;
        this.fContentAssistHandler.setEnabled(isRegexp);
        if (isRegexp) {
            this.ruleTypeCombo.select(1);
        } else {
            this.ruleTypeCombo.select(0);
        }
    }
}

