/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.view;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.resources.IUniformResource;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.editors.unified.UniformResourceMarkerAnnotationModel;
import com.aptana.ide.lexer.ILexer;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.logging.ILogResource;
import com.aptana.ide.logging.ILogResourceListener;
import com.aptana.ide.logging.ILogTailListener;
import com.aptana.ide.logging.ILogWatcher;
import com.aptana.ide.logging.LogResourceFactory;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.LoggingPreferences;
import com.aptana.ide.logging.Messages;
import com.aptana.ide.logging.coloring.LoggingColorizer;
import com.aptana.ide.logging.coloring.LoggingLexemeManager;
import com.aptana.ide.logging.coloring.TokenTypes;
import com.aptana.ide.logging.impl.DisplayThreadProxy;
import com.aptana.ide.logging.preferences.ILoggingPreferenceListener;
import com.aptana.ide.logging.view.LogView;
import com.aptana.ide.logging.view.LoggingMarkerRulerAction;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

class LogTab {
    private static final String DEFAULT_ENCODING = "cp1251";
    private static final int MAX_NOTIFICATION_SIZE = 1024;
    private static final String BOOKMARK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.bookmark";
    private static final String DEFAULT_FONT = "DEFAULT_TAIL_VIEW_FONT";
    private static final String PREFIX = "LogTab";
    private static final String BOOKMARK_PREFIX = "LogTab.BookmarkAction";
    protected static final int VERTICAL_RULER_WIDTH = 12;
    protected int _maxColorizingColumns = 512;
    private final LogView logView;
    private final URI uri;
    private CTabItem item;
    private IVerticalRuler ruler;
    private long currentGlobalOffset = 0L;
    private Set contentDependentActions = new HashSet();
    private ILogWatcher watcher;
    private ILogResource resource = null;
    private MenuManager menuMgr;
    private FontRegistry fontRegistry = new FontRegistry();
    private ColorRegistry colorRegistry = new ColorRegistry();
    private SourceViewer viewer;
    private Font boldFont;
    private Font normalFont;
    private Font italicFont;
    private Color textForeground;
    private volatile boolean unreadDataAvailable;
    private volatile boolean resourceAvailable;
    private LoggingMarkerRulerAction actionAddBookmark;
    private UniformResourceMarkerAnnotationModel model;
    private IOverviewRuler overviewRuler;
    private MarkerAnnotationPreferences fAnnotationPreferences;
    private Color bookmarkColor = new Color((Device)Display.getCurrent(), 0, 0, 255);
    private LineStyleListener _lineStyleListener;
    private LoggingColorizer _colorizer;
    private TextChangeListener _textChangeListener;
    private ILexer lexer;
    private boolean followTail = true;
    private IDocument document;
    private IPropertyChangeListener colorizationPreferencesListener;
    private ILoggingPreferenceListener loggingPreferenceListener;
    private ILogTailListener tailListener;
    protected SourceViewerDecorationSupport decorationSupport;
    protected LoggingLexemeManager lexememanager;
    private Composite composite;
    private boolean supportsErase;

    public LogTab(LogView logView, URI uri, String name, boolean supportsErase) {
        this.logView = logView;
        this.uri = uri;
        this.supportsErase = supportsErase;
        String tabName = name;
        if (tabName == null) {
            tabName = this.getTabName(uri.getPath());
        }
        this.fAnnotationPreferences = EditorsPlugin.getDefault().getMarkerAnnotationPreferences();
        this.item = this.createLogTabItem(tabName, uri);
        this.createColorizer();
        try {
            this.resource = LogResourceFactory.createResource(uri);
            this.resource.setEncoding(Charset.forName(LoggingPlugin.getDefault().getLoggingPreferences().getDefaultEncoding()));
        }
        catch (IOException e) {
            e.printStackTrace(new PrintWriter(new DocumentWriter(this.getDocument())));
            return;
        }
        this.initAnnotationModel();
        this.createActions();
        this.hookRulerContextMenu();
        this.initializeFonts();
        this.initializeColors();
        this.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
            }
        });
        LoggingPreferences preferences = LoggingPlugin.getDefault().getLoggingPreferences();
        int timeout = preferences.getReadTimeout();
        int readBuffer = preferences.getReadBuffer();
        int maxBytesPerSecond = (int)((long)readBuffer * 1000L / (long)timeout);
        this.watcher = this.resource.getResourceWatcher(new DisplayThreadProxy(this.item.getDisplay()), maxBytesPerSecond, readBuffer, timeout, Charset.forName(DEFAULT_ENCODING), LoggingPlugin.getDefault().getLoggingPreferences().getBacklogLines());
        this.registerTailListener();
        this.registerResourceListener();
        this.watcher.startWatching();
        this.logView.tabFolder.setSelection(this.item);
        this.linkColorer();
    }

    public URI getURI() {
        return this.uri;
    }

    public TextViewer getViewer() {
        return this.viewer;
    }

    public String getName() {
        return this.item.getText();
    }

    public boolean supportsLogErase() {
        return this.supportsErase;
    }

    public void setName(String name) {
        this.item.setText(name);
    }

    public void close() {
        this.watcher.stopWatching();
        this.watcher.close();
        try {
            this.resource.close();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)com.aptana.ide.logging.view.Messages.LogTab_4, (Throwable)e);
        }
        this.disposeListeners();
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        if (this.italicFont != null) {
            this.italicFont.dispose();
        }
        this.bookmarkColor.dispose();
        this.item.dispose();
        if (this.decorationSupport != null) {
            this.decorationSupport.dispose();
            this.decorationSupport = null;
        }
    }

    public void start() {
        this.watcher.startWatching();
    }

    public void stop() {
        this.watcher.stopWatching();
    }

    public boolean isWatching() {
        return this.watcher.watchingStatus();
    }

    public void reload() {
        this.watcher.resetWatching();
        this.clear();
        this.watcher.startWatching();
    }

    public CTabItem getItem() {
        return this.item;
    }

    public void clear() {
        if (this.document != null) {
            this.document.set("");
        }
        this.currentGlobalOffset = 0L;
        if (this.lexememanager != null) {
            List<String> empty = Collections.emptyList();
            this.lexememanager.dataAvailable(empty);
        }
    }

    public void selected() {
        this.unreadDataAvailable = false;
        this.makeTabBold(false);
        if (!this.resourceAvailable) {
            this.makeTabShaded(true);
        }
    }

    public void clearLogFile() {
        try {
            this.resource.clear();
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)this.getItem().getControl().getShell(), (String)com.aptana.ide.logging.view.Messages.LogTab_2, (String)(String.valueOf(com.aptana.ide.logging.view.Messages.LogTab_1) + this.resource.getURI().getPath()));
        }
        this.reload();
    }

    public boolean hasUnreadData() {
        return this.unreadDataAvailable;
    }

    public void setFollowTail(boolean followTail) {
        this.followTail = followTail;
    }

    public void invertFollowTail() {
        this.followTail = !this.followTail;
    }

    String getSelection() {
        if (this.viewer == null) {
            return null;
        }
        TextSelection selection = (TextSelection)this.viewer.getSelection();
        if (selection == null) {
            return null;
        }
        try {
            return this.getDocument().get(selection.getOffset(), selection.getLength());
        }
        catch (BadLocationException ex) {
            IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)com.aptana.ide.logging.view.Messages.LogTab_ERR_Exception, (Throwable)ex);
            return null;
        }
    }

    void refreshViewer() {
        this.viewer.refresh();
    }

    private CTabItem createLogTabItem(String tabName, URI uri) {
        CTabItem item = new CTabItem(this.logView.tabFolder, -1);
        item.setText(tabName);
        if (uri != null) {
            item.setToolTipText(uri.getPath());
        }
        this.document = new Document();
        this.lexememanager = new LoggingLexemeManager(this.document, LoggingPlugin.getDefault().getLoggingPreferences());
        DefaultMarkerAnnotationAccess access = new DefaultMarkerAnnotationAccess();
        this.ruler = this.createVerticalRuler((IAnnotationAccess)access);
        this.overviewRuler = this.createOverviewRuler((IAnnotationAccess)access);
        this.createViewer(item);
        return item;
    }

    void recreateViewer() {
        this.decorationSupport.dispose();
        this.decorationSupport = null;
        this.composite.dispose();
        this.viewer = null;
        LoggingPlugin.getDefault().getLoggingPreferences().removePreferenceListener(this.loggingPreferenceListener);
        this.createViewer(this.item);
    }

    private void createViewer(CTabItem item) {
        int viewerStyle = 0;
        viewerStyle = LoggingPlugin.getDefault().getLoggingPreferences().getWrapping() ? 2624 : 2816;
        this.composite = new Composite((Composite)this.logView.tabFolder, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        GridData data = new GridData(4, 4, true, true);
        this.composite.setLayout((Layout)layout);
        this.composite.setLayoutData((Object)data);
        this.composite.setBackground(UnifiedColorManager.getInstance().getColor(new RGB(220, 220, 220)));
        this.viewer = new LogSourceViewer(this.composite, this.ruler, this.overviewRuler, true, viewerStyle);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int i = 0;
                ++i;
            }
        });
        this.viewer.setDocument(this.getDocument());
        Control control = this.viewer.getControl();
        control.setLayoutData((Object)data);
        this.viewer.getTextWidget().setFont(LoggingPlugin.getDefault().getLoggingPreferences().getFont());
        item.setControl((Control)this.composite);
        Menu menu = this.logView.menuMgr.createContextMenu((Control)this.viewer.getTextWidget());
        this.viewer.getTextWidget().setMenu(menu);
        LogView logView = this.logView;
        ((Object)((Object)logView)).getClass();
        LogView.TextListener listener = new LogView.TextListener(logView, (TextViewer)this.viewer);
        this.viewer.addTextInputListener((ITextInputListener)listener);
        this.viewer.addTextListener((ITextListener)listener);
        this.viewer.activatePlugins();
        this.createSourceViewerDecorationSupport((ISourceViewer)this.viewer);
        this.bindToColorizationSave(this.viewer);
    }

    void recreateItem(String name, int newPos) {
        this.item = new CTabItem(this.logView.tabFolder, -1, newPos);
        this.item.setText(name);
        this.item.setControl((Control)this.composite);
    }

    private void bindToColorizationSave(final SourceViewer viewer) {
        this.colorizationPreferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("Colorization saved".equals(event.getProperty())) {
                    LogTab.this.createColorizer();
                    LogTab.this.lexememanager.clearCache();
                    if (viewer != null) {
                        viewer.setRedraw(false);
                        LogTab.this.viewer.getTextWidget().removeLineStyleListener(LogTab.this._lineStyleListener);
                        LogTab.this.viewer.getTextWidget().addLineStyleListener(LogTab.this._lineStyleListener);
                        viewer.setRedraw(true);
                    }
                }
            }
        };
        UnifiedEditorsPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.colorizationPreferencesListener);
        LoggingPreferences preferences = LoggingPlugin.getDefault().getLoggingPreferences();
        this.loggingPreferenceListener = new ILoggingPreferenceListener(){

            public void rulesChanged() {
            }

            public void wrappingChanged(boolean wrapping) {
                LogTab.this.recreateViewer();
            }

            public void fontChanged(Font font) {
                viewer.getTextWidget().setFont(font);
            }

            public void textForegroundColorChanged(Color color) {
                LogTab.this.textForeground = color;
            }
        };
        preferences.addPreferenceListener(this.loggingPreferenceListener);
    }

    private void hookRulerContextMenu() {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LogTab.this.logView.setFocus();
                LogTab.this.fillRulerContextMenu(manager);
            }
        });
        Menu menu = this.menuMgr.createContextMenu(this.ruler.getControl());
        this.ruler.getControl().setMenu(menu);
        this.logView.getSite().registerContextMenu(this.menuMgr, this.viewer.getSelectionProvider());
    }

    private void fillRulerContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAddBookmark);
    }

    protected IVerticalRuler createVerticalRuler(IAnnotationAccess access) {
        return new VerticalRuler(12, access);
    }

    protected IOverviewRuler createOverviewRuler(IAnnotationAccess access) {
        ISharedTextColors sharedColors = EditorsPlugin.getDefault().getSharedTextColors();
        OverviewRuler ruler = new OverviewRuler(access, 12, sharedColors);
        for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        String type = BOOKMARK_ANNOTATION_TYPE;
        ruler.addAnnotationType((Object)type);
        ruler.addHeaderAnnotationType((Object)type);
        ruler.setAnnotationTypeLayer((Object)type, 1);
        ruler.setAnnotationTypeColor((Object)type, this.bookmarkColor);
        return ruler;
    }

    private String getTabName(String path) {
        Path p = new Path(path);
        return p.lastSegment();
    }

    private void makeTabBold(boolean bold) {
        Font currentFont = this.item.getFont();
        int style = currentFont.getFontData()[0].getStyle();
        if (bold) {
            if ((style & 1) != 0) {
                return;
            }
            this.item.setFont(this.boldFont);
        } else {
            if ((style & 1) == 0) {
                return;
            }
            this.item.setFont(this.normalFont);
        }
    }

    private void makeTabShaded(boolean shaded) {
        if (shaded) {
            Font currentFont = this.item.getFont();
            if (currentFont.equals((Object)this.italicFont)) {
                return;
            }
            this.item.setFont(this.italicFont);
        } else {
            Font currentFont = this.item.getFont();
            if (!currentFont.equals((Object)this.italicFont)) {
                return;
            }
            this.item.setFont(this.normalFont);
        }
    }

    private void initializeColors() {
        this.textForeground = LoggingPlugin.getDefault().getLoggingPreferences().getTextColor();
    }

    private void initializeFonts() {
        Font normalFont;
        this.normalFont = normalFont = this.item.getFont();
        FontData data = normalFont.getFontData()[0];
        int originalStyle = data.getStyle();
        int boldStyle = originalStyle | 1;
        data.setStyle(boldStyle);
        this.boldFont = new Font(normalFont.getDevice(), new FontData[]{data});
        int italicStyle = originalStyle | 2;
        data = normalFont.getFontData()[0];
        data.setStyle(italicStyle);
        this.italicFont = new Font(normalFont.getDevice(), new FontData[]{data});
    }

    private void createActions() {
        this.actionAddBookmark = new LoggingMarkerRulerAction(Messages.getResourceBundle(), BOOKMARK_PREFIX, this.resource, this.getDocument(), (IAnnotationModel)this.model, this.ruler, true, "org.eclipse.core.resources.bookmark", this.item.getControl().getShell());
        this.actionAddBookmark.update();
    }

    private void initAnnotationModel() {
        this.model = new UniformResourceMarkerAnnotationModel((IUniformResource)this.resource);
        this.model.connect(this.getDocument());
        this.ruler.setModel((IAnnotationModel)this.model);
        this.overviewRuler.setModel((IAnnotationModel)this.model);
    }

    private void registerResourceListener() {
        this.watcher.registerListener(new ILogResourceListener(){

            public void resourceAvailable(boolean available) {
                LogTab.this.resourceAvailable = available;
                if (!LogTab.this.unreadDataAvailable) {
                    if (!LogTab.this.resourceAvailable) {
                        LogTab.this.makeTabShaded(true);
                    } else {
                        LogTab.this.makeTabShaded(false);
                    }
                }
            }
        });
    }

    private void registerTailListener() {
        this.tailListener = new ILogTailListener(){

            public void dataAvailable(String data, long globalOffset, long globalLength) {
                LogTab.this.updateData(data, globalOffset, globalLength);
            }

            public void errorHappened(Throwable th) {
                IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)com.aptana.ide.logging.view.Messages.LogTab_ERR_FetchTail, (Throwable)th);
            }
        };
        this.watcher.registerListener(this.tailListener);
    }

    private void updateContentDependentActions() {
        for (Action action : this.contentDependentActions) {
            if (!(action instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
    }

    void markAsContentDependent(Action action) {
        this.contentDependentActions.add(action);
    }

    private void linkColorer() {
        if (this._lineStyleListener == null) {
            this._lineStyleListener = new LineStyleListener(){

                public void lineGetStyle(LineStyleEvent e) {
                    int orgOffset;
                    int offset = orgOffset = e.lineOffset;
                    int extra = 0;
                    int lineLength = e.lineText.length();
                    if (LogTab.this.viewer instanceof ITextViewerExtension5) {
                        ITextViewerExtension5 v5 = (ITextViewerExtension5)LogTab.this.viewer;
                        offset = v5.widgetOffset2ModelOffset(e.lineOffset);
                        extra = offset - e.lineOffset;
                    }
                    if (lineLength > LogTab.this._maxColorizingColumns) {
                        // empty if block
                    }
                    Lexeme[] lexemes = null;
                    try {
                        int lineNumber = LogTab.this.document.getLineOfOffset(e.lineOffset);
                        lexemes = LogTab.this.lexememanager.getLexemes(lineNumber);
                    }
                    catch (BadLocationException e1) {
                        IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)com.aptana.ide.logging.view.Messages.LogTab_ERR_Exception, (Throwable)e1);
                    }
                    if (lexemes != null && lexemes.length > 0) {
                        Vector<StyleRange> styles = new Vector<StyleRange>();
                        LogTab.this._colorizer.createStyles(styles, lexemes, false);
                        StyleRange[] styleResults = styles.toArray(new StyleRange[0]);
                        if (extra > 0) {
                            int i = 0;
                            while (i < styleResults.length) {
                                StyleRange range = styleResults[i];
                                range.start -= extra;
                                ++i;
                            }
                        }
                        e.styles = styleResults;
                    } else {
                        StyleRange[] styles = new StyleRange[]{new StyleRange(e.lineOffset, e.lineText.length(), LogTab.this.textForeground, null)};
                        e.styles = styles;
                    }
                }
            };
        }
        if (this._textChangeListener == null) {
            this._textChangeListener = new TextChangeListener(){

                public void textChanging(TextChangingEvent event) {
                }

                public void textChanged(TextChangedEvent event) {
                    StyledText text = LogTab.this.getViewer().getTextWidget();
                    this.redrawFrom(text, text.getLineAtOffset(text.getCaretOffset()));
                }

                public void textSet(TextChangedEvent event) {
                    StyledText text = LogTab.this.getViewer().getTextWidget();
                    this.redrawFrom(text, 0);
                }

                private void redrawFrom(StyledText text, int lno) {
                    if (lno < 0 || lno >= text.getLineCount()) {
                        return;
                    }
                    int height = text.getClientArea().height;
                    int width = text.getClientArea().width + text.getHorizontalPixel();
                    try {
                        text.redraw(0, 0, width, height, true);
                    }
                    catch (Exception exception) {}
                }
            };
        }
        this.getViewer().getTextWidget().addLineStyleListener(this._lineStyleListener);
        this.getViewer().getTextWidget().getContent().addTextChangeListener(this._textChangeListener);
    }

    private void addLexeme(Lexeme lexeme, LexemeList lexemes) {
        lexemes.add(lexeme);
    }

    private ILexer getLexer() {
        return TokenTypes.getLexerFactory().getLexer();
    }

    private Lexeme findLastRecognizedRegexpLexeme(LexemeList lexemes) {
        if (lexemes.size() == 0) {
            return null;
        }
        int i = lexemes.size() - 1;
        while (i >= 0) {
            Lexeme currentLexeme = lexemes.get(i);
            if (TokenTypes.isRegexpType(currentLexeme.getType())) {
                return currentLexeme;
            }
            --i;
        }
        return null;
    }

    private void disposeListeners() {
        UnifiedEditorsPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.colorizationPreferencesListener);
        LoggingPlugin.getDefault().getLoggingPreferences().removePreferenceListener(this.loggingPreferenceListener);
        this.watcher.removeListener(this.tailListener);
    }

    private void createColorizer() {
        this._colorizer = new LoggingColorizer(this.getLexer().getTokenList("text/log"));
    }

    private boolean getAutobolding() {
        return LoggingPlugin.getDefault().getLoggingPreferences().getAutoBolding();
    }

    protected void createSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.decorationSupport == null) {
            ISharedTextColors sharedColors = EditorsPlugin.getDefault().getSharedTextColors();
            this.decorationSupport = new SourceViewerDecorationSupport(viewer, null, null, sharedColors);
            this.configureSourceViewerDecorationSupport(this.decorationSupport);
            this.decorationSupport.install(LoggingPlugin.getDefault().getPreferenceStore());
        }
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setCursorLinePainterPreferenceKeys("com.aptana.ide.logging.preferences.LoggingPreferences.cursorline", "com.aptana.ide.logging.preferences.LoggingPreferences.cursorlinecolor");
        support.setSymbolicFontName("com.aptana.ide.logging.preferences.LoggingPreferences.maintextfont");
    }

    private IDocument getDocument() {
        return this.document;
    }

    private void updateData(String data, long globalOffset, long globalLength) {
        if (!this.equals(this.logView.getActiveTab()) && this.getAutobolding()) {
            this.unreadDataAvailable = true;
            this.makeTabBold(true);
        }
        Integer topIndex = null;
        Integer bottomIndex = null;
        int horizontalScrollPixel = -1;
        if (this.viewer != null) {
            horizontalScrollPixel = this.viewer.getTextWidget().getHorizontalPixel();
            this.viewer.setRedraw(false);
            this.viewer.getSelection();
            topIndex = this.viewer.getTopIndex();
            bottomIndex = this.viewer.getBottomIndex();
        }
        this.updateDocumentData(data, globalOffset, globalLength);
        if (this.viewer != null) {
            this.viewer.setRedraw(true);
            if (this.followTail) {
                ((LogSourceViewer)this.viewer).revealLastLine();
            } else if (topIndex != null) {
                try {
                    int startOffset = this.document.getLineOffset(topIndex.intValue());
                    int endOffset = this.document.getLineOffset(bottomIndex.intValue()) + this.document.getLineLength(bottomIndex.intValue());
                    this.viewer.revealRange(startOffset, endOffset - startOffset);
                    topIndex = this.viewer.getTopIndex();
                    bottomIndex = this.viewer.getBottomIndex();
                }
                catch (BadLocationException e) {
                    IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)com.aptana.ide.logging.view.Messages.LogTab_ERR_Exception, (Throwable)e);
                }
            }
            int horizontalScrollPixel1 = horizontalScrollPixel;
            this.viewer.getTextWidget().setHorizontalPixel(horizontalScrollPixel1);
        }
    }

    private void updateDocumentData(String data, long globalOffset, long globalLength) {
        try {
            IDocument document = this.getDocument();
            long lastGlobalPosition = this.currentGlobalOffset + (long)document.getLength();
            if (globalOffset == 0L && globalLength >= Integer.MAX_VALUE) {
                document.replace(0, document.getLength(), data);
                this.currentGlobalOffset = globalOffset;
            } else if (globalOffset < this.currentGlobalOffset) {
                int diff = (int)(this.currentGlobalOffset - globalOffset);
                if (diff <= data.length()) {
                    int lengthToReplace = (int)(globalLength - (long)diff);
                    String beginData = data.substring(0, diff);
                    String innrerData = data.substring(diff, data.length());
                    this.replaceInnerData(innrerData, this.currentGlobalOffset, lengthToReplace, document);
                    document.replace(0, diff, beginData);
                    this.currentGlobalOffset = globalOffset;
                } else {
                    document.replace(0, document.getLength(), data);
                    this.currentGlobalOffset = globalOffset;
                }
            } else if (globalOffset >= this.currentGlobalOffset && globalOffset < lastGlobalPosition) {
                this.replaceInnerData(data, globalOffset, globalLength, document);
            } else if (globalOffset == lastGlobalPosition) {
                document.replace(document.getLength(), 0, data);
            } else {
                document.replace(0, document.getLength(), data);
                this.currentGlobalOffset = globalOffset;
            }
            int numberOfLines = document.getNumberOfLines();
            int allowedNumberOfLines = LoggingPlugin.getDefault().getLoggingPreferences().getBacklogLines();
            ArrayList<String> topLines = new ArrayList<String>();
            if (numberOfLines > allowedNumberOfLines) {
                int toRemoveLinesNum = numberOfLines - allowedNumberOfLines;
                int offset = document.getLineOffset(toRemoveLinesNum);
                int i = 0;
                while (i < toRemoveLinesNum) {
                    int lineOffset = document.getLineOffset(i);
                    int lineLength = document.getLineLength(i);
                    topLines.add(document.get(lineOffset, lineLength));
                    ++i;
                }
                this.currentGlobalOffset += (long)offset;
                document.replace(0, offset, "");
            }
            if (this.lexememanager != null) {
                this.lexememanager.dataAvailable(topLines);
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)com.aptana.ide.logging.view.Messages.LogTab_8, (Throwable)e);
        }
    }

    private void replaceInnerData(String data, long globalOffset, long globalLength, IDocument document) throws BadLocationException {
        int diff = (int)(globalOffset - this.currentGlobalOffset);
        int lengthToReplace = (int)globalLength;
        if (lengthToReplace == Integer.MAX_VALUE || diff + lengthToReplace > document.getLength()) {
            lengthToReplace = document.getLength() - diff;
        }
        document.replace(diff, lengthToReplace, data);
    }

    private static class DocumentWriter
    extends Writer {
        private IDocument document;

        public DocumentWriter(IDocument document) {
            this.document = document;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            try {
                this.document.replace(this.document.getLength(), 0, new String(cbuf, off, len));
            }
            catch (BadLocationException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    static class LogSourceViewer
    extends SourceViewer {
        public LogSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        }

        protected void revealLastLine() {
            try {
                int endLine;
                IDocument doc = this.getVisibleDocument();
                int startLine = endLine = doc.getLineOfOffset(doc.getLength() == 0 ? 0 : doc.getLength() - 1);
                int top = this.getTextWidget().getTopIndex();
                if (top > -1) {
                    int bottom = LogSourceViewer.getBottomIndex(this.getTextWidget());
                    int lines = bottom - top;
                    if (startLine < top || startLine > bottom || endLine < top || endLine > bottom) {
                        int delta = Math.max(0, lines - (endLine - startLine));
                        this.getTextWidget().setTopIndex(startLine - delta / 3);
                        this.updateViewportListeners(6);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException("Illegal text range");
            }
        }

        public static int getBottomIndex(StyledText widget) {
            int lastPixel = LogSourceViewer.computeLastVisiblePixel(widget);
            int bottom = widget.getLineIndex(lastPixel);
            if (bottom == 0) {
                return bottom;
            }
            int pixel = widget.getLinePixel(bottom);
            if (pixel <= 0) {
                return bottom;
            }
            int offset = widget.getOffsetAtLine(bottom);
            int height = widget.getLineHeight(offset);
            if (pixel + height - 1 > lastPixel) {
                return bottom - 1;
            }
            return bottom;
        }

        private static int computeLastVisiblePixel(StyledText widget) {
            int caHeight = widget.getClientArea().height;
            int lastPixel = caHeight - 1;
            return lastPixel;
        }
    }
}

