/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.logging.view;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.logging.DefaultLogInfo;
import com.aptana.ide.logging.LoggingPlugin;
import com.aptana.ide.logging.LoggingPreferences;
import com.aptana.ide.logging.Messages;
import com.aptana.ide.logging.impl.DefaultLogsFactory;
import com.aptana.ide.logging.preferences.NewRuleDialog;
import com.aptana.ide.logging.view.LogTab;
import com.aptana.ide.logging.view.RenameTabDialog;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class LogView
extends ViewPart {
    private static final String LOG_VIEW_SETTINGS_SECTION = "org.aptana.ide.logging.viewer.section";
    private static final String LOG_VIEW_SET_TAB_URIS_KEY = "org.aptana.ide.logging.viewer.section.tabs.uris";
    private static final String LOG_VIEW_SET_TAB_SUPPORTS_ERASING = "org.aptana.ide.logging.viewer.section.tabs.supportsErasing";
    private static final String LOG_VIEW_SET_TAB_NAMES_KEY = "org.aptana.ide.logging.viewer.section.tabs.names";
    public static final String FIND_REPLACE = "com.aptana.ide.core.ui.FindReplaceAction";
    public static final String ID = "com.aptana.ide.logging.LogView";
    private static ImageDescriptor fAddActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/open_active.gif");
    private static ImageDescriptor fRemoveActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/remove_active.gif");
    private static ImageDescriptor fRemoveAllActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/removeall_active.gif");
    private static ImageDescriptor fStartActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/start_active.gif");
    private static ImageDescriptor fStopActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/stop_active.gif");
    private static ImageDescriptor fReloadActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/refresh_active.gif");
    private static ImageDescriptor fClearLogActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/clear_log.png");
    private static ImageDescriptor fClearLogFileActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/delete_log_active.gif");
    private static ImageDescriptor fScrollLockActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/scrolllock_active.gif");
    private static ImageDescriptor fMoveTabLeftActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/backward_nav_on.gif");
    private static ImageDescriptor fMoveTabRightActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/forward_nav_on.gif");
    private static ImageDescriptor fToolsActionDescriptor = LoggingPlugin.getImageDescriptor("icons/active/color_settings.png");
    private Set<Action> contentDependentActions = new HashSet<Action>();
    CTabFolder tabFolder;
    protected Shell shell;
    private Action actionAdd;
    private Action actionDelete;
    private Action actionDeleteAll;
    private Action actionStart;
    private Action actionStop;
    private Action actionReload;
    private Action actionLogClear;
    private Action actionLogFileClear;
    private Action actionFindReplace;
    private Action actionFollowTail;
    private Action actionRenameTab;
    private Action actionMoveTabLeft;
    private Action actionMoveTabRight;
    private Action actionNewStringRule;
    private Action toolsAction;
    private List<Action> defaultLogActions = new ArrayList<Action>();
    private Map<URI, LogTab> tabs = new HashMap<URI, LogTab>();
    MenuManager menuMgr;
    private Font toolbarFont;

    public void createPartControl(Composite parent) {
        this.shell = parent.getShell();
        this.tabFolder = new CTabFolder(parent, -1);
        this.tabFolder.setSimple(true);
        this.tabFolder.setSelectionBackground(UnifiedColorManager.getInstance().getColor(new RGB(220, 220, 220)));
        int fontsize = 8;
        if ("macosx".equals(Platform.getOS())) {
            fontsize = 10;
        }
        this.toolbarFont = new Font((Device)this.tabFolder.getDisplay(), "Arial", fontsize, 0);
        this.tabFolder.setFont(this.toolbarFont);
        this.tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LogView.this.saveTabsConfiguration();
                LogView.this.closeAllTabs();
            }
        });
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                LogView.this.updateContentDependentActions();
            }

            public void widgetSelected(SelectionEvent e) {
                LogView.this.updateContentDependentActions();
                LogTab activeTab = LogView.this.getActiveTab();
                if (activeTab != null) {
                    activeTab.selected();
                }
            }
        });
        this.tabFolder.addCTabFolder2Listener(new CTabFolder2Listener(){

            public void close(CTabFolderEvent event) {
                Widget itemToSearch = event.item;
                LogTab toDelete = null;
                for (LogTab tab : LogView.this.tabs.values()) {
                    if (!tab.getItem().equals(itemToSearch)) continue;
                    toDelete = tab;
                    break;
                }
                if (toDelete != null) {
                    LogView.this.deleteTab(toDelete);
                }
            }

            public void maximize(CTabFolderEvent event) {
            }

            public void minimize(CTabFolderEvent event) {
            }

            public void restore(CTabFolderEvent event) {
            }

            public void showList(CTabFolderEvent event) {
            }
        });
        this.createActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.loadTabsConfiguration();
    }

    public void setFocus() {
    }

    public Object getAdapter(Class adapter) {
        TextViewer currentViewer;
        if (IFindReplaceTarget.class.equals((Object)adapter) && (currentViewer = this.getCurrentViewer()) != null) {
            return currentViewer.getFindReplaceTarget();
        }
        return super.getAdapter(adapter);
    }

    public void addTab(String path, String name, boolean supportsLogErase) {
        File file = new File(path);
        URI uri = file.toURI();
        this.addTab(uri, name, supportsLogErase);
    }

    public void addTab(URI uri, String tabName, boolean supportsLogErase) {
        LogTab tab = this.tabs.get(uri);
        if (tab == null) {
            tab = new LogTab(this, uri, tabName, supportsLogErase);
            this.tabs.put(uri, tab);
        } else {
            this.tabFolder.setSelection(tab.getItem());
        }
        this.updateContentDependentActions();
    }

    private TextViewer getCurrentViewer() {
        LogTab tab = this.getActiveTab();
        if (tab != null) {
            return tab.getViewer();
        }
        return null;
    }

    private void hookContextMenu() {
        this.menuMgr = new MenuManager("#PopupMenu");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LogView.this.fillContextMenu(manager);
            }
        });
        Menu menu = this.menuMgr.createContextMenu((Control)this.tabFolder);
        this.tabFolder.setMenu(menu);
        this.getSite().registerContextMenu(this.menuMgr, new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return null;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionMoveTabLeft);
        manager.add((IAction)this.actionMoveTabRight);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionStart);
        manager.add((IAction)this.actionStop);
        manager.add((IAction)this.actionReload);
        manager.add((IAction)this.actionLogClear);
        manager.add((IAction)this.actionLogFileClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionDeleteAll);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionFollowTail);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.toolsAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionFindReplace);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRenameTab);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionNewStringRule);
        manager.add((IContributionItem)new Separator());
        this.createDefaultLogActions();
        for (Action action : this.defaultLogActions) {
            manager.add((IAction)action);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void createActions() {
        this.createAddAction();
        this.createDeleteAction();
        this.createStartAction();
        this.createStopAction();
        this.createDeleteAllAction();
        this.createReloadAction();
        this.createClearLogAction();
        this.createClearLogFileAction();
        this.createFindReplaceAction();
        this.createFollowTailAction();
        this.createRenameTabAction();
        this.createOrderActions();
        this.createNewRuleActions();
        this.createToolsAction();
    }

    private void createNewRuleActions() {
        this.actionNewStringRule = new Action(){

            public void run() {
                LogTab activeTab = LogView.this.getActiveTab();
                if (activeTab != null) {
                    String selection = activeTab.getSelection();
                    if (selection == null || selection.length() == 0) {
                        selection = "";
                    }
                    NewRuleDialog dialog = new NewRuleDialog(selection, LogView.this.shell);
                    ArrayList<String> forbiddenNames = new ArrayList<String>();
                    List<LoggingPreferences.Rule> rules = LoggingPlugin.getDefault().getLoggingPreferences().getRules();
                    for (LoggingPreferences.Rule rule : rules) {
                        forbiddenNames.add(rule.getName());
                    }
                    dialog.setForbiddenNames(forbiddenNames);
                    if (dialog.open() == 0) {
                        rules.add(new LoggingPreferences.Rule(dialog.getName(), dialog.getContent(), dialog.isRegexp(), dialog.isCaseInsensitive()));
                        activeTab.refreshViewer();
                    }
                }
            }
        };
        this.actionNewStringRule.setText(com.aptana.ide.logging.view.Messages.LogView_NewStringRule_name);
        this.actionNewStringRule.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_NewStringRule_tooltip);
    }

    private void createOrderActions() {
        this.actionMoveTabLeft = new Action(){

            public void run() {
                LogTab tab;
                LogTab activeTab = LogView.this.getActiveTab();
                if (activeTab != null && (tab = LogView.this.getActiveTab()) != null) {
                    int oldPosition = LogView.this.tabFolder.indexOf(tab.getItem());
                    if (oldPosition == 0) {
                        return;
                    }
                    String name = tab.getName();
                    tab.getItem().dispose();
                    tab.recreateItem(name, oldPosition - 1);
                    LogView.this.tabFolder.setSelection(tab.getItem());
                    LogView.this.tabFolder.redraw();
                }
            }
        };
        this.actionMoveTabLeft.setText(com.aptana.ide.logging.view.Messages.LogView_MoveTabLeftAction_name);
        this.actionMoveTabLeft.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_MoveTabLeftAction_tooltip);
        this.actionMoveTabLeft.setImageDescriptor(fMoveTabLeftActionDescriptor);
        this.actionMoveTabRight = new Action(){

            public void run() {
                LogTab tab;
                LogTab activeTab = LogView.this.getActiveTab();
                if (activeTab != null && (tab = LogView.this.getActiveTab()) != null) {
                    int oldPosition = LogView.this.tabFolder.indexOf(tab.getItem());
                    if (oldPosition == LogView.this.tabFolder.getTabList().length - 1) {
                        return;
                    }
                    String name = tab.getName();
                    tab.getItem().dispose();
                    tab.recreateItem(name, oldPosition + 1);
                    LogView.this.tabFolder.setSelection(tab.getItem());
                    LogView.this.tabFolder.redraw();
                }
            }
        };
        this.actionMoveTabRight.setText(com.aptana.ide.logging.view.Messages.LogView_MoveTabRightAction_name);
        this.actionMoveTabRight.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_MoveTabRightAction_tooltip);
        this.actionMoveTabRight.setImageDescriptor(fMoveTabRightActionDescriptor);
    }

    private void createRenameTabAction() {
        this.actionRenameTab = new RenameTabAction((IWorkbenchPart)this);
        this.actionRenameTab.setText(com.aptana.ide.logging.view.Messages.LogView_RenameTabAction_name);
        this.actionRenameTab.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_RenameTabAction_tooltip);
        this.markAsContentDependent(this.actionRenameTab);
    }

    private void createFollowTailAction() {
        this.actionFollowTail = new Action(com.aptana.ide.logging.view.Messages.LogView_FollowTailAction_text, 2){
            private boolean checked;
            {
                this.checked = false;
            }

            public void run() {
                this.checked = !this.checked;
                this.setChecked(this.checked);
                LogView.this.getActiveTab().invertFollowTail();
            }
        };
        this.actionFollowTail.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_FollowTailAction_tooltip);
        this.actionFollowTail.setImageDescriptor(fScrollLockActionDescriptor);
    }

    private void createAddAction() {
        this.actionAdd = new Action(){

            public void run() {
                FileDialog dialog = new FileDialog(LogView.this.shell);
                String path = dialog.open();
                if (path != null) {
                    LogView.this.addTab(path, null, true);
                }
            }
        };
        this.actionAdd.setText(com.aptana.ide.logging.view.Messages.LogView_3);
        this.actionAdd.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_4);
        this.actionAdd.setImageDescriptor(fAddActionDescriptor);
    }

    private void createDeleteAction() {
        this.actionDelete = new Action(){

            public void run() {
                LogTab currentTab = LogView.this.getActiveTab();
                if (currentTab != null) {
                    LogView.this.deleteTab(currentTab);
                }
            }
        };
        this.actionDelete.setText(com.aptana.ide.logging.view.Messages.LogView_5);
        this.actionDelete.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_6);
        this.actionDelete.setImageDescriptor(fRemoveActionDescriptor);
    }

    private void createClearLogAction() {
        this.actionLogClear = new Action(){

            public void run() {
                LogTab currentTab = LogView.this.getActiveTab();
                if (currentTab != null) {
                    currentTab.clear();
                }
            }
        };
        this.actionLogClear.setText(com.aptana.ide.logging.view.Messages.LogView_7);
        this.actionLogClear.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_8);
        this.actionLogClear.setImageDescriptor(fClearLogActionDescriptor);
    }

    private void createClearLogFileAction() {
        this.actionLogFileClear = new Action(){

            public void run() {
                LogTab currentTab = LogView.this.getActiveTab();
                if (currentTab != null && MessageDialog.openQuestion((Shell)LoggingPlugin.getActiveWorkbenchShell(), (String)com.aptana.ide.logging.view.Messages.EraseConfirmDialog_Title, (String)com.aptana.ide.logging.view.Messages.EraseConfirmDialog_Message)) {
                    currentTab.clearLogFile();
                }
            }
        };
        this.actionLogFileClear.setText(com.aptana.ide.logging.view.Messages.LogView_9);
        this.actionLogFileClear.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_10);
        this.actionLogFileClear.setImageDescriptor(fClearLogFileActionDescriptor);
    }

    private void createDeleteAllAction() {
        this.actionDeleteAll = new Action(){

            public void run() {
                LogView.this.closeAllTabs();
            }
        };
        this.actionDeleteAll.setText(com.aptana.ide.logging.view.Messages.LogView_11);
        this.actionDeleteAll.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_12);
        this.actionDeleteAll.setImageDescriptor(fRemoveAllActionDescriptor);
    }

    private void createStartAction() {
        this.actionStart = new Action(){

            public void run() {
                LogTab currentTab = LogView.this.getActiveTab();
                if (currentTab != null) {
                    currentTab.start();
                    LogView.this.updateWatchControlActions();
                }
            }
        };
        this.actionStart.setText(com.aptana.ide.logging.view.Messages.LogView_13);
        this.actionStart.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_14);
        this.actionStart.setImageDescriptor(fStartActionDescriptor);
    }

    private void createStopAction() {
        this.actionStop = new Action(){

            public void run() {
                LogTab currentTab = LogView.this.getActiveTab();
                if (currentTab != null) {
                    currentTab.stop();
                    LogView.this.updateWatchControlActions();
                }
            }
        };
        this.actionStop.setText(com.aptana.ide.logging.view.Messages.LogView_15);
        this.actionStop.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_16);
        this.actionStop.setImageDescriptor(fStopActionDescriptor);
    }

    private void createReloadAction() {
        this.actionReload = new Action(){

            public void run() {
                LogTab currentTab = LogView.this.getActiveTab();
                if (currentTab != null) {
                    currentTab.reload();
                }
            }
        };
        this.actionReload.setText(com.aptana.ide.logging.view.Messages.LogView_17);
        this.actionReload.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_18);
        this.actionReload.setImageDescriptor(fReloadActionDescriptor);
    }

    private void createFindReplaceAction() {
        this.actionFindReplace = new FindReplaceAction(Messages.getResourceBundle(), "FindReplace.", (IWorkbenchPart)this);
        this.actionFindReplace.setId(ActionFactory.FIND.getId());
        this.getViewSite().getActionBars().setGlobalActionHandler(ActionFactory.FIND.getId(), (IAction)this.actionFindReplace);
        this.markAsContentDependent(this.actionFindReplace);
    }

    private void createDefaultLogActions() {
        this.defaultLogActions.clear();
        List<DefaultLogInfo> infos = DefaultLogsFactory.getLogURIs();
        for (DefaultLogInfo info : infos) {
            final DefaultLogInfo finalInfo = info;
            if (finalInfo.getUri() == null) continue;
            Action action = new Action(){

                public void run() {
                    LogView.this.addTab(finalInfo.getUri(), finalInfo.getName(), finalInfo.supportsLogErase());
                }
            };
            action.setText(finalInfo.getName());
            this.defaultLogActions.add(action);
        }
    }

    private void createToolsAction() {
        this.toolsAction = new Action(){

            public void run() {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)LogView.this.shell, (String)"com.aptana.ide.logging.preferences.LoggingColorizationPreferencePage", (String[])new String[0], (Object)1);
                dialog.open();
            }
        };
        this.toolsAction.setText(com.aptana.ide.logging.view.Messages.LogView_ToolsAction_Label);
        this.toolsAction.setToolTipText(com.aptana.ide.logging.view.Messages.LogView_ToolsAction_Tooltip);
        this.toolsAction.setImageDescriptor(fToolsActionDescriptor);
    }

    LogTab getActiveTab() {
        int tabIndex = this.tabFolder.getSelectionIndex();
        if (tabIndex < 0) {
            return null;
        }
        CTabItem item = this.tabFolder.getItem(tabIndex);
        for (LogTab tab : this.tabs.values()) {
            if (!tab.getItem().equals(item)) continue;
            return tab;
        }
        return null;
    }

    private void saveTabsConfiguration() {
        IDialogSettings settings = LoggingPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(LOG_VIEW_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(LOG_VIEW_SETTINGS_SECTION);
        }
        ArrayList<String> tabURIs = new ArrayList<String>();
        ArrayList<String> tabNames = new ArrayList<String>();
        ArrayList<String> tabSupportsErase = new ArrayList<String>();
        for (LogTab tab : this.tabs.values()) {
            tabURIs.add(tab.getURI().toString());
            tabNames.add(tab.getName());
            tabSupportsErase.add(Boolean.toString(tab.supportsLogErase()));
        }
        String[] uris = new String[tabURIs.size()];
        tabURIs.toArray(uris);
        String[] names = new String[tabNames.size()];
        tabNames.toArray(names);
        String[] supportsErase = new String[tabSupportsErase.size()];
        tabSupportsErase.toArray(supportsErase);
        section.put(LOG_VIEW_SET_TAB_URIS_KEY, uris);
        section.put(LOG_VIEW_SET_TAB_NAMES_KEY, names);
        section.put(LOG_VIEW_SET_TAB_SUPPORTS_ERASING, supportsErase);
    }

    private void loadTabsConfiguration() {
        IDialogSettings settings = LoggingPlugin.getDefault().getDialogSettings();
        if (settings == null) {
            return;
        }
        IDialogSettings section = settings.getSection(LOG_VIEW_SETTINGS_SECTION);
        if (section == null) {
            return;
        }
        String[] tabURIs = section.getArray(LOG_VIEW_SET_TAB_URIS_KEY);
        String[] tabNames = section.getArray(LOG_VIEW_SET_TAB_NAMES_KEY);
        String[] tabSupportsEraseArray = section.getArray(LOG_VIEW_SET_TAB_SUPPORTS_ERASING);
        if (tabURIs == null || tabNames == null || tabURIs.length != tabNames.length) {
            return;
        }
        int i = 0;
        while (i < tabURIs.length) {
            String tabURI = tabURIs[i];
            String tabName = tabNames[i];
            boolean tabSupportsErase = true;
            if (tabSupportsEraseArray != null) {
                tabSupportsErase = Boolean.parseBoolean(tabSupportsEraseArray[i]);
            }
            try {
                this.addTab(new URI(tabURI), tabName, tabSupportsErase);
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)LoggingPlugin.getDefault(), (String)com.aptana.ide.logging.view.Messages.LogView_20, (Throwable)e);
            }
            ++i;
        }
        this.updateContentDependentActions();
    }

    void markAsContentDependent(Action action) {
        this.contentDependentActions.add(action);
    }

    private void updateContentDependentActions() {
        for (Action action : this.contentDependentActions) {
            if (!(action instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
        this.updateWatchControlActions();
    }

    private void closeAllTabs() {
        for (LogTab tab : this.tabs.values()) {
            tab.close();
        }
        this.tabs.clear();
    }

    private void deleteTab(LogTab tab) {
        tab.close();
        for (Map.Entry<URI, LogTab> entry : this.tabs.entrySet()) {
            if (!entry.getValue().equals(tab)) continue;
            this.tabs.remove(entry.getKey());
            break;
        }
        this.updateContentDependentActions();
    }

    private void updateWatchControlActions() {
        LogTab activeTab = this.getActiveTab();
        this.actionStart.setEnabled(activeTab != null && !activeTab.isWatching());
        this.actionStop.setEnabled(activeTab != null && activeTab.isWatching());
        this.actionMoveTabLeft.setEnabled(activeTab != null && this.tabFolder.indexOf(activeTab.getItem()) > 0);
        this.actionMoveTabRight.setEnabled(activeTab != null && this.tabFolder.indexOf(activeTab.getItem()) < this.tabFolder.getItemCount() - 1);
        if (activeTab != null) {
            this.actionLogFileClear.setEnabled(activeTab.supportsLogErase());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.toolbarFont != null) {
            this.toolbarFont.dispose();
        }
    }

    class RenameTabAction
    extends Action
    implements IUpdate {
        private IWorkbenchPart workbenchPart;

        public RenameTabAction(IWorkbenchPart workbenchPart) {
            this.workbenchPart = workbenchPart;
        }

        public void run() {
            RenameTabDialog dialog;
            LogTab activeTab = LogView.this.getActiveTab();
            if (activeTab != null && (dialog = new RenameTabDialog(LogView.this.shell, activeTab.getName())).open() == 0) {
                activeTab.setName(dialog.getName());
            }
        }

        public void update() {
            IFindReplaceTarget target = null;
            if (this.workbenchPart != null) {
                target = (IFindReplaceTarget)this.workbenchPart.getAdapter(IFindReplaceTarget.class);
            }
            this.setEnabled(target != null);
        }
    }

    class TextListener
    implements ITextListener,
    ITextInputListener {
        private TextViewer viewer;

        public TextListener(TextViewer viewer) {
            this.viewer = viewer;
        }

        public void textChanged(TextEvent event) {
            this.update();
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            this.update();
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            this.update();
        }

        void update() {
            TextViewer currentViewer = LogView.this.getCurrentViewer();
            if (currentViewer != null && currentViewer.equals(this.viewer)) {
                LogView.this.updateContentDependentActions();
            }
        }
    }
}

