/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.update.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.MutexJobRule;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.ui.BaseTimingStartup;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.update.ui.BrowserDialog;
import com.aptana.ide.update.ui.UpdateUIActivator;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.browser.WebBrowserEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Version;

public class SchedulerStartup
extends BaseTimingStartup {
    private static final String HEADER_WIDTH = "Width";
    private static final String HEADER_HEIGHT = "Height";

    public String getStartupName() {
        return "SchedulerStartup";
    }

    protected void startup() {
        this.scheduleCheckForReleaseMessage();
        this.scheduleCheckForNewsMessage();
        this.scheduleCheckForAnnouncements();
        this.startupDone();
    }

    private void scheduleCheckForReleaseMessage() {
        boolean doNotCheckForReleaseMessage = Boolean.getBoolean("DO_NOT_CHECK_FOR_RELEASE_MESSAGE");
        if (doNotCheckForReleaseMessage) {
            return;
        }
        final IPreferenceStore prefs = UpdateUIActivator.getDefault().getPreferenceStore();
        final String releaseMessageURLPrefix = prefs.getString("com.aptana.ide.update.ui.RELEASE_MESSAGE_URL_PREFIX");
        Job job = new Job("Check for new release message"){

            protected IStatus run(IProgressMonitor monitor) {
                block12: {
                    try {
                        final URL releaseMessageURL = new URL(System.getProperty("RELEASE_MESSAGE_URL_OVERRIDE", String.valueOf(releaseMessageURLPrefix) + SchedulerStartup.getCoreUIVersion() + "/message.html"));
                        URLConnection urlConnection = null;
                        try {
                            urlConnection = releaseMessageURL.openConnection();
                        }
                        catch (IOException ioe) {
                            SchedulerStartup.logError(ioe);
                        }
                        if (!(urlConnection instanceof HttpURLConnection)) break block12;
                        HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                        try {
                            try {
                                httpURLConnection.setConnectTimeout(1000);
                                httpURLConnection.setUseCaches(false);
                                httpURLConnection.addRequestProperty("Cache-Control", "no-cache");
                                httpURLConnection.setRequestMethod("HEAD");
                                if (httpURLConnection.getResponseCode() == 200) {
                                    long lastLastModified;
                                    boolean showMessage = true;
                                    long lastModified = httpURLConnection.getLastModified();
                                    if (lastModified != 0L && (lastLastModified = prefs.getLong(releaseMessageURL.toString())) >= lastModified) {
                                        showMessage = false;
                                    }
                                    prefs.setValue(releaseMessageURL.toString(), lastModified);
                                    if (showMessage) {
                                        CoreUIUtils.getDisplay().asyncExec(new Runnable(){

                                            public void run() {
                                                IWorkbenchPage page = CoreUIPlugin.getActivePage();
                                                if (page != null) {
                                                    try {
                                                        page.openEditor((IEditorInput)new WebBrowserEditorInput(releaseMessageURL, 16), "com.aptana.ide.update.ui.browser.editor", false);
                                                    }
                                                    catch (PartInitException partInitException) {
                                                        CoreUIUtils.openBrowserURL((String)releaseMessageURL.toExternalForm());
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                            catch (IOException e) {
                                SchedulerStartup.logError(e);
                                httpURLConnection.disconnect();
                            }
                        }
                        finally {
                            httpURLConnection.disconnect();
                        }
                    }
                    catch (MalformedURLException e) {
                        SchedulerStartup.logError(e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void scheduleCheckForNewsMessage() {
        boolean doNotCheckForReleaseMessage = Boolean.getBoolean("DO_NOT_CHECK_FOR_NEWS_MESSAGE");
        if (doNotCheckForReleaseMessage) {
            return;
        }
        final IPreferenceStore prefs = UpdateUIActivator.getDefault().getPreferenceStore();
        String newsMessageURLPrefix = prefs.getString("com.aptana.ide.update.ui.NEWS_MESSAGE_URL_PREFIX");
        final String newsMessageBaseURL = System.getProperty("NEWS_MESSAGE_URL_OVERRIDE", String.valueOf(newsMessageURLPrefix) + "news.php");
        Job job = new Job("Check for new news message"){

            protected IStatus run(IProgressMonitor monitor) {
                block12: {
                    try {
                        final URL newsMessageURL = new URL(String.valueOf(newsMessageBaseURL) + SchedulerStartup.getParamsString());
                        URLConnection urlConnection = null;
                        try {
                            urlConnection = newsMessageURL.openConnection();
                        }
                        catch (IOException ioe) {
                            SchedulerStartup.logError(ioe);
                        }
                        if (!(urlConnection instanceof HttpURLConnection)) break block12;
                        HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                        try {
                            try {
                                httpURLConnection.setConnectTimeout(1000);
                                httpURLConnection.setUseCaches(false);
                                httpURLConnection.addRequestProperty("Cache-Control", "no-cache");
                                httpURLConnection.setRequestMethod("HEAD");
                                if (httpURLConnection.getResponseCode() == 200) {
                                    long lastLastModified;
                                    boolean showMessage = true;
                                    long lastModified = httpURLConnection.getLastModified();
                                    if (lastModified != 0L && (lastLastModified = prefs.getLong(newsMessageBaseURL)) >= lastModified) {
                                        showMessage = false;
                                    }
                                    prefs.setValue(newsMessageBaseURL, lastModified);
                                    if (showMessage) {
                                        CoreUIUtils.getDisplay().asyncExec(new Runnable(){

                                            public void run() {
                                                IWorkbenchPage page = CoreUIPlugin.getActivePage();
                                                if (page != null) {
                                                    try {
                                                        page.openEditor((IEditorInput)new WebBrowserEditorInput(newsMessageURL, 16), "com.aptana.ide.update.ui.browser.editor", false);
                                                    }
                                                    catch (PartInitException partInitException) {
                                                        CoreUIUtils.openBrowserURL((String)newsMessageURL.toExternalForm());
                                                    }
                                                }
                                            }
                                        });
                                    }
                                }
                            }
                            catch (IOException e) {
                                SchedulerStartup.logError(e);
                                httpURLConnection.disconnect();
                            }
                        }
                        finally {
                            httpURLConnection.disconnect();
                        }
                    }
                    catch (MalformedURLException e) {
                        SchedulerStartup.logError(e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void scheduleCheckForAnnouncements() {
        boolean doNotCheckForReleaseMessage = Boolean.getBoolean("DO_NOT_CHECK_FOR_NEWS_MESSAGE");
        if (doNotCheckForReleaseMessage) {
            return;
        }
        final IPreferenceStore prefs = UpdateUIActivator.getDefault().getPreferenceStore();
        boolean b_neverShow = prefs.getBoolean("com.aptana.ide.update.ui.NEVER_SHOW_ANNOUNCEMENTS");
        if (b_neverShow) {
            return;
        }
        String announcementURLPrefix = prefs.getString("com.aptana.ide.update.ui.ANNOUNCEMENT_URL_PREFIX");
        final String announceBaseURL = System.getProperty("ANNOUNCEMENT_URL_OVERRIDE", String.valueOf(announcementURLPrefix) + "announce.php");
        Job job = new Job("Check for new announcement"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    this.getAnnouncement(new URL(String.valueOf(announceBaseURL) + SchedulerStartup.getParamsString()));
                }
                catch (MalformedURLException e) {
                    SchedulerStartup.logError(e);
                }
                return Status.OK_STATUS;
            }

            private void getAnnouncement(final URL url) {
                URLConnection urlConnection = null;
                try {
                    urlConnection = url.openConnection();
                }
                catch (IOException ioe) {
                    SchedulerStartup.logError(ioe);
                }
                if (urlConnection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
                    try {
                        try {
                            httpURLConnection.setConnectTimeout(1000);
                            httpURLConnection.setUseCaches(false);
                            httpURLConnection.addRequestProperty("Cache-Control", "no-cache");
                            httpURLConnection.setRequestMethod("HEAD");
                            if (httpURLConnection.getResponseCode() == 200) {
                                int width;
                                long lastLastModified;
                                boolean neverShowThisAgain;
                                boolean showMessage = true;
                                long lastModified = httpURLConnection.getLastModified();
                                if (lastModified != 0L && (neverShowThisAgain = prefs.getBoolean("com.aptana.ide.update.ui.NEVER_SHOW_THIS_ANNOUNCEMENT")) && lastModified <= (lastLastModified = prefs.getLong("com.aptana.ide.update.ui.NEVER_SHOW_AGAIN_LAST_LAST_MODIFIED"))) {
                                    showMessage = false;
                                }
                                prefs.setValue("com.aptana.ide.update.ui.NEVER_SHOW_AGAIN_LAST_LAST_MODIFIED", lastModified);
                                String strHeight = httpURLConnection.getHeaderField(SchedulerStartup.HEADER_HEIGHT);
                                String strWidth = httpURLConnection.getHeaderField(SchedulerStartup.HEADER_WIDTH);
                                final int height = strHeight != null ? Integer.parseInt(strHeight) : 300;
                                int n = width = strWidth != null ? Integer.parseInt(strWidth) : 300;
                                if (showMessage) {
                                    UIJob uiJob = new UIJob("Show Aptana Announcement"){

                                        public IStatus runInUIThread(IProgressMonitor monitor) {
                                            IWorkbenchPage page = CoreUIPlugin.getActivePage();
                                            if (page != null) {
                                                BrowserDialog dialog = new BrowserDialog(CoreUIUtils.getActiveShell(), url.toString(), height, width);
                                                dialog.open();
                                            }
                                            return Status.OK_STATUS;
                                        }
                                    };
                                    uiJob.setSystem(true);
                                    uiJob.setRule((ISchedulingRule)MutexJobRule.getInstance());
                                    uiJob.schedule();
                                }
                            }
                        }
                        catch (IOException e) {
                            SchedulerStartup.logError(e);
                            httpURLConnection.disconnect();
                        }
                    }
                    finally {
                        httpURLConnection.disconnect();
                    }
                }
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private static void logError(Exception e) {
        IdeLog.logInfo((Plugin)UpdateUIActivator.getDefault(), (String)e.getLocalizedMessage(), (Throwable)e);
    }

    private static String getCoreUIVersion() {
        Version version = new Version(PluginUtils.getPluginVersion((Plugin)CoreUIPlugin.getDefault()));
        return MessageFormat.format("{0}.{1}.{2}.{3}", version.getMajor(), version.getMinor(), version.getMicro(), version.getQualifier());
    }

    private static String getCoreUIVersionDetailsString() {
        Version version = new Version(PluginUtils.getPluginVersion((Plugin)CoreUIPlugin.getDefault()));
        return MessageFormat.format("coreui_major={0}&coreui_minor={1}&coreui_micro={2}&coreui_qualifier={3}", version.getMajor(), version.getMinor(), version.getMicro(), version.getQualifier());
    }

    private static String getParamsString() {
        StringBuilder paramsString = new StringBuilder("?");
        paramsString.append(SchedulerStartup.getCoreUIVersionDetailsString());
        paramsString.append("&appName=").append(SchedulerStartup.getAppName());
        paramsString.append("&osgi_framework=").append(System.getProperty("osgi.framework.version"));
        paramsString.append("&os=").append(Platform.getOS());
        paramsString.append("&arch=").append(Platform.getOSArch());
        return paramsString.toString();
    }

    private static String getAppName() {
        String commands = System.getProperty("eclipse.commands");
        int indexOfNameArg = commands.indexOf("-name\n");
        String subCommands = commands.substring(indexOfNameArg + 6);
        int indexOfNextNewline = subCommands.indexOf("\n");
        String nameArg = subCommands.substring(0, indexOfNextNewline);
        return nameArg;
    }
}

