/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml;

import com.aptana.ide.editor.xml.Messages;
import com.aptana.ide.editor.xml.XMLContributor;
import com.aptana.ide.editor.xml.XMLDocumentProvider;
import com.aptana.ide.editor.xml.XMLFileServiceFactory;
import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.editors.toolbar.ToolbarWidget;
import com.aptana.ide.editors.unified.DocumentSourceProvider;
import com.aptana.ide.editors.unified.IFileServiceFactory;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.editors.unified.IUnifiedEditorContributor;
import com.aptana.ide.editors.unified.UnifiedEditor;
import com.aptana.ide.lexer.IToken;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class XMLEditor
extends UnifiedEditor {
    private boolean isDisposing = false;
    private boolean _isMarkingBothTags;
    private ToolbarWidget toolbar;
    private Composite displayArea;

    public XMLEditor() {
        this.addPluginToPreferenceStore(XMLPlugin.getDefault());
        this._isMarkingBothTags = this.getPreferenceStore().getBoolean("com.aptana.ide.editor.xml.XMLEDITOR_HIGHLIGHT_START_END_TAGS");
    }

    protected IUnifiedEditorContributor createLocalContributor() {
        return new XMLContributor();
    }

    public IFileServiceFactory getFileServiceFactory() {
        return XMLFileServiceFactory.getInstance();
    }

    public String getDefaultFileExtension() {
        return "xml";
    }

    public void dispose() {
        if (this.isDisposing) {
            return;
        }
        this.isDisposing = true;
        super.dispose();
    }

    protected boolean isNewInput(IEditorInput input) {
        XMLDocumentProvider.XMLFileInfo cuInfo = this.getXMLFileInfo(input);
        if (cuInfo == null) {
            throw new RuntimeException(Messages.XMLEditor_cuInfo_Null_At_DoSetInput);
        }
        XMLDocumentProvider dp = (XMLDocumentProvider)this.getDocumentProvider();
        IDocument document = dp.getDocument(input);
        DocumentSourceProvider provider = new DocumentSourceProvider(document, input);
        if (provider == null) {
            throw new RuntimeException(Messages.XMLEditor_Provider_Null);
        }
        return cuInfo.sourceProvider == null || !cuInfo.sourceProvider.equals(provider);
    }

    private XMLDocumentProvider.XMLFileInfo getXMLFileInfo(IEditorInput input) {
        XMLDocumentProvider dp = (XMLDocumentProvider)this.getDocumentProvider();
        if (dp == null) {
            throw new RuntimeException(Messages.XMLEditor_Document_Provider_Null);
        }
        return (XMLDocumentProvider.XMLFileInfo)dp.getFileInfoPublic(input);
    }

    protected void updateFileInfo(IEditorInput input, DocumentSourceProvider provider, IDocument document) {
        super.updateFileInfo(input, provider, document);
        if (this.isNewInput(input)) {
            this.getXMLFileInfo((IEditorInput)input).sourceProvider = provider;
        }
    }

    public void createPartControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        boolean show = this.getPreferenceStore().getBoolean("com.aptana.ide.editor.xml.SHOW_HTML_TOOLBAR");
        if (show) {
            this.toolbar = new ToolbarWidget(new String[]{"text/xml"}, new String[]{"XML"}, this.getPreferenceStore(), "com.aptana.ide.editor.xml.SHOW_HTML_TOOLBAR", (IUnifiedEditor)this);
            this.toolbar.createControl(this.displayArea);
        }
        Composite editorArea = new Composite(this.displayArea, 0);
        editorArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout eaLayout = new GridLayout(1, true);
        eaLayout.marginHeight = 0;
        eaLayout.marginWidth = 0;
        editorArea.setLayout((Layout)new FillLayout());
        super.createPartControl(editorArea);
    }

    public boolean canMarkOccurrences(Lexeme lexeme) {
        IToken token = lexeme.getToken();
        int typeIndex = token.getTypeIndex();
        return typeIndex != 1 && typeIndex != 2 && typeIndex != 49;
    }

    protected void markOccurences(LexemeList lexemeList, Lexeme selectedLexeme) {
        boolean deferToParent = true;
        if (this._isMarkingBothTags && (selectedLexeme.typeIndex == 40 || selectedLexeme.typeIndex == 27)) {
            String selectedText;
            deferToParent = false;
            String normalizedSelectedText = selectedText = selectedLexeme.getText();
            if (selectedLexeme.typeIndex == 27 && selectedLexeme.length >= 3) {
                normalizedSelectedText = String.valueOf(selectedText.substring(0, 1)) + selectedText.substring(2);
            }
            int i = 0;
            while (i < lexemeList.size()) {
                Lexeme lexeme = lexemeList.get(i);
                if (lexeme != null) {
                    if (lexeme.isHighlighted()) {
                        lexeme.setHighlighted(false);
                    }
                    if (lexeme.typeIndex == 40 || lexeme.typeIndex == 27) {
                        if (lexeme.typeIndex == selectedLexeme.typeIndex && lexeme.length == selectedLexeme.length) {
                            if (selectedText.equals(lexeme.getText())) {
                                lexeme.setHighlighted(true);
                            }
                        } else if (lexeme.length - selectedLexeme.length == 1) {
                            String normalizedText;
                            if (lexeme.typeIndex == 27 && lexeme.length >= 3 && (normalizedText = String.valueOf(lexeme.getText().substring(0, 1)) + lexeme.getText().substring(2)).equals(selectedText)) {
                                lexeme.setHighlighted(true);
                            }
                        } else if (selectedLexeme.length - lexeme.length == 1 && normalizedSelectedText.equals(lexeme.getText())) {
                            lexeme.setHighlighted(true);
                        }
                    }
                }
                ++i;
            }
        }
        if (deferToParent) {
            super.markOccurences(lexemeList, selectedLexeme);
        }
    }

    public IDocumentProvider createDocumentProvider() {
        return XMLDocumentProvider.getInstance();
    }

    protected String[] collectContextMenuPreferencePages() {
        return new String[]{"com.aptana.ide.editor.xml.preferences.GeneralPreferencePage", "com.aptana.ide.editor.xml.preferences.ColorizationPreferencePage", "com.aptana.ide.editor.xml.preferences.FoldingPreferencePage", "com.aptana.ide.editor.xml.preferences.ProblemsPreferencePage", "com.aptana.ide.editor.xml.preferences.FormattingPreferencePage", "com.aptana.ide.editor.xml.preferences.CodeAssistPreferencePage", "com.aptana.ide.editor.xml.preferences.TypingPreferencePage", "org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.Annotations", "org.eclipse.ui.editors.preferencePages.QuickDiff", "org.eclipse.ui.editors.preferencePages.Accessibility", "org.eclipse.ui.editors.preferencePages.Spelling", "org.eclipse.ui.editors.preferencePages.LinkedModePreferencePage"};
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("com.aptana.ide.editor.xml.XMLEDITOR_HIGHLIGHT_START_END_TAGS".equals(property)) {
            this._isMarkingBothTags = this.getPreferenceStore().getBoolean("com.aptana.ide.editor.xml.XMLEDITOR_HIGHLIGHT_START_END_TAGS");
        } else {
            super.handlePreferenceStoreChanged(event);
        }
    }
}

