/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.editor.xml.IXMLEnvironmentProvider;
import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.metadata.IMetadataEnvironment;
import com.aptana.ide.metadata.MetadataEnvironment;
import com.aptana.ide.metadata.MetadataRuntimeEnvironment;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public final class XMLEnvironmentRegistry {
    private static XMLEnvironmentRegistry registry;
    ArrayList<IXMLEnvironmentProvider> providers = new ArrayList();

    private XMLEnvironmentRegistry() {
        IConfigurationElement[] configurationElementsFor;
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor("com.aptana.ide.editor.xml.environmentProvider");
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                this.providers.add((IXMLEnvironmentProvider)e.createExecutableExtension("class"));
            }
            catch (CoreException coreException) {
                IdeLog.logError((Plugin)XMLPlugin.getDefault(), (String)"Exception creating environment providers");
            }
            ++n2;
        }
    }

    static XMLEnvironmentRegistry getEnvironmentRegistry() {
        if (registry == null) {
            registry = new XMLEnvironmentRegistry();
        }
        return registry;
    }

    public static IMetadataEnvironment getEnvironment(LexemeList ls, int position) {
        MetadataRuntimeEnvironment rs = new MetadataRuntimeEnvironment();
        XMLEnvironmentRegistry environmentRegistry = XMLEnvironmentRegistry.getEnvironmentRegistry();
        for (IXMLEnvironmentProvider p : environmentRegistry.providers) {
            MetadataEnvironment environment = p.getEnvironment(ls, position);
            if (environment == null) continue;
            rs.addEnvironment(environment);
        }
        return rs;
    }
}

