/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml;

import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.editors.unified.AbstractPairFinder;
import com.aptana.ide.editors.unified.PairMatch;
import com.aptana.ide.editors.unified.UnifiedColorManager;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;

public class XMLPairFinder
extends AbstractPairFinder {
    public PairMatch findPairMatch(int offset, IParseState parseState, Lexeme cursorLexeme, int loopCount) {
        PairMatch result = null;
        LexemeList lexemeList = parseState.getLexemeList();
        while (loopCount > 0 && cursorLexeme != null) {
            int index = lexemeList.getLexemeIndex(cursorLexeme);
            Lexeme matchingLexeme = null;
            switch (cursorLexeme.typeIndex) {
                case 24: {
                    Lexeme candidate = this.findLexeme(lexemeList, index + 1, 23, 1);
                    if (candidate == null) break;
                    matchingLexeme = candidate;
                    break;
                }
                case 23: {
                    Lexeme candidate = this.findLexeme(lexemeList, index - 1, 24, -1);
                    if (candidate == null) break;
                    matchingLexeme = candidate;
                    break;
                }
                case 25: {
                    Lexeme candidate = this.findLexeme(lexemeList, index + 1, 30, 1);
                    if (candidate == null) break;
                    matchingLexeme = candidate;
                    break;
                }
                case 41: {
                    Lexeme candidate = this.findLexeme(lexemeList, index + 1, 36, 1);
                    if (candidate == null) break;
                    result = new PairMatch();
                    result.beginStart = cursorLexeme.getStartingOffset();
                    result.beginEnd = cursorLexeme.getEndingOffset();
                    result.endStart = candidate.getStartingOffset();
                    result.endEnd = candidate.getEndingOffset();
                    loopCount = 0;
                    break;
                }
                case 36: {
                    Lexeme candidate = this.findLexeme(lexemeList, index - 1, 41, -1);
                    if (candidate == null) break;
                    result = new PairMatch();
                    result.beginStart = cursorLexeme.getStartingOffset();
                    result.beginEnd = result.beginStart + 2;
                    result.endStart = candidate.getStartingOffset();
                    result.endEnd = candidate.getEndingOffset();
                    loopCount = 0;
                    break;
                }
                case 50: {
                    int encodingLength = "encoding=".length();
                    if (offset - cursorLexeme.getStartingOffset() < encodingLength) break;
                    result = new PairMatch();
                    result.beginStart = cursorLexeme.getStartingOffset() + encodingLength;
                    result.beginEnd = result.beginStart + 1;
                    result.endStart = cursorLexeme.getEndingOffset() - 1;
                    result.endEnd = result.endStart + 1;
                    loopCount = 0;
                    break;
                }
                case 52: {
                    int versionLength = "version=".length();
                    if (offset - cursorLexeme.getStartingOffset() < versionLength) break;
                    result = new PairMatch();
                    result.beginStart = cursorLexeme.getStartingOffset() + versionLength;
                    result.beginEnd = result.beginStart + 1;
                    result.endStart = cursorLexeme.getEndingOffset() - 1;
                    result.endEnd = result.endStart + 1;
                    loopCount = 0;
                    break;
                }
                case 2: {
                    int openCommentLength = "<!--".length();
                    int closeCommentLength = "-->".length();
                    int start = cursorLexeme.getStartingOffset();
                    int end = cursorLexeme.getEndingOffset();
                    if (offset - start > openCommentLength && end - offset > closeCommentLength) break;
                    result = new PairMatch();
                    result.beginStart = cursorLexeme.getStartingOffset();
                    result.beginEnd = result.beginStart + 4;
                    result.endStart = cursorLexeme.getEndingOffset() - 3;
                    result.endEnd = result.endStart + 3;
                    loopCount = 0;
                    break;
                }
                case 40: {
                    IParseNode root = parseState.getParseResults();
                    IParseNode node = root.getNodeAtOffset(offset);
                    result = this.processOpenTag(cursorLexeme, result, lexemeList, node);
                    break;
                }
                case 27: {
                    IParseNode root = parseState.getParseResults();
                    IParseNode node = root.getNodeAtOffset(offset);
                    result = this.processCloseTag(cursorLexeme, result, lexemeList, index, node);
                    break;
                }
                case 30: {
                    Lexeme candidate = this.findFirstLexeme(lexemeList, index - 1, 40, 27, 25, -1);
                    if (candidate == null || candidate.typeIndex != 25) break;
                    matchingLexeme = candidate;
                    break;
                }
                case 43: {
                    if (cursorLexeme.getCategoryIndex() != 0 && (offset - 1 == cursorLexeme.getStartingOffset() || offset == cursorLexeme.getEndingOffset())) {
                        result = new PairMatch();
                        result.beginStart = cursorLexeme.getStartingOffset();
                        result.beginEnd = result.beginStart + 1;
                        result.endStart = cursorLexeme.getEndingOffset() - 1;
                        result.endEnd = result.endStart + 1;
                    }
                    loopCount = 0;
                    break;
                }
            }
            if (matchingLexeme != null) {
                result = new PairMatch();
                result.beginStart = cursorLexeme.getStartingOffset();
                result.beginEnd = cursorLexeme.getEndingOffset();
                result.endStart = matchingLexeme.getStartingOffset();
                result.endEnd = matchingLexeme.getEndingOffset();
                loopCount = 0;
                continue;
            }
            if (--loopCount > 0 && offset > 0) {
                cursorLexeme = lexemeList.getLexemeFromOffset(offset - 1);
                continue;
            }
            loopCount = 0;
        }
        return result;
    }

    private PairMatch processCloseTag(Lexeme cursorLexeme, PairMatch result, LexemeList lexemeList, int index, IParseNode node) {
        Lexeme openLexeme;
        int openIndex;
        if (node != null && (openIndex = lexemeList.getLexemeIndex(openLexeme = node.getStartingLexeme())) > 0) {
            Lexeme candidate = lexemeList.get(openIndex);
            if (candidate.typeIndex == 40) {
                result = new PairMatch();
                result.beginStart = candidate.getStartingOffset();
                result.beginEnd = candidate.getEndingOffset();
                result.endStart = cursorLexeme.getStartingOffset();
                if (index + 1 < lexemeList.size()) {
                    Lexeme bracket = lexemeList.get(index + 1);
                    result.endEnd = bracket.typeIndex == 30 ? bracket.getEndingOffset() : cursorLexeme.getEndingOffset();
                } else {
                    result.endEnd = cursorLexeme.getEndingOffset();
                }
            }
        }
        return result;
    }

    private PairMatch processOpenTag(Lexeme cursorLexeme, PairMatch result, LexemeList lexemeList, IParseNode node) {
        Lexeme closeLexeme;
        int closeIndex;
        if (node != null && (closeIndex = lexemeList.getLexemeIndex(closeLexeme = node.getEndingLexeme())) > 0) {
            Lexeme candidate = lexemeList.get(closeIndex - 1);
            if (candidate.typeIndex == 27) {
                result = new PairMatch();
                result.beginStart = cursorLexeme.getStartingOffset();
                result.beginEnd = cursorLexeme.getEndingOffset();
                result.endStart = candidate.getStartingOffset();
                result.endEnd = closeLexeme.getEndingOffset();
            }
        }
        return result;
    }

    private Lexeme findLexeme(LexemeList lexemeList, int startIndex, int type, int direction) {
        Lexeme result = null;
        while (startIndex >= 0 && startIndex < lexemeList.size()) {
            Lexeme candidate = lexemeList.get(startIndex);
            if (candidate.typeIndex == type && candidate.getLanguage().equals("text/xml")) {
                result = candidate;
                break;
            }
            startIndex += direction;
        }
        return result;
    }

    private Lexeme findFirstLexeme(LexemeList lexemeList, int startIndex, int type1, int type2, int type3, int direction) {
        Lexeme result = null;
        while (startIndex >= 0 && startIndex < lexemeList.size()) {
            Lexeme candidate = lexemeList.get(startIndex);
            if ((candidate.typeIndex == type1 || candidate.typeIndex == type2 || candidate.typeIndex == type3) && candidate.getLanguage().equals("text/xml")) {
                result = candidate;
                break;
            }
            startIndex += direction;
        }
        return result;
    }

    private String getDisplayPreference() {
        return XMLPlugin.getDefault().getPreferenceStore().getString("com.aptana.ide.editors.SHOW_PAIR_MATCHES");
    }

    public Color getPairFinderColor() {
        return UnifiedColorManager.getInstance().getColor(PreferenceConverter.getColor((IPreferenceStore)XMLPlugin.getDefault().getPreferenceStore(), (String)"com.aptana.ide.editors.PAIR_MATCHING_COLOR"));
    }

    public boolean displayOnlyMatch() {
        return this.getDisplayPreference().equals("MATCHING");
    }

    public boolean doNotDisplay() {
        return this.getDisplayPreference().equals("NONE");
    }
}

