/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.contentassist;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.KeyValuePair;
import com.aptana.ide.core.PluginUtils;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editor.xml.IKnowsChildsMetadata;
import com.aptana.ide.editor.xml.IProvidingCompletionMetadata;
import com.aptana.ide.editor.xml.XMLEnvironmentRegistry;
import com.aptana.ide.editor.xml.XMLOffsetMapper;
import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.editor.xml.contentassist.XMLCompletionProposal;
import com.aptana.ide.editor.xml.contentassist.XMLCompletionProposalComparator;
import com.aptana.ide.editor.xml.contentassist.XMLContextInformationValidator;
import com.aptana.ide.editor.xml.contentassist.XMLContextLocation;
import com.aptana.ide.editor.xml.formatting.XMLUtils;
import com.aptana.ide.editor.xml.parsing.XMLParseState;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.EditorFileContext;
import com.aptana.ide.editors.unified.IFileLanguageService;
import com.aptana.ide.editors.unified.contentassist.CodeAssistExpression;
import com.aptana.ide.editors.unified.contentassist.UnifiedContentAssistProcessor;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import com.aptana.ide.metadata.ElementMetadata;
import com.aptana.ide.metadata.EventMetadata;
import com.aptana.ide.metadata.FieldMetadata;
import com.aptana.ide.metadata.IMetadataEnvironment;
import com.aptana.ide.metadata.MetadataEnvironment;
import com.aptana.ide.metadata.MetadataRuntimeEnvironment;
import com.aptana.ide.metadata.ValueMetadata;
import com.aptana.ide.parsing.IOffsetMapper;
import com.aptana.ide.parsing.IParseState;
import com.aptana.ide.parsing.nodes.IParseNode;
import com.aptana.ide.parsing.nodes.ParseNodeAttribute;
import com.aptana.ide.parsing.xpath.ParseNodeXPath;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.filechooser.FileSystemView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.jaxen.JaxenException;

public class XMLContentAssistProcessor
extends UnifiedContentAssistProcessor
implements IContentAssistProcessor {
    private IContextInformationValidator validator;
    public static Hashtable usage = new Hashtable();
    public static Image[] NO_BROWSER_IMAGES = new Image[0];
    private static Image fIconField = UnifiedEditorsPlugin.getImage((String)"icons/field_public.gif");
    private static Image fIconFieldGuess = UnifiedEditorsPlugin.getImage((String)"icons/field_public_guess.gif");
    private static Image fIconTag = UnifiedEditorsPlugin.getImage((String)"icons/html_tag.gif");
    private static Image fIconEvent = UnifiedEditorsPlugin.getImage((String)"icons/event.gif");
    private static Image fIconFile = UnifiedEditorsPlugin.getImage((String)"icons/file.gif");
    private static Image fIconFolder = UnifiedEditorsPlugin.getImage((String)"icons/folder.gif");
    private XMLCompletionProposalComparator contentAssistComparator;
    private String AUTO_ADDED = "Auto-added from environment";
    public static String ERROR = "ERROR";
    public static String OUTSIDE_ELEMENT = "OUTSIDE_ELEMENT";
    public static String INSIDE_OPEN_ELEMENT = "INSIDE_OPEN_ELEMENT";
    public static String INSIDE_END_TAG = "INSIDE_END_TAG";
    private EditorFileContext context;
    private Hashtable additionalProposals = new Hashtable();

    public XMLContentAssistProcessor(EditorFileContext context) {
        this.context = context;
        this.contentAssistComparator = new XMLCompletionProposalComparator();
        this.validator = new XMLContextInformationValidator(this);
    }

    public ICompletionProposal[] computeInnerCompletionProposals(ITextViewer viewer, int offset, int position, LexemeList lexemeList, char activationChar, char previousChar) {
        IMetadataEnvironment environment = this.getEnvironment(lexemeList, offset);
        this.additionalProposals.clear();
        XMLContextLocation currentLocation = this.getLocation(offset, lexemeList);
        String tagPrefix = currentLocation.getTagName();
        ICompletionProposal[] result = null;
        if (this.unifiedViewer != null && this.unifiedViewer.isHotkeyActivated()) {
            this.unifiedViewer.setHotkeyActivated(false);
            activationChar = DEFAULT_CHARACTER;
        }
        if (position < 0) {
            return null;
        }
        Lexeme currentLexeme = lexemeList.get(position);
        if (currentLocation.getLocation().equals(ERROR)) {
            return result;
        }
        if (currentLocation.getLocation().equals(INSIDE_END_TAG) && currentLocation.getAttributes().size() == 0) {
            return this.getTagCompletionProposals(tagPrefix, previousChar, offset, currentLexeme, lexemeList, environment);
        }
        if (currentLocation.getLocation().equals(OUTSIDE_ELEMENT) && previousChar == '/') {
            return this.getTagCompletionProposals("", activationChar, offset, currentLexeme, lexemeList, environment);
        }
        if (currentLocation.getLocation().equals(OUTSIDE_ELEMENT) && (activationChar == '<' || activationChar == DEFAULT_CHARACTER)) {
            return this.getTagCompletionProposals("", previousChar, offset, currentLexeme, lexemeList, environment);
        }
        ArrayList attributes = currentLocation.getAttributes();
        String attributePrefix = null;
        String valuePrefix = null;
        if (attributes.size() > 0) {
            KeyValuePair attribute = (KeyValuePair)attributes.get(attributes.size() - 1);
            attributePrefix = (String)attribute.getKey();
            valuePrefix = (String)attribute.getValue();
        }
        if (currentLocation.getLocation().equals(INSIDE_OPEN_ELEMENT)) {
            if ((previousChar == ' ' || previousChar == '\t') && tagPrefix != null) {
                if (XMLUtils.insideQuotedString(currentLexeme, offset)) {
                    return null;
                }
                attributePrefix = "";
                if (currentLexeme.getCategoryIndex() != 0) {
                    valuePrefix = null;
                }
            }
            if (attributePrefix == null || currentLexeme.typeIndex == 40 && currentLexeme.containsOffset(offset)) {
                result = this.getTagCompletionProposals(tagPrefix, previousChar, offset, currentLexeme, lexemeList, environment);
            } else if (valuePrefix != null) {
                if (valuePrefix.equals("/")) {
                    valuePrefix = "";
                }
                result = this.getAttributeValueCompletionProposals(tagPrefix, attributePrefix, valuePrefix, offset, environment);
                String strippedValue = StringUtils.trimStringQuotes((String)valuePrefix);
                XMLContentAssistProcessor.setSelection((String)strippedValue, (ICompletionProposal[])result);
            } else {
                Lexeme endTag;
                Lexeme startTag = XMLUtils.getTagOpenLexeme(currentLexeme, lexemeList);
                Hashtable attribs = XMLUtils.gatherAttributes(startTag, endTag = XMLUtils.getTagCloseLexeme(currentLexeme, lexemeList), lexemeList);
                boolean attributeQuoted = attribs.get(attributePrefix) != null;
                result = this.getAttributeCompletionProposals(tagPrefix, attributePrefix, previousChar, attributes, attributeQuoted, offset, environment);
                XMLContentAssistProcessor.setSelection((String)attributePrefix.toLowerCase(), (ICompletionProposal[])result);
            }
        }
        return result;
    }

    public ICompletionProposal[] getAttributeValueCompletionProposals(String tagPrefix2, String attributePrefix2, String valuePrefix, int offset, IMetadataEnvironment environment) {
        ICompletionProposal[] props;
        if (tagPrefix2 == null || attributePrefix2 == null) {
            return null;
        }
        String strippedValue = StringUtils.trimStringQuotes((String)valuePrefix);
        ArrayList<Object> completionProposals = new ArrayList<Object>();
        ArrayList<String> addedFields = new ArrayList<String>();
        Hashtable fields = environment.getGlobalFields();
        String tagNameLower = tagPrefix2.toLowerCase();
        String propertyNameLower = attributePrefix2.toLowerCase();
        String valueNameLower = strippedValue.toLowerCase();
        int beginOffset = XMLContentAssistProcessor.getOffsetForInsertion(this.getXMLOffsetMapper().getCurrentLexeme(), offset);
        int replaceLength = valueNameLower.length();
        Lexeme curLexeme = this.getXMLOffsetMapper().getCurrentLexeme();
        if (curLexeme.getCategoryIndex() == 0) {
            beginOffset = curLexeme.offset;
        }
        if (valuePrefix.startsWith("\"") || valuePrefix.startsWith("'")) {
            ++beginOffset;
        }
        int sortingType = 1;
        ElementMetadata em = environment.getElement(tagNameLower);
        FieldMetadata fm = null;
        if (em == null) {
            fm = (FieldMetadata)fields.get(propertyNameLower);
        } else {
            fm = (FieldMetadata)em.getFields().get(propertyNameLower);
            if (fm == null) {
                fm = (FieldMetadata)fields.get(propertyNameLower);
            }
            if (fm == null) {
                for (String sm : em.getFields().keySet()) {
                    if (!sm.toLowerCase().equals(propertyNameLower)) continue;
                    fm = (FieldMetadata)em.getFields().get(sm);
                    break;
                }
            }
        }
        if (fm != null && (props = this.getFieldMetadataCompletionProposals(em, fm, beginOffset, replaceLength, sortingType, valuePrefix)) != null) {
            completionProposals.addAll(Arrays.asList(props));
        }
        try {
            if (propertyNameLower.equals("src")) {
                ICompletionProposal[] fileProps = this.getFilePathCompletionProposals(valuePrefix, beginOffset, replaceLength, sortingType);
                completionProposals.addAll(Arrays.asList(fileProps));
            }
        }
        catch (Exception ex) {
            IdeLog.logError((Plugin)XMLPlugin.getDefault(), (String)"error computing file path", (Throwable)ex);
        }
        ICompletionProposal[] xPathProps = this.getXPathCompletionProposals(propertyNameLower, beginOffset, replaceLength, sortingType);
        completionProposals.addAll(Arrays.asList(xPathProps));
        if (this.additionalProposals.containsKey(propertyNameLower)) {
            ArrayList addl = (ArrayList)this.additionalProposals.get(fm.getName());
            int i = 0;
            while (i < addl.size()) {
                String s = (String)addl.get(i);
                String trimmedValue = StringUtils.trimStringQuotes((String)StringUtils.trimStringQuotes((String)s));
                if (!trimmedValue.equals("")) {
                    String replaceString = trimmedValue;
                    String displayString = trimmedValue;
                    int cursorPosition = replaceString.length();
                    XMLCompletionProposal cp = new XMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconFieldGuess, displayString, null, "<b>" + trimmedValue + "</b><br>" + this.AUTO_ADDED, sortingType, this.unifiedViewer, null);
                    if (cp != null && !addedFields.contains(s)) {
                        addedFields.add(s);
                        completionProposals.add((Object)cp);
                    }
                }
                ++i;
            }
        }
        ICompletionProposal[] result = completionProposals.toArray(new ICompletionProposal[completionProposals.size()]);
        Arrays.sort(result, this.contentAssistComparator);
        return result;
    }

    public XMLContextLocation getLocation(int offset, LexemeList ll) {
        XMLContextLocation cl = new XMLContextLocation();
        cl.setLocation(OUTSIDE_ELEMENT);
        if (offset == 0) {
            return cl;
        }
        int currentLexemePosition = this.computeCurrentLexemeIndex(offset, ll);
        KeyValuePair currentAttribute = null;
        while (currentLexemePosition >= 0) {
            Lexeme curLexeme = ll.get(currentLexemePosition);
            if (curLexeme.typeIndex == 42) {
                KeyValuePair foundAttribute;
                boolean isAttributeValue = false;
                if (currentLexemePosition > 0) {
                    Lexeme prev = ll.get(currentLexemePosition - 1);
                    if (prev.typeIndex == 29) {
                        isAttributeValue = true;
                    }
                }
                String lexemeText = curLexeme.getText();
                if (isAttributeValue) {
                    currentAttribute = new KeyValuePair((Object)"PLACEHOLDER", (Object)lexemeText);
                } else if (currentAttribute != null) {
                    foundAttribute = cl.find(lexemeText);
                    if (foundAttribute != null) {
                        cl.getAttributes().remove(foundAttribute);
                    }
                    cl.getAttributes().add(0, new KeyValuePair((Object)lexemeText, currentAttribute.getValue()));
                    currentAttribute = null;
                } else {
                    foundAttribute = cl.find(lexemeText);
                    if (foundAttribute != null) {
                        cl.getAttributes().remove(foundAttribute);
                    }
                    cl.getAttributes().add(0, new KeyValuePair((Object)lexemeText, null));
                    currentAttribute = null;
                }
            }
            if (curLexeme.typeIndex == 29 && currentAttribute == null) {
                currentAttribute = new KeyValuePair((Object)"PLACEHOLDER", (Object)"");
            }
            if (curLexeme.typeIndex == 43) {
                currentAttribute = new KeyValuePair((Object)"PLACEHOLDER", (Object)curLexeme.getText());
            }
            if (curLexeme.typeIndex == 40) {
                cl.setTagName(curLexeme.getText().replaceAll("<", ""));
            }
            if (curLexeme.typeIndex == 27) {
                cl.setTagName(curLexeme.getText().replaceAll("</", ""));
                cl.setLocation(INSIDE_END_TAG);
                break;
            }
            if (curLexeme.typeIndex == 30) {
                cl.setLocation(OUTSIDE_ELEMENT);
                break;
            }
            if (curLexeme.typeIndex == 0 && curLexeme.getText().equals("/")) {
                cl.setLocation(ERROR);
                break;
            }
            if (curLexeme.typeIndex == 38 && (curLexeme.containsOffset(offset) || offset > curLexeme.getEndingOffset())) {
                cl.setLocation(OUTSIDE_ELEMENT);
                break;
            }
            if (curLexeme.typeIndex == 40 || curLexeme.typeIndex == 0 && curLexeme.getText().equals("<")) {
                cl.setLocation(INSIDE_OPEN_ELEMENT);
                break;
            }
            --currentLexemePosition;
        }
        return cl;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'<', '/', ' ', '\t', '=', '>'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[]{'='};
    }

    public int[] getCompletionProposalSeparatorLexemes() {
        return new int[]{30, 38, 29, 40, 27};
    }

    public int[] getCompletionProposalIdleActivationTokens() {
        return new int[]{40, 27, 42};
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.validator;
    }

    public String getErrorMessage() {
        return null;
    }

    public static int getOffsetForInsertion(Lexeme curLexeme, int offset) {
        if (curLexeme == null) {
            return offset;
        }
        int beginOffset = offset;
        if (curLexeme.typeIndex == 49) {
            return beginOffset;
        }
        if (curLexeme.getCategoryIndex() == 3 || curLexeme.getCategoryIndex() == 5 || XMLUtils.isStartTag(curLexeme) || XMLUtils.isEndTag(curLexeme)) {
            beginOffset = curLexeme.getStartingOffset();
        }
        return beginOffset;
    }

    public ICompletionProposal[] getAttributeCompletionProposals(String tagPrefix, String attributePrefix, char activationChar, ArrayList addedAttributes, boolean hasAttachedValue, int offset, IMetadataEnvironment environment) {
        if (tagPrefix == null) {
            return null;
        }
        Hashtable<String, XMLCompletionProposal> completionProposals = new Hashtable<String, XMLCompletionProposal>();
        String tagPrefixLower = tagPrefix.toLowerCase();
        String attributePrefixLower = attributePrefix.toLowerCase();
        ElementMetadata em = environment.getElement(tagPrefixLower);
        if (em == null) {
            return null;
        }
        int beginOffset = offset;
        Lexeme curLexeme = this.getXMLOffsetMapper().getCurrentLexeme();
        if (curLexeme.typeIndex == 42) {
            beginOffset = curLexeme.getStartingOffset();
        }
        for (FieldMetadata fm : em.getFields().values()) {
            XMLCompletionProposal cp = this.createFieldProposal(attributePrefixLower, beginOffset, em, fm, hasAttachedValue, environment);
            completionProposals.put(fm.getName(), cp);
        }
        for (EventMetadata evm : em.getEvents().values()) {
            XMLCompletionProposal cp = this.createEventProposal(attributePrefixLower, beginOffset, em, evm, hasAttachedValue, environment);
            completionProposals.put(evm.getName(), cp);
        }
        ICompletionProposal[] result = completionProposals.values().toArray(new ICompletionProposal[completionProposals.size()]);
        Arrays.sort(result, this.contentAssistComparator);
        return result;
    }

    public XMLCompletionProposal createFieldProposal(String attributePrefix, int beginOffset, ElementMetadata em, FieldMetadata fm, boolean hasAttachedValue, IMetadataEnvironment environment) {
        String docText = environment.getFieldDocumentation(fm);
        String replaceString = fm.getName();
        String quoteString = XMLUtils.quoteAttributeValue(this.getPreferenceStore(), "");
        boolean insertEquals = XMLUtils.insertEquals(this.getPreferenceStore());
        if (!hasAttachedValue && insertEquals) {
            replaceString = String.valueOf(replaceString) + "=" + quoteString;
        }
        String displayString = fm.getName();
        int cursorPosition = replaceString.length();
        if (!hasAttachedValue && insertEquals && quoteString.length() == 2) {
            --cursorPosition;
        }
        int replaceLength = attributePrefix.length();
        Image[] userAgents = null;
        userAgents = fm.getUserAgents().length == 0 ? this.getUserAgentImagesA(XMLContentAssistProcessor.getUserAgents(), em.getUserAgentPlatformNames()) : this.getUserAgentImagesA(XMLContentAssistProcessor.getUserAgents(), fm.getUserAgentPlatformNames());
        XMLCompletionProposal cp = new XMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconField, displayString, null, docText, 1, this.unifiedViewer, userAgents);
        return cp;
    }

    public Image[] getUserAgentImagesA(String[] a, String[] b) {
        return new Image[0];
    }

    public XMLCompletionProposal createEventProposal(String attributePrefix, int beginOffset, ElementMetadata em, EventMetadata fm, boolean hasAttachedValue, IMetadataEnvironment environment) {
        String docText = environment.getEventDocumentation(fm);
        String replaceString = fm.getName();
        String quoteString = XMLUtils.quoteAttributeValue(this.getPreferenceStore(), "");
        boolean insertEquals = XMLUtils.insertEquals(this.getPreferenceStore());
        if (!hasAttachedValue && insertEquals) {
            replaceString = String.valueOf(replaceString) + "=" + quoteString;
        }
        String displayString = fm.getName();
        int cursorPosition = replaceString.length();
        int replaceLength = attributePrefix.length();
        if (!hasAttachedValue && insertEquals && quoteString.length() == 2) {
            --cursorPosition;
        }
        Image[] userAgents = null;
        userAgents = fm.getUserAgents().length == 0 ? this.getUserAgentImagesA(XMLContentAssistProcessor.getUserAgents(), em.getUserAgentPlatformNames()) : this.getUserAgentImagesA(XMLContentAssistProcessor.getUserAgents(), fm.getUserAgentPlatformNames());
        XMLCompletionProposal cp = new XMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconEvent, displayString, null, docText, 1, this.unifiedViewer, userAgents);
        return cp;
    }

    public ICompletionProposal[] getTagCompletionProposals(String prefix, char activationChar, int offset, Lexeme currentLexeme, LexemeList lexemeList, IMetadataEnvironment environment) {
        int cursorPosition;
        int replaceLength;
        IParseState parseState = this.context.getParseState();
        XMLParseState htmlParseState = (XMLParseState)parseState.getParseState("text/xml");
        Hashtable<String, XMLCompletionProposal> completionProposals = new Hashtable<String, XMLCompletionProposal>();
        if (currentLexeme == null) {
            return null;
        }
        if (currentLexeme.typeIndex != 49 && !XMLUtils.isStartTag(currentLexeme) && !XMLUtils.isEndTag(currentLexeme)) {
            return null;
        }
        int tagClosedType = XMLUtils.isTagClosed(currentLexeme, lexemeList);
        boolean tagClosed = tagClosedType != 1;
        String textPrefix = XMLUtils.getOpenTagName(currentLexeme, offset);
        if (tagClosed) {
            textPrefix = XMLUtils.getOpenTagName(currentLexeme, currentLexeme.getEndingOffset());
        }
        if (currentLexeme.typeIndex == 49) {
            textPrefix = "";
        }
        String testPrefix = textPrefix.toLowerCase();
        int beginOffset = XMLContentAssistProcessor.getOffsetForInsertion(currentLexeme, offset);
        String[] em = environment != null ? environment.getAllElements() : new String[]{};
        MetadataEnvironment[] environments = ((MetadataRuntimeEnvironment)environment).getEnvironments();
        int i = 0;
        while (i < em.length) {
            String e = em[i];
            String docText = environment.getElementDocumentation(e);
            String displayString = e;
            String replaceString = e;
            replaceLength = textPrefix.length();
            cursorPosition = replaceString.length();
            if (XMLUtils.isEndTag(currentLexeme)) {
                replaceString = tagClosed ? XMLUtils.createOpenTag(replaceString, false) : XMLUtils.createOpenTag(replaceString, true);
                replaceLength = currentLexeme.length;
                cursorPosition = replaceString.length();
            } else {
                boolean insertClosingTags = true;
                if (this.getPreferenceStore() != null) {
                    insertClosingTags = this.getPreferenceStore().getBoolean("com.aptana.ide.editor.xml.AUTO_INSERT_CLOSE_TAGS");
                }
                if (insertClosingTags) {
                    int cursorOffset = 1;
                    boolean empty = true;
                    MetadataEnvironment[] metadataEnvironmentArray = environments;
                    int n = environments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        boolean emptyTag;
                        MetadataEnvironment ea = metadataEnvironmentArray[n2];
                        ElementMetadata element = ea.getElement(e);
                        boolean bl = element instanceof IKnowsChildsMetadata ? !((IKnowsChildsMetadata)element).mayHaveChilds() : (emptyTag = false);
                        if (!emptyTag) {
                            empty = false;
                            break;
                        }
                        ++n2;
                    }
                    boolean isDocType = replaceString != null && replaceString.toLowerCase().startsWith("!doctype");
                    String startString = null;
                    if (empty && !tagClosed) {
                        startString = XMLUtils.createSelfClosedTag(replaceString);
                        cursorOffset = 2;
                    } else {
                        startString = XMLUtils.createOpenTag(replaceString, !tagClosed);
                    }
                    cursorPosition = startString.length();
                    if (!(tagClosed || XMLUtils.isStartTagBalanced(currentLexeme, lexemeList, htmlParseState) || empty || isDocType)) {
                        replaceString = String.valueOf(startString) + XMLUtils.createCloseTag(replaceString, true);
                        cursorOffset = 1;
                    } else {
                        replaceString = startString;
                    }
                    if (!tagClosed) {
                        cursorPosition -= cursorOffset;
                    }
                } else {
                    replaceString = XMLUtils.createOpenTag(replaceString, false);
                    cursorPosition = replaceString.length();
                }
                if (currentLexeme.typeIndex != 49) {
                    ++replaceLength;
                }
            }
            XMLCompletionProposal cp = new XMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconTag, displayString, null, docText, 1, this.unifiedViewer, this.getUserAgentImagesA(XMLContentAssistProcessor.getUserAgents(), environment.getUserAgentPlatformNames(e)));
            completionProposals.put(displayString, cp);
            ++i;
        }
        boolean addedCloseTag = false;
        Lexeme unclosed = XMLUtils.getPreviousUnclosedTag(currentLexeme, lexemeList, htmlParseState);
        if (unclosed != null && !XMLUtils.isStartTagBalanced(unclosed, lexemeList, htmlParseState)) {
            String displayString;
            String replaceString = displayString = XMLUtils.stripTagEndings(unclosed.getText());
            boolean emptyTag = false;
            if (!emptyTag) {
                addedCloseTag = true;
                replaceString = tagClosed ? XMLUtils.createCloseTag(replaceString, false) : XMLUtils.createCloseTag(replaceString, true);
                replaceLength = this.getReplaceLengthByLexeme(currentLexeme, activationChar);
                cursorPosition = replaceString.length();
                displayString = "/" + displayString;
                ElementMetadata elementMetadata = new ElementMetadata();
                elementMetadata.setFullName(displayString);
                elementMetadata.setName(displayString);
                ElementMetadata e = environment != null ? environment.getElement(unclosed) : elementMetadata;
                String docText = null;
                if (e != null) {
                    docText = environment != null ? environment.getElementDocumentation(e.getName()) : "";
                }
                XMLCompletionProposal cp = new XMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconTag, displayString, null, docText, 1, this.unifiedViewer, NO_BROWSER_IMAGES);
                completionProposals.put(displayString, cp);
            }
        }
        ICompletionProposal[] result = completionProposals.values().toArray(new ICompletionProposal[completionProposals.size()]);
        Arrays.sort(result, this.contentAssistComparator);
        if (XMLUtils.isEndTag(currentLexeme) && addedCloseTag) {
            XMLContentAssistProcessor.setSelection((String)("/" + testPrefix), (ICompletionProposal[])result);
        } else {
            XMLContentAssistProcessor.setSelection((String)testPrefix, (ICompletionProposal[])result);
        }
        return result;
    }

    public IOffsetMapper getOffsetMapper() {
        IFileLanguageService ls = this.context.getLanguageService("text/xml");
        if (ls != null) {
            return ls.getOffsetMapper();
        }
        return null;
    }

    public XMLOffsetMapper getXMLOffsetMapper() {
        return (XMLOffsetMapper)this.getOffsetMapper();
    }

    protected IPreferenceStore getPreferenceStore() {
        if (PluginUtils.isPluginLoaded((Plugin)XMLPlugin.getDefault())) {
            return XMLPlugin.getDefault().getPreferenceStore();
        }
        return null;
    }

    public IContextInformation[] computeInnerContextInformation(String documentSource, int offset, int position, LexemeList lexemeList) {
        IMetadataEnvironment environment = this.getEnvironment(lexemeList, offset);
        IContextInformation[] ici = null;
        XMLContextLocation currentLocation = this.getLocation(offset, lexemeList);
        String tagPrefix = currentLocation.getTagName();
        if (tagPrefix == null) {
            return null;
        }
        Hashtable fields = environment.getGlobalFields();
        ArrayList attributes = currentLocation.getAttributes();
        if (attributes.size() == 0) {
            return null;
        }
        KeyValuePair attribute = (KeyValuePair)attributes.get(attributes.size() - 1);
        String propertyNameLower = ((String)attribute.getKey()).toLowerCase();
        FieldMetadata fm = (FieldMetadata)fields.get(propertyNameLower);
        if (fm == null || fm.getValues().size() > 0) {
            return null;
        }
        ContextInformation ci = new ContextInformation("contextDisplayString", fm.getDescription());
        if (ci != null) {
            ici = new IContextInformation[]{ci};
        }
        return ici;
    }

    private IMetadataEnvironment getEnvironment(LexemeList lexemeList, int offset) {
        return XMLEnvironmentRegistry.getEnvironment(lexemeList, offset);
    }

    public Comparator getProposalComparator() {
        return this.contentAssistComparator;
    }

    private ICompletionProposal[] getFilePathCompletionProposals(String valuePrefix, int beginOffset, int replaceLength, int sortingType) {
        File[] files;
        String s;
        ArrayList<XMLCompletionProposal> completionProposals = new ArrayList<XMLCompletionProposal>();
        HashMap ht = new HashMap();
        IEditorInput pathEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        String urlPrefix = null;
        if (pathEditor instanceof FileEditorInput) {
            urlPrefix = this.getProjectContextRoot(pathEditor);
        }
        String editorPath = CoreUIUtils.getPathFromEditorInput((IEditorInput)pathEditor);
        if (urlPrefix != null && !"".equals(urlPrefix) && valuePrefix != null && valuePrefix.indexOf(47) == 1) {
            editorPath = urlPrefix;
        }
        String currentPath = editorPath;
        if (valuePrefix != null && !"".equals(s = StringUtils.trimStringQuotes((String)valuePrefix))) {
            File current = new File(currentPath);
            currentPath = current.isDirectory() ? String.valueOf(currentPath) + s : String.valueOf(current.getParent().toString()) + File.separator + s;
        }
        if ((files = FileUtils.getFilesInDirectory((File)new File(currentPath))) == null) {
            return new ICompletionProposal[0];
        }
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (!f.getName().startsWith(".")) {
                String fileType = "";
                try {
                    fileType = FileSystemView.getFileSystemView().getSystemTypeDescription(f);
                }
                catch (Exception ex) {
                    IdeLog.logError((Plugin)XMLPlugin.getDefault(), (String)"Type Description Error", (Throwable)ex);
                }
                if (!f.toString().equals(editorPath)) {
                    Image image = null;
                    if (fileType != null) {
                        image = (Image)ht.get(fileType);
                    }
                    if (image == null) {
                        image = fIconFile;
                        if (f.isDirectory()) {
                            image = fIconFolder;
                        }
                    }
                    String replaceString = FileUtils.makeFilePathRelative((File)new File(editorPath), (File)f);
                    replaceString = replaceString.replaceAll("\\\\", "/");
                    String displayString = CoreUIUtils.getPathFromURI((String)replaceString);
                    int cursorPosition = replaceString.length();
                    XMLCompletionProposal cp = new XMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, image, displayString, null, f.toString(), sortingType, this.unifiedViewer, new Image[0]);
                    if (cp != null) {
                        completionProposals.add(cp);
                    }
                }
            }
            ++i;
        }
        return completionProposals.toArray(new ICompletionProposal[0]);
    }

    private String getProjectContextRoot(IEditorInput input) {
        String urlPrefix = null;
        FileEditorInput fei = (FileEditorInput)input;
        IFile file = fei.getFile();
        IProject project = file.getProject();
        urlPrefix = project.getLocation().toOSString();
        return urlPrefix;
    }

    public ICompletionProposal[] getXPathCompletionProposals(String attributeName, int offset, int replaceLength, int sortingType) {
        ArrayList<XMLCompletionProposal> completionProposals = new ArrayList<XMLCompletionProposal>();
        IParseNode root = this.context.getParseState().getRoot().getParseResults();
        String editors = null;
        if (this.getPreferenceStore() != null) {
            editors = this.getPreferenceStore().getString("com.aptana.ide.editors.CODE_ASSIST_EXPRESSIONS");
        }
        CodeAssistExpression[] expressions = CodeAssistExpression.deserializeErrorDescriptors(editors);
        int i = 0;
        while (i < expressions.length) {
            CodeAssistExpression expression = expressions[i];
            if (attributeName.matches(expression.getExpression())) {
                try {
                    ParseNodeXPath xpath = new ParseNodeXPath(expression.getXPath());
                    Object result = xpath.evaluate((Object)root);
                    if (result instanceof List) {
                        List xpathResult = (List)result;
                        for (Object element : xpathResult) {
                            int cursorPosition;
                            ParseNodeAttribute pna;
                            String replaceString;
                            XMLCompletionProposal cp;
                            if (!(element instanceof ParseNodeAttribute) || (cp = new XMLCompletionProposal(replaceString = (pna = (ParseNodeAttribute)element).getValue(), offset, replaceLength, cursorPosition = replaceString.length(), fIconFieldGuess, replaceString, null, "<b>" + replaceString + "</b><br>" + this.AUTO_ADDED, sortingType, this.unifiedViewer, null)) == null) continue;
                            completionProposals.add(cp);
                        }
                    }
                }
                catch (JaxenException e) {
                    IdeLog.logError((Plugin)XMLPlugin.getDefault(), (String)e.getMessage());
                }
            }
            ++i;
        }
        return completionProposals.toArray(new ICompletionProposal[0]);
    }

    private ICompletionProposal[] getFieldMetadataCompletionProposals(ElementMetadata em, FieldMetadata fm, int beginOffset, int replaceLength, int sortingType, String valuePrefix) {
        ArrayList<XMLCompletionProposal> completionProposals = new ArrayList<XMLCompletionProposal>();
        ArrayList values = fm.getValues();
        if (fm instanceof IProvidingCompletionMetadata) {
            IProvidingCompletionMetadata cm = (IProvidingCompletionMetadata)fm;
            String sourceURI = this.context.getSourceProvider().getSourceURI();
            try {
                URL url = new URL(sourceURI);
                String file = url.getFile();
                String path = new File(file).getAbsolutePath();
                values.addAll(cm.getFieldMetadataCompletionProposals(em, fm, valuePrefix, path));
            }
            catch (MalformedURLException e) {
                IdeLog.logError((Plugin)XMLPlugin.getDefault(), (String)e.getMessage(), (Throwable)e);
            }
        }
        int i = 0;
        while (i < values.size()) {
            ValueMetadata value = (ValueMetadata)fm.getValues().get(i);
            if (value.getName() != "*") {
                String docText = "";
                docText = MetadataEnvironment.getValueDocumentation((ValueMetadata)value);
                String replaceString = value.getName();
                String displayString = value.getName();
                if (replaceString.equals("*")) {
                    replaceString = "";
                }
                int cursorPosition = replaceString.length();
                Image[] userAgents = null;
                userAgents = value.getUserAgents().length == 0 && fm.getUserAgents().length == 0 ? this.getUserAgentImagesA(XMLContentAssistProcessor.getUserAgents(), em.getUserAgentPlatformNames()) : (value.getUserAgents().length == 0 ? this.getUserAgentImagesA(XMLContentAssistProcessor.getUserAgents(), fm.getUserAgentPlatformNames()) : this.getUserAgentImagesA(XMLContentAssistProcessor.getUserAgents(), value.getUserAgentPlatformNames()));
                XMLCompletionProposal cp = new XMLCompletionProposal(replaceString, beginOffset, replaceLength, cursorPosition, fIconField, displayString, null, docText, sortingType, this.unifiedViewer, userAgents);
                if (cp != null) {
                    completionProposals.add(cp);
                }
            }
            ++i;
        }
        return completionProposals.toArray(new ICompletionProposal[0]);
    }

    private int getReplaceLengthByLexeme(Lexeme lexeme, char activationChar) {
        String text = lexeme.getText();
        String trimmed = text.trim();
        int result = trimmed.length();
        if (activationChar == '\u0000' && lexeme.typeIndex == 27) {
            result = Math.max(result, 2);
        }
        return result;
    }
}

