/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.formatting;

import com.aptana.ide.editor.xml.XMLPlugin;
import com.aptana.ide.ui.editors.preferences.formatter.DefaultCodeFormatterConstants;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;

public class XMLCodeFormatterOptions {
    public String formatterTabChar;
    public int tabSize;
    public int spacesInMultiline;
    public final HashSet notWrappingTags = new HashSet();
    public final HashSet allwaysWrap = new HashSet();
    public boolean doFormatting = true;
    public boolean preserveReturns = true;
    public boolean preserveWhitespacesInCDATA = true;
    public boolean doNotWrapSimple = true;

    public XMLCodeFormatterOptions() {
        this.initFromPreferences();
    }

    public static Map createNotWrappingOptions() {
        Map map = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        map.put("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration", Boolean.TRUE);
        map.put("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns2", "a,b");
        return map;
    }

    public static Map createNotPreservingReturnsOptions() {
        Map map = DefaultCodeFormatterConstants.getJavaConventionsSettings();
        map.put("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns", Boolean.FALSE);
        return map;
    }

    private void initFromPreferences() {
        IPreferenceStore preferenceStore = XMLPlugin.getDefault().getPreferenceStore();
        this.formatterTabChar = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
        this.tabSize = preferenceStore.getInt("com.aptana.ide.editors.codeassist.formatter.tabulation.size");
        this.spacesInMultiline = preferenceStore.getInt("com.aptana.ide.editors.codeassist.formatter.alignment_for_multiple_fields");
        String sm = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns2");
        this.initTags(sm, this.notWrappingTags);
        sm = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.wraptags2");
        this.initTags(sm, this.allwaysWrap);
        String string = preferenceStore.getString("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant");
        if (string.length() > 0) {
            this.doFormatting = false;
        }
        this.preserveReturns = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns");
        this.preserveWhitespacesInCDATA = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.preserveWhitespaceinCDATA");
        this.doNotWrapSimple = preferenceStore.getBoolean("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration");
    }

    private void initTags(String sm, HashSet set) {
        if (sm == null) {
            return;
        }
        String[] nodes = sm.split(",");
        int i = 0;
        while (i < nodes.length) {
            String trim = nodes[i].trim();
            if (trim.length() > 0) {
                set.add(trim);
            }
            ++i;
        }
    }

    public XMLCodeFormatterOptions(Map map, IProject project) {
        if (project != null) {
            IEclipsePreferences preferences = new ProjectScope(project).getNode(XMLPlugin.getDefault().getBundle().getSymbolicName());
            String string = preferences.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size", null);
            if (string == null) {
                this.initFromPreferences();
                return;
            }
            this.formatterTabChar = preferences.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char", "");
            String sm = preferences.get("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns2", "a,span,i,b,em,strong,h1,h2,h3,h4,h5,h6,title,option");
            this.initTags(sm, this.notWrappingTags);
            sm = preferences.get("com.aptana.ide.editors.codeassist.formatter.wraptags2", "doctype,br,link,meta");
            this.initTags(sm, this.allwaysWrap);
            this.tabSize = Integer.parseInt(string);
            string = preferences.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size", "1");
            if (string != null) {
                this.spacesInMultiline = Integer.parseInt(string);
            }
            if ((string = preferences.get("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant", "")).length() > 0) {
                this.doFormatting = false;
            }
            this.preserveReturns = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns", true);
            this.preserveWhitespacesInCDATA = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.preserveWhitespaceinCDATA", true);
            this.doNotWrapSimple = preferences.getBoolean("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration", true);
        } else if (map == null) {
            this.initFromPreferences();
        } else {
            Object object21a;
            Object object20a;
            Object object19a;
            Object object10;
            this.formatterTabChar = (String)map.get("com.aptana.ide.editors.codeassist.formatter.tabulation.char");
            String sm = (String)map.get("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns2");
            this.initTags(sm, this.notWrappingTags);
            sm = (String)map.get("com.aptana.ide.editors.codeassist.formatter.wraptags2");
            this.initTags(sm, this.allwaysWrap);
            if (this.formatterTabChar == null) {
                this.formatterTabChar = " ";
            }
            this.tabSize = (object10 = map.get("com.aptana.ide.editors.codeassist.formatter.tabulation.size")) != null ? Integer.parseInt(object10.toString()) : 4;
            Object object11 = map.get("com.aptana.ide.editors.codeassist.formatter.alignment_for_multiple_fields");
            this.spacesInMultiline = object11 != null ? Integer.parseInt(object11.toString()) : 1;
            String sma = (String)map.get("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_enum_constant");
            if (sma != null && sma.length() > 0) {
                this.doFormatting = false;
            }
            if ((object19a = map.get("com.aptana.ide.editors.codeassist.formatter.preserve_extra_carriage_returns")) != null) {
                this.preserveReturns = Boolean.parseBoolean(object19a.toString());
            }
            if ((object20a = map.get("com.aptana.ide.editors.codeassist.formatter.preserveWhitespaceinCDATA")) != null) {
                this.preserveWhitespacesInCDATA = Boolean.parseBoolean(object20a.toString());
            }
            if ((object21a = map.get("com.aptana.ide.editors.codeassist.formatter.insert_space_between_empty_parens_in_annotation_type_member_declaration")) != null) {
                this.doNotWrapSimple = Boolean.parseBoolean(object21a.toString());
            }
        }
    }
}

